/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTranscriptionJobRequest extends TranscribeRequest implements
        ToCopyableBuilder<StartTranscriptionJobRequest.Builder, StartTranscriptionJobRequest> {
    private static final SdkField<String> TRANSCRIPTION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TranscriptionJobName").getter(getter(StartTranscriptionJobRequest::transcriptionJobName))
            .setter(setter(Builder::transcriptionJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobName").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(StartTranscriptionJobRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MediaSampleRateHertz").getter(getter(StartTranscriptionJobRequest::mediaSampleRateHertz))
            .setter(setter(Builder::mediaSampleRateHertz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRateHertz").build())
            .build();

    private static final SdkField<String> MEDIA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaFormat").getter(getter(StartTranscriptionJobRequest::mediaFormatAsString))
            .setter(setter(Builder::mediaFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaFormat").build()).build();

    private static final SdkField<Media> MEDIA_FIELD = SdkField.<Media> builder(MarshallingType.SDK_POJO).memberName("Media")
            .getter(getter(StartTranscriptionJobRequest::media)).setter(setter(Builder::media)).constructor(Media::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()).build();

    private static final SdkField<String> OUTPUT_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputBucketName").getter(getter(StartTranscriptionJobRequest::outputBucketName))
            .setter(setter(Builder::outputBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucketName").build()).build();

    private static final SdkField<String> OUTPUT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputKey").getter(getter(StartTranscriptionJobRequest::outputKey)).setter(setter(Builder::outputKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKey").build()).build();

    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputEncryptionKMSKeyId").getter(getter(StartTranscriptionJobRequest::outputEncryptionKMSKeyId))
            .setter(setter(Builder::outputEncryptionKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build())
            .build();

    private static final SdkField<Map<String, String>> KMS_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("KMSEncryptionContext")
            .getter(getter(StartTranscriptionJobRequest::kmsEncryptionContext))
            .setter(setter(Builder::kmsEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncryptionContext").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Settings> SETTINGS_FIELD = SdkField.<Settings> builder(MarshallingType.SDK_POJO)
            .memberName("Settings").getter(getter(StartTranscriptionJobRequest::settings)).setter(setter(Builder::settings))
            .constructor(Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<ModelSettings> MODEL_SETTINGS_FIELD = SdkField
            .<ModelSettings> builder(MarshallingType.SDK_POJO).memberName("ModelSettings")
            .getter(getter(StartTranscriptionJobRequest::modelSettings)).setter(setter(Builder::modelSettings))
            .constructor(ModelSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSettings").build()).build();

    private static final SdkField<JobExecutionSettings> JOB_EXECUTION_SETTINGS_FIELD = SdkField
            .<JobExecutionSettings> builder(MarshallingType.SDK_POJO).memberName("JobExecutionSettings")
            .getter(getter(StartTranscriptionJobRequest::jobExecutionSettings)).setter(setter(Builder::jobExecutionSettings))
            .constructor(JobExecutionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobExecutionSettings").build())
            .build();

    private static final SdkField<ContentRedaction> CONTENT_REDACTION_FIELD = SdkField
            .<ContentRedaction> builder(MarshallingType.SDK_POJO).memberName("ContentRedaction")
            .getter(getter(StartTranscriptionJobRequest::contentRedaction)).setter(setter(Builder::contentRedaction))
            .constructor(ContentRedaction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedaction").build()).build();

    private static final SdkField<Boolean> IDENTIFY_LANGUAGE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IdentifyLanguage").getter(getter(StartTranscriptionJobRequest::identifyLanguage))
            .setter(setter(Builder::identifyLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifyLanguage").build()).build();

    private static final SdkField<Boolean> IDENTIFY_MULTIPLE_LANGUAGES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("IdentifyMultipleLanguages")
            .getter(getter(StartTranscriptionJobRequest::identifyMultipleLanguages))
            .setter(setter(Builder::identifyMultipleLanguages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifyMultipleLanguages").build())
            .build();

    private static final SdkField<List<String>> LANGUAGE_OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LanguageOptions")
            .getter(getter(StartTranscriptionJobRequest::languageOptionsAsStrings))
            .setter(setter(Builder::languageOptionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Subtitles> SUBTITLES_FIELD = SdkField.<Subtitles> builder(MarshallingType.SDK_POJO)
            .memberName("Subtitles").getter(getter(StartTranscriptionJobRequest::subtitles)).setter(setter(Builder::subtitles))
            .constructor(Subtitles::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subtitles").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartTranscriptionJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, LanguageIdSettings>> LANGUAGE_ID_SETTINGS_FIELD = SdkField
            .<Map<String, LanguageIdSettings>> builder(MarshallingType.MAP)
            .memberName("LanguageIdSettings")
            .getter(getter(StartTranscriptionJobRequest::languageIdSettingsAsStrings))
            .setter(setter(Builder::languageIdSettingsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageIdSettings").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LanguageIdSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(LanguageIdSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ToxicityDetectionSettings>> TOXICITY_DETECTION_FIELD = SdkField
            .<List<ToxicityDetectionSettings>> builder(MarshallingType.LIST)
            .memberName("ToxicityDetection")
            .getter(getter(StartTranscriptionJobRequest::toxicityDetection))
            .setter(setter(Builder::toxicityDetection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToxicityDetection").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ToxicityDetectionSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(ToxicityDetectionSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPTION_JOB_NAME_FIELD,
            LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_FORMAT_FIELD, MEDIA_FIELD, OUTPUT_BUCKET_NAME_FIELD,
            OUTPUT_KEY_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD, KMS_ENCRYPTION_CONTEXT_FIELD, SETTINGS_FIELD,
            MODEL_SETTINGS_FIELD, JOB_EXECUTION_SETTINGS_FIELD, CONTENT_REDACTION_FIELD, IDENTIFY_LANGUAGE_FIELD,
            IDENTIFY_MULTIPLE_LANGUAGES_FIELD, LANGUAGE_OPTIONS_FIELD, SUBTITLES_FIELD, TAGS_FIELD, LANGUAGE_ID_SETTINGS_FIELD,
            TOXICITY_DETECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String transcriptionJobName;

    private final String languageCode;

    private final Integer mediaSampleRateHertz;

    private final String mediaFormat;

    private final Media media;

    private final String outputBucketName;

    private final String outputKey;

    private final String outputEncryptionKMSKeyId;

    private final Map<String, String> kmsEncryptionContext;

    private final Settings settings;

    private final ModelSettings modelSettings;

    private final JobExecutionSettings jobExecutionSettings;

    private final ContentRedaction contentRedaction;

    private final Boolean identifyLanguage;

    private final Boolean identifyMultipleLanguages;

    private final List<String> languageOptions;

    private final Subtitles subtitles;

    private final List<Tag> tags;

    private final Map<String, LanguageIdSettings> languageIdSettings;

    private final List<ToxicityDetectionSettings> toxicityDetection;

    private StartTranscriptionJobRequest(BuilderImpl builder) {
        super(builder);
        this.transcriptionJobName = builder.transcriptionJobName;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaFormat = builder.mediaFormat;
        this.media = builder.media;
        this.outputBucketName = builder.outputBucketName;
        this.outputKey = builder.outputKey;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
        this.kmsEncryptionContext = builder.kmsEncryptionContext;
        this.settings = builder.settings;
        this.modelSettings = builder.modelSettings;
        this.jobExecutionSettings = builder.jobExecutionSettings;
        this.contentRedaction = builder.contentRedaction;
        this.identifyLanguage = builder.identifyLanguage;
        this.identifyMultipleLanguages = builder.identifyMultipleLanguages;
        this.languageOptions = builder.languageOptions;
        this.subtitles = builder.subtitles;
        this.tags = builder.tags;
        this.languageIdSettings = builder.languageIdSettings;
        this.toxicityDetection = builder.toxicityDetection;
    }

    /**
     * <p>
     * A unique name, chosen by you, for your transcription job. The name that you specify is also used as the default
     * name of your transcription output file. If you want to specify a different name for your transcription output,
     * use the <code>OutputKey</code> parameter.
     * </p>
     * <p>
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If
     * you try to create a new job with the same name as an existing job, you get a <code>ConflictException</code>
     * error.
     * </p>
     * 
     * @return A unique name, chosen by you, for your transcription job. The name that you specify is also used as the
     *         default name of your transcription output file. If you want to specify a different name for your
     *         transcription output, use the <code>OutputKey</code> parameter.</p>
     *         <p>
     *         This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services
     *         account. If you try to create a new job with the same name as an existing job, you get a
     *         <code>ConflictException</code> error.
     */
    public final String transcriptionJobName() {
        return transcriptionJobName;
    }

    /**
     * <p>
     * The language code that represents the language spoken in the input media file.
     * </p>
     * <p>
     * If you're unsure of the language spoken in your media file, consider using <code>IdentifyLanguage</code> or
     * <code>IdentifyMultipleLanguages</code> to enable automatic language identification.
     * </p>
     * <p>
     * Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
     * <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your
     * transcription job fails.
     * </p>
     * <p>
     * For a list of supported languages and their associated language codes, refer to the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.
     * </p>
     * <note>
     * <p>
     * To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>) in Amazon Web Services GovCloud (US)
     * (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), Canada (Calgary, ca-west-1)
     * and Africa (Cape Town, af-south-1), your media file must be encoded at a sample rate of 16,000 Hz or higher.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code that represents the language spoken in the input media file.</p>
     *         <p>
     *         If you're unsure of the language spoken in your media file, consider using <code>IdentifyLanguage</code>
     *         or <code>IdentifyMultipleLanguages</code> to enable automatic language identification.
     *         </p>
     *         <p>
     *         Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
     *         <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters,
     *         your transcription job fails.
     *         </p>
     *         <p>
     *         For a list of supported languages and their associated language codes, refer to the <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>
     *         table.
     *         </p>
     *         <note>
     *         <p>
     *         To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>) in Amazon Web Services GovCloud (US)
     *         (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), Canada (Calgary,
     *         ca-west-1) and Africa (Cape Town, af-south-1), your media file must be encoded at a sample rate of 16,000
     *         Hz or higher.
     *         </p>
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code that represents the language spoken in the input media file.
     * </p>
     * <p>
     * If you're unsure of the language spoken in your media file, consider using <code>IdentifyLanguage</code> or
     * <code>IdentifyMultipleLanguages</code> to enable automatic language identification.
     * </p>
     * <p>
     * Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
     * <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your
     * transcription job fails.
     * </p>
     * <p>
     * For a list of supported languages and their associated language codes, refer to the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.
     * </p>
     * <note>
     * <p>
     * To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>) in Amazon Web Services GovCloud (US)
     * (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), Canada (Calgary, ca-west-1)
     * and Africa (Cape Town, af-south-1), your media file must be encoded at a sample rate of 16,000 Hz or higher.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code that represents the language spoken in the input media file.</p>
     *         <p>
     *         If you're unsure of the language spoken in your media file, consider using <code>IdentifyLanguage</code>
     *         or <code>IdentifyMultipleLanguages</code> to enable automatic language identification.
     *         </p>
     *         <p>
     *         Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
     *         <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters,
     *         your transcription job fails.
     *         </p>
     *         <p>
     *         For a list of supported languages and their associated language codes, refer to the <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>
     *         table.
     *         </p>
     *         <note>
     *         <p>
     *         To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>) in Amazon Web Services GovCloud (US)
     *         (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), Canada (Calgary,
     *         ca-west-1) and Africa (Cape Town, af-south-1), your media file must be encoded at a sample rate of 16,000
     *         Hz or higher.
     *         </p>
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The sample rate, in hertz, of the audio track in your input media file.
     * </p>
     * <p>
     * If you do not specify the media sample rate, Amazon Transcribe determines it for you. If you specify the sample
     * rate, it must match the rate detected by Amazon Transcribe. If there's a mismatch between the value that you
     * specify and the value detected, your job fails. In most cases, you can omit <code>MediaSampleRateHertz</code> and
     * let Amazon Transcribe determine the sample rate.
     * </p>
     * 
     * @return The sample rate, in hertz, of the audio track in your input media file.</p>
     *         <p>
     *         If you do not specify the media sample rate, Amazon Transcribe determines it for you. If you specify the
     *         sample rate, it must match the rate detected by Amazon Transcribe. If there's a mismatch between the
     *         value that you specify and the value detected, your job fails. In most cases, you can omit
     *         <code>MediaSampleRateHertz</code> and let Amazon Transcribe determine the sample rate.
     */
    public final Integer mediaSampleRateHertz() {
        return mediaSampleRateHertz;
    }

    /**
     * <p>
     * Specify the format of your input media file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaFormat} will
     * return {@link MediaFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaFormatAsString}.
     * </p>
     * 
     * @return Specify the format of your input media file.
     * @see MediaFormat
     */
    public final MediaFormat mediaFormat() {
        return MediaFormat.fromValue(mediaFormat);
    }

    /**
     * <p>
     * Specify the format of your input media file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaFormat} will
     * return {@link MediaFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaFormatAsString}.
     * </p>
     * 
     * @return Specify the format of your input media file.
     * @see MediaFormat
     */
    public final String mediaFormatAsString() {
        return mediaFormat;
    }

    /**
     * <p>
     * Describes the Amazon S3 location of the media file you want to use in your request.
     * </p>
     * 
     * @return Describes the Amazon S3 location of the media file you want to use in your request.
     */
    public final Media media() {
        return media;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket where you want your transcription output stored. Do not include the
     * <code>S3://</code> prefix of the specified bucket.
     * </p>
     * <p>
     * If you want your output to go to a sub-folder of this bucket, specify it using the <code>OutputKey</code>
     * parameter; <code>OutputBucketName</code> only accepts the name of a bucket.
     * </p>
     * <p>
     * For example, if you want your output stored in <code>S3://DOC-EXAMPLE-BUCKET</code>, set
     * <code>OutputBucketName</code> to <code>DOC-EXAMPLE-BUCKET</code>. However, if you want your output stored in
     * <code>S3://DOC-EXAMPLE-BUCKET/test-files/</code>, set <code>OutputBucketName</code> to
     * <code>DOC-EXAMPLE-BUCKET</code> and <code>OutputKey</code> to <code>test-files/</code>.
     * </p>
     * <p>
     * Note that Amazon Transcribe must have permission to use the specified location. You can change Amazon S3
     * permissions using the <a href="https://console.aws.amazon.com/s3">Amazon Web Services Management Console</a>. See
     * also <a href=
     * "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
     * >Permissions Required for IAM User Roles</a>.
     * </p>
     * <p>
     * If you do not specify <code>OutputBucketName</code>, your transcript is placed in a service-managed Amazon S3
     * bucket and you are provided with a URI to access your transcript.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket where you want your transcription output stored. Do not include the
     *         <code>S3://</code> prefix of the specified bucket.</p>
     *         <p>
     *         If you want your output to go to a sub-folder of this bucket, specify it using the <code>OutputKey</code>
     *         parameter; <code>OutputBucketName</code> only accepts the name of a bucket.
     *         </p>
     *         <p>
     *         For example, if you want your output stored in <code>S3://DOC-EXAMPLE-BUCKET</code>, set
     *         <code>OutputBucketName</code> to <code>DOC-EXAMPLE-BUCKET</code>. However, if you want your output stored
     *         in <code>S3://DOC-EXAMPLE-BUCKET/test-files/</code>, set <code>OutputBucketName</code> to
     *         <code>DOC-EXAMPLE-BUCKET</code> and <code>OutputKey</code> to <code>test-files/</code>.
     *         </p>
     *         <p>
     *         Note that Amazon Transcribe must have permission to use the specified location. You can change Amazon S3
     *         permissions using the <a href="https://console.aws.amazon.com/s3">Amazon Web Services Management
     *         Console</a>. See also <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
     *         >Permissions Required for IAM User Roles</a>.
     *         </p>
     *         <p>
     *         If you do not specify <code>OutputBucketName</code>, your transcript is placed in a service-managed
     *         Amazon S3 bucket and you are provided with a URI to access your transcript.
     */
    public final String outputBucketName() {
        return outputBucketName;
    }

    /**
     * <p>
     * Use in combination with <code>OutputBucketName</code> to specify the output location of your transcript and,
     * optionally, a unique name for your output file. The default name for your transcription output is the same as the
     * name you specified for your transcription job (<code>TranscriptionJobName</code>).
     * </p>
     * <p>
     * Here are some examples of how you can use <code>OutputKey</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and 'my-transcript.json' as the
     * <code>OutputKey</code>, your transcription output path is <code>s3://DOC-EXAMPLE-BUCKET/my-transcript.json</code>
     * .
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify 'my-first-transcription' as the <code>TranscriptionJobName</code>, 'DOC-EXAMPLE-BUCKET' as the
     * <code>OutputBucketName</code>, and 'my-transcript' as the <code>OutputKey</code>, your transcription output path
     * is <code>s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and 'test-files/my-transcript.json' as
     * the <code>OutputKey</code>, your transcription output path is
     * <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify 'my-first-transcription' as the <code>TranscriptionJobName</code>, 'DOC-EXAMPLE-BUCKET' as the
     * <code>OutputBucketName</code>, and 'test-files/my-transcript' as the <code>OutputKey</code>, your transcription
     * output path is <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify the name of an Amazon S3 bucket sub-folder that doesn't exist, one is created for you.
     * </p>
     * 
     * @return Use in combination with <code>OutputBucketName</code> to specify the output location of your transcript
     *         and, optionally, a unique name for your output file. The default name for your transcription output is
     *         the same as the name you specified for your transcription job (<code>TranscriptionJobName</code>).</p>
     *         <p>
     *         Here are some examples of how you can use <code>OutputKey</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and 'my-transcript.json' as the
     *         <code>OutputKey</code>, your transcription output path is
     *         <code>s3://DOC-EXAMPLE-BUCKET/my-transcript.json</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify 'my-first-transcription' as the <code>TranscriptionJobName</code>, 'DOC-EXAMPLE-BUCKET' as
     *         the <code>OutputBucketName</code>, and 'my-transcript' as the <code>OutputKey</code>, your transcription
     *         output path is <code>s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and
     *         'test-files/my-transcript.json' as the <code>OutputKey</code>, your transcription output path is
     *         <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify 'my-first-transcription' as the <code>TranscriptionJobName</code>, 'DOC-EXAMPLE-BUCKET' as
     *         the <code>OutputBucketName</code>, and 'test-files/my-transcript' as the <code>OutputKey</code>, your
     *         transcription output path is
     *         <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify the name of an Amazon S3 bucket sub-folder that doesn't exist, one is created for you.
     */
    public final String outputKey() {
        return outputKey;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a KMS key that you want to use to encrypt your transcription output.
     * </p>
     * <p>
     * KMS key ARNs have the format <code>arn:partition:kms:region:account:key/key-id</code>. For example:
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>. For more information,
     * see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN"> KMS key
     * ARNs</a>.
     * </p>
     * <p>
     * If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
     * </p>
     * <p>
     * Note that the role making the request and the role specified in the <code>DataAccessRoleArn</code> request
     * parameter (if present) must have permission to use the specified KMS key.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a KMS key that you want to use to encrypt your transcription
     *         output.</p>
     *         <p>
     *         KMS key ARNs have the format <code>arn:partition:kms:region:account:key/key-id</code>. For example:
     *         <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN"> KMS key
     *         ARNs</a>.
     *         </p>
     *         <p>
     *         If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key
     *         (SSE-S3).
     *         </p>
     *         <p>
     *         Note that the role making the request and the role specified in the <code>DataAccessRoleArn</code>
     *         request parameter (if present) must have permission to use the specified KMS key.
     */
    public final String outputEncryptionKMSKeyId() {
        return outputEncryptionKMSKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the KMSEncryptionContext property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKmsEncryptionContext() {
        return kmsEncryptionContext != null && !(kmsEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer
     * of security for your data. For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption
     * context</a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric
     * keys in KMS</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKmsEncryptionContext} method.
     * </p>
     * 
     * @return A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added
     *         layer of security for your data. For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption
     *         context</a> and <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in
     *         KMS</a>.
     */
    public final Map<String, String> kmsEncryptionContext() {
        return kmsEncryptionContext;
    }

    /**
     * <p>
     * Specify additional optional settings in your request, including channel identification, alternative
     * transcriptions, speaker partitioning. You can use that to apply custom vocabularies and vocabulary filters.
     * </p>
     * <p>
     * If you want to include a custom vocabulary or a custom vocabulary filter (or both) with your request but <b>do
     * not</b> want to use automatic language identification, use <code>Settings</code> with the
     * <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both) sub-parameter.
     * </p>
     * <p>
     * If you're using automatic language identification with your request and want to include a custom language model,
     * a custom vocabulary, or a custom vocabulary filter, use instead the
     * <code/> parameter with the <code>LanguageModelName</code>, <code>VocabularyName</code> or
     * <code>VocabularyFilterName</code> sub-parameters.
     * </p>
     * 
     * @return Specify additional optional settings in your request, including channel identification, alternative
     *         transcriptions, speaker partitioning. You can use that to apply custom vocabularies and vocabulary
     *         filters.</p>
     *         <p>
     *         If you want to include a custom vocabulary or a custom vocabulary filter (or both) with your request but
     *         <b>do not</b> want to use automatic language identification, use <code>Settings</code> with the
     *         <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both) sub-parameter.
     *         </p>
     *         <p>
     *         If you're using automatic language identification with your request and want to include a custom language
     *         model, a custom vocabulary, or a custom vocabulary filter, use instead the
     *         <code/> parameter with the <code>LanguageModelName</code>, <code>VocabularyName</code> or
     *         <code>VocabularyFilterName</code> sub-parameters.
     */
    public final Settings settings() {
        return settings;
    }

    /**
     * <p>
     * Specify the custom language model you want to include with your transcription job. If you include
     * <code>ModelSettings</code> in your request, you must include the <code>LanguageModelName</code> sub-parameter.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a>.
     * </p>
     * 
     * @return Specify the custom language model you want to include with your transcription job. If you include
     *         <code>ModelSettings</code> in your request, you must include the <code>LanguageModelName</code>
     *         sub-parameter.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
     *         models</a>.
     */
    public final ModelSettings modelSettings() {
        return modelSettings;
    }

    /**
     * <p>
     * Makes it possible to control how your transcription job is processed. Currently, the only
     * <code>JobExecutionSettings</code> modification you can choose is enabling job queueing using the
     * <code>AllowDeferredExecution</code> sub-parameter.
     * </p>
     * <p>
     * If you include <code>JobExecutionSettings</code> in your request, you must also include the sub-parameters:
     * <code>AllowDeferredExecution</code> and <code>DataAccessRoleArn</code>.
     * </p>
     * 
     * @return Makes it possible to control how your transcription job is processed. Currently, the only
     *         <code>JobExecutionSettings</code> modification you can choose is enabling job queueing using the
     *         <code>AllowDeferredExecution</code> sub-parameter.</p>
     *         <p>
     *         If you include <code>JobExecutionSettings</code> in your request, you must also include the
     *         sub-parameters: <code>AllowDeferredExecution</code> and <code>DataAccessRoleArn</code>.
     */
    public final JobExecutionSettings jobExecutionSettings() {
        return jobExecutionSettings;
    }

    /**
     * <p>
     * Makes it possible to redact or flag specified personally identifiable information (PII) in your transcript. If
     * you use <code>ContentRedaction</code>, you must also include the sub-parameters: <code>RedactionOutput</code> and
     * <code>RedactionType</code>. You can optionally include <code>PiiEntityTypes</code> to choose which types of PII
     * you want to redact. If you do not include <code>PiiEntityTypes</code> in your request, all PII is redacted.
     * </p>
     * 
     * @return Makes it possible to redact or flag specified personally identifiable information (PII) in your
     *         transcript. If you use <code>ContentRedaction</code>, you must also include the sub-parameters:
     *         <code>RedactionOutput</code> and <code>RedactionType</code>. You can optionally include
     *         <code>PiiEntityTypes</code> to choose which types of PII you want to redact. If you do not include
     *         <code>PiiEntityTypes</code> in your request, all PII is redacted.
     */
    public final ContentRedaction contentRedaction() {
        return contentRedaction;
    }

    /**
     * <p>
     * Enables automatic language identification in your transcription job request. Use this parameter if your media
     * file contains only one language. If your media contains multiple languages, use
     * <code>IdentifyMultipleLanguages</code> instead.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes, using
     * <code>LanguageOptions</code>, that you think may be present in your media file. Including
     * <code>LanguageOptions</code> restricts <code>IdentifyLanguage</code> to only the language options that you
     * specify, which can improve transcription accuracy.
     * </p>
     * <p>
     * If you want to apply a custom language model, a custom vocabulary, or a custom vocabulary filter to your
     * automatic language identification request, include <code>LanguageIdSettings</code> with the relevant
     * sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and
     * <code>VocabularyFilterName</code>). If you include <code>LanguageIdSettings</code>, also include
     * <code>LanguageOptions</code>.
     * </p>
     * <p>
     * Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
     * <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your
     * transcription job fails.
     * </p>
     * 
     * @return Enables automatic language identification in your transcription job request. Use this parameter if your
     *         media file contains only one language. If your media contains multiple languages, use
     *         <code>IdentifyMultipleLanguages</code> instead.</p>
     *         <p>
     *         If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes, using
     *         <code>LanguageOptions</code>, that you think may be present in your media file. Including
     *         <code>LanguageOptions</code> restricts <code>IdentifyLanguage</code> to only the language options that
     *         you specify, which can improve transcription accuracy.
     *         </p>
     *         <p>
     *         If you want to apply a custom language model, a custom vocabulary, or a custom vocabulary filter to your
     *         automatic language identification request, include <code>LanguageIdSettings</code> with the relevant
     *         sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and
     *         <code>VocabularyFilterName</code>). If you include <code>LanguageIdSettings</code>, also include
     *         <code>LanguageOptions</code>.
     *         </p>
     *         <p>
     *         Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
     *         <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters,
     *         your transcription job fails.
     */
    public final Boolean identifyLanguage() {
        return identifyLanguage;
    }

    /**
     * <p>
     * Enables automatic multi-language identification in your transcription job request. Use this parameter if your
     * media file contains more than one language. If your media contains only one language, use
     * <code>IdentifyLanguage</code> instead.
     * </p>
     * <p>
     * If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language codes, using
     * <code>LanguageOptions</code>, that you think may be present in your media file. Including
     * <code>LanguageOptions</code> restricts <code>IdentifyLanguage</code> to only the language options that you
     * specify, which can improve transcription accuracy.
     * </p>
     * <p>
     * If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic language identification
     * request, include <code>LanguageIdSettings</code> with the relevant sub-parameters (<code>VocabularyName</code>
     * and <code>VocabularyFilterName</code>). If you include <code>LanguageIdSettings</code>, also include
     * <code>LanguageOptions</code>.
     * </p>
     * <p>
     * Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
     * <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your
     * transcription job fails.
     * </p>
     * 
     * @return Enables automatic multi-language identification in your transcription job request. Use this parameter if
     *         your media file contains more than one language. If your media contains only one language, use
     *         <code>IdentifyLanguage</code> instead.</p>
     *         <p>
     *         If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language
     *         codes, using <code>LanguageOptions</code>, that you think may be present in your media file. Including
     *         <code>LanguageOptions</code> restricts <code>IdentifyLanguage</code> to only the language options that
     *         you specify, which can improve transcription accuracy.
     *         </p>
     *         <p>
     *         If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic language
     *         identification request, include <code>LanguageIdSettings</code> with the relevant sub-parameters (
     *         <code>VocabularyName</code> and <code>VocabularyFilterName</code>). If you include
     *         <code>LanguageIdSettings</code>, also include <code>LanguageOptions</code>.
     *         </p>
     *         <p>
     *         Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
     *         <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters,
     *         your transcription job fails.
     */
    public final Boolean identifyMultipleLanguages() {
        return identifyMultipleLanguages;
    }

    /**
     * <p>
     * You can specify two or more language codes that represent the languages you think may be present in your media.
     * Including more than five is not recommended. If you're unsure what languages are present, do not include this
     * parameter.
     * </p>
     * <p>
     * If you include <code>LanguageOptions</code> in your request, you must also include <code>IdentifyLanguage</code>.
     * </p>
     * <p>
     * For more information, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>.
     * </p>
     * <p>
     * To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>)in Amazon Web Services GovCloud (US) (US-West,
     * us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), in Canada (Calgary) ca-west-1 and
     * Africa (Cape Town) af-south-1, your media file must be encoded at a sample rate of 16,000 Hz or higher.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLanguageOptions} method.
     * </p>
     * 
     * @return You can specify two or more language codes that represent the languages you think may be present in your
     *         media. Including more than five is not recommended. If you're unsure what languages are present, do not
     *         include this parameter.</p>
     *         <p>
     *         If you include <code>LanguageOptions</code> in your request, you must also include
     *         <code>IdentifyLanguage</code>.
     *         </p>
     *         <p>
     *         For more information, refer to <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>.
     *         </p>
     *         <p>
     *         To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>)in Amazon Web Services GovCloud (US)
     *         (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), in Canada (Calgary)
     *         ca-west-1 and Africa (Cape Town) af-south-1, your media file must be encoded at a sample rate of 16,000
     *         Hz or higher.
     */
    public final List<LanguageCode> languageOptions() {
        return LanguageOptionsCopier.copyStringToEnum(languageOptions);
    }

    /**
     * For responses, this returns true if the service returned a value for the LanguageOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLanguageOptions() {
        return languageOptions != null && !(languageOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can specify two or more language codes that represent the languages you think may be present in your media.
     * Including more than five is not recommended. If you're unsure what languages are present, do not include this
     * parameter.
     * </p>
     * <p>
     * If you include <code>LanguageOptions</code> in your request, you must also include <code>IdentifyLanguage</code>.
     * </p>
     * <p>
     * For more information, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>.
     * </p>
     * <p>
     * To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>)in Amazon Web Services GovCloud (US) (US-West,
     * us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), in Canada (Calgary) ca-west-1 and
     * Africa (Cape Town) af-south-1, your media file must be encoded at a sample rate of 16,000 Hz or higher.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLanguageOptions} method.
     * </p>
     * 
     * @return You can specify two or more language codes that represent the languages you think may be present in your
     *         media. Including more than five is not recommended. If you're unsure what languages are present, do not
     *         include this parameter.</p>
     *         <p>
     *         If you include <code>LanguageOptions</code> in your request, you must also include
     *         <code>IdentifyLanguage</code>.
     *         </p>
     *         <p>
     *         For more information, refer to <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>.
     *         </p>
     *         <p>
     *         To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>)in Amazon Web Services GovCloud (US)
     *         (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), in Canada (Calgary)
     *         ca-west-1 and Africa (Cape Town) af-south-1, your media file must be encoded at a sample rate of 16,000
     *         Hz or higher.
     */
    public final List<String> languageOptionsAsStrings() {
        return languageOptions;
    }

    /**
     * <p>
     * Produces subtitle files for your input media. You can specify WebVTT (*.vtt) and SubRip (*.srt) formats.
     * </p>
     * 
     * @return Produces subtitle files for your input media. You can specify WebVTT (*.vtt) and SubRip (*.srt) formats.
     */
    public final Subtitles subtitles() {
        return subtitles;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Adds one or more custom tags, each in the form of a key:value pair, to a new transcription job at the time you
     * start this new job.
     * </p>
     * <p>
     * To learn more about using tags with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Adds one or more custom tags, each in the form of a key:value pair, to a new transcription job at the
     *         time you start this new job.</p>
     *         <p>
     *         To learn more about using tags with Amazon Transcribe, refer to <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * If using automatic language identification in your request and you want to apply a custom language model, a
     * custom vocabulary, or a custom vocabulary filter, include <code>LanguageIdSettings</code> with the relevant
     * sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and
     * <code>VocabularyFilterName</code>). Note that multi-language identification (
     * <code>IdentifyMultipleLanguages</code>) doesn't support custom language models.
     * </p>
     * <p>
     * <code>LanguageIdSettings</code> supports two to five language codes. Each language code you include can have an
     * associated custom language model, custom vocabulary, and custom vocabulary filter. The language codes that you
     * specify must match the languages of the associated custom language models, custom vocabularies, and custom
     * vocabulary filters.
     * </p>
     * <p>
     * It's recommended that you include <code>LanguageOptions</code> when using <code>LanguageIdSettings</code> to
     * ensure that the correct language dialect is identified. For example, if you specify a custom vocabulary that is
     * in <code>en-US</code> but Amazon Transcribe determines that the language spoken in your media is
     * <code>en-AU</code>, your custom vocabulary <i>is not</i> applied to your transcription. If you include
     * <code>LanguageOptions</code> and include <code>en-US</code> as the only English language dialect, your custom
     * vocabulary <i>is</i> applied to your transcription.
     * </p>
     * <p>
     * If you want to include a custom language model with your request but <b>do not</b> want to use automatic language
     * identification, use instead the <code/> parameter with the <code>LanguageModelName</code> sub-parameter. If you
     * want to include a custom vocabulary or a custom vocabulary filter (or both) with your request but <b>do not</b>
     * want to use automatic language identification, use instead the
     * <code/> parameter with the <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both)
     * sub-parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLanguageIdSettings} method.
     * </p>
     * 
     * @return If using automatic language identification in your request and you want to apply a custom language model,
     *         a custom vocabulary, or a custom vocabulary filter, include <code>LanguageIdSettings</code> with the
     *         relevant sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and
     *         <code>VocabularyFilterName</code>). Note that multi-language identification (
     *         <code>IdentifyMultipleLanguages</code>) doesn't support custom language models.</p>
     *         <p>
     *         <code>LanguageIdSettings</code> supports two to five language codes. Each language code you include can
     *         have an associated custom language model, custom vocabulary, and custom vocabulary filter. The language
     *         codes that you specify must match the languages of the associated custom language models, custom
     *         vocabularies, and custom vocabulary filters.
     *         </p>
     *         <p>
     *         It's recommended that you include <code>LanguageOptions</code> when using <code>LanguageIdSettings</code>
     *         to ensure that the correct language dialect is identified. For example, if you specify a custom
     *         vocabulary that is in <code>en-US</code> but Amazon Transcribe determines that the language spoken in
     *         your media is <code>en-AU</code>, your custom vocabulary <i>is not</i> applied to your transcription. If
     *         you include <code>LanguageOptions</code> and include <code>en-US</code> as the only English language
     *         dialect, your custom vocabulary <i>is</i> applied to your transcription.
     *         </p>
     *         <p>
     *         If you want to include a custom language model with your request but <b>do not</b> want to use automatic
     *         language identification, use instead the <code/> parameter with the <code>LanguageModelName</code>
     *         sub-parameter. If you want to include a custom vocabulary or a custom vocabulary filter (or both) with
     *         your request but <b>do not</b> want to use automatic language identification, use instead the
     *         <code/> parameter with the <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both)
     *         sub-parameter.
     */
    public final Map<LanguageCode, LanguageIdSettings> languageIdSettings() {
        return LanguageIdSettingsMapCopier.copyStringToEnum(languageIdSettings);
    }

    /**
     * For responses, this returns true if the service returned a value for the LanguageIdSettings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLanguageIdSettings() {
        return languageIdSettings != null && !(languageIdSettings instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * If using automatic language identification in your request and you want to apply a custom language model, a
     * custom vocabulary, or a custom vocabulary filter, include <code>LanguageIdSettings</code> with the relevant
     * sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and
     * <code>VocabularyFilterName</code>). Note that multi-language identification (
     * <code>IdentifyMultipleLanguages</code>) doesn't support custom language models.
     * </p>
     * <p>
     * <code>LanguageIdSettings</code> supports two to five language codes. Each language code you include can have an
     * associated custom language model, custom vocabulary, and custom vocabulary filter. The language codes that you
     * specify must match the languages of the associated custom language models, custom vocabularies, and custom
     * vocabulary filters.
     * </p>
     * <p>
     * It's recommended that you include <code>LanguageOptions</code> when using <code>LanguageIdSettings</code> to
     * ensure that the correct language dialect is identified. For example, if you specify a custom vocabulary that is
     * in <code>en-US</code> but Amazon Transcribe determines that the language spoken in your media is
     * <code>en-AU</code>, your custom vocabulary <i>is not</i> applied to your transcription. If you include
     * <code>LanguageOptions</code> and include <code>en-US</code> as the only English language dialect, your custom
     * vocabulary <i>is</i> applied to your transcription.
     * </p>
     * <p>
     * If you want to include a custom language model with your request but <b>do not</b> want to use automatic language
     * identification, use instead the <code/> parameter with the <code>LanguageModelName</code> sub-parameter. If you
     * want to include a custom vocabulary or a custom vocabulary filter (or both) with your request but <b>do not</b>
     * want to use automatic language identification, use instead the
     * <code/> parameter with the <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both)
     * sub-parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLanguageIdSettings} method.
     * </p>
     * 
     * @return If using automatic language identification in your request and you want to apply a custom language model,
     *         a custom vocabulary, or a custom vocabulary filter, include <code>LanguageIdSettings</code> with the
     *         relevant sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and
     *         <code>VocabularyFilterName</code>). Note that multi-language identification (
     *         <code>IdentifyMultipleLanguages</code>) doesn't support custom language models.</p>
     *         <p>
     *         <code>LanguageIdSettings</code> supports two to five language codes. Each language code you include can
     *         have an associated custom language model, custom vocabulary, and custom vocabulary filter. The language
     *         codes that you specify must match the languages of the associated custom language models, custom
     *         vocabularies, and custom vocabulary filters.
     *         </p>
     *         <p>
     *         It's recommended that you include <code>LanguageOptions</code> when using <code>LanguageIdSettings</code>
     *         to ensure that the correct language dialect is identified. For example, if you specify a custom
     *         vocabulary that is in <code>en-US</code> but Amazon Transcribe determines that the language spoken in
     *         your media is <code>en-AU</code>, your custom vocabulary <i>is not</i> applied to your transcription. If
     *         you include <code>LanguageOptions</code> and include <code>en-US</code> as the only English language
     *         dialect, your custom vocabulary <i>is</i> applied to your transcription.
     *         </p>
     *         <p>
     *         If you want to include a custom language model with your request but <b>do not</b> want to use automatic
     *         language identification, use instead the <code/> parameter with the <code>LanguageModelName</code>
     *         sub-parameter. If you want to include a custom vocabulary or a custom vocabulary filter (or both) with
     *         your request but <b>do not</b> want to use automatic language identification, use instead the
     *         <code/> parameter with the <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both)
     *         sub-parameter.
     */
    public final Map<String, LanguageIdSettings> languageIdSettingsAsStrings() {
        return languageIdSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ToxicityDetection property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasToxicityDetection() {
        return toxicityDetection != null && !(toxicityDetection instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables toxic speech detection in your transcript. If you include <code>ToxicityDetection</code> in your request,
     * you must also include <code>ToxicityCategories</code>.
     * </p>
     * <p>
     * For information on the types of toxic speech Amazon Transcribe can detect, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/toxic-language.html">Detecting toxic speech</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasToxicityDetection} method.
     * </p>
     * 
     * @return Enables toxic speech detection in your transcript. If you include <code>ToxicityDetection</code> in your
     *         request, you must also include <code>ToxicityCategories</code>.</p>
     *         <p>
     *         For information on the types of toxic speech Amazon Transcribe can detect, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/toxic-language.html">Detecting toxic speech</a>.
     */
    public final List<ToxicityDetectionSettings> toxicityDetection() {
        return toxicityDetection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transcriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(mediaFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(media());
        hashCode = 31 * hashCode + Objects.hashCode(outputBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(outputKey());
        hashCode = 31 * hashCode + Objects.hashCode(outputEncryptionKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasKmsEncryptionContext() ? kmsEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(modelSettings());
        hashCode = 31 * hashCode + Objects.hashCode(jobExecutionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(contentRedaction());
        hashCode = 31 * hashCode + Objects.hashCode(identifyLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(identifyMultipleLanguages());
        hashCode = 31 * hashCode + Objects.hashCode(hasLanguageOptions() ? languageOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subtitles());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLanguageIdSettings() ? languageIdSettingsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasToxicityDetection() ? toxicityDetection() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTranscriptionJobRequest)) {
            return false;
        }
        StartTranscriptionJobRequest other = (StartTranscriptionJobRequest) obj;
        return Objects.equals(transcriptionJobName(), other.transcriptionJobName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(mediaSampleRateHertz(), other.mediaSampleRateHertz())
                && Objects.equals(mediaFormatAsString(), other.mediaFormatAsString()) && Objects.equals(media(), other.media())
                && Objects.equals(outputBucketName(), other.outputBucketName()) && Objects.equals(outputKey(), other.outputKey())
                && Objects.equals(outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId())
                && hasKmsEncryptionContext() == other.hasKmsEncryptionContext()
                && Objects.equals(kmsEncryptionContext(), other.kmsEncryptionContext())
                && Objects.equals(settings(), other.settings()) && Objects.equals(modelSettings(), other.modelSettings())
                && Objects.equals(jobExecutionSettings(), other.jobExecutionSettings())
                && Objects.equals(contentRedaction(), other.contentRedaction())
                && Objects.equals(identifyLanguage(), other.identifyLanguage())
                && Objects.equals(identifyMultipleLanguages(), other.identifyMultipleLanguages())
                && hasLanguageOptions() == other.hasLanguageOptions()
                && Objects.equals(languageOptionsAsStrings(), other.languageOptionsAsStrings())
                && Objects.equals(subtitles(), other.subtitles()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasLanguageIdSettings() == other.hasLanguageIdSettings()
                && Objects.equals(languageIdSettingsAsStrings(), other.languageIdSettingsAsStrings())
                && hasToxicityDetection() == other.hasToxicityDetection()
                && Objects.equals(toxicityDetection(), other.toxicityDetection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTranscriptionJobRequest").add("TranscriptionJobName", transcriptionJobName())
                .add("LanguageCode", languageCodeAsString()).add("MediaSampleRateHertz", mediaSampleRateHertz())
                .add("MediaFormat", mediaFormatAsString()).add("Media", media()).add("OutputBucketName", outputBucketName())
                .add("OutputKey", outputKey()).add("OutputEncryptionKMSKeyId", outputEncryptionKMSKeyId())
                .add("KMSEncryptionContext", hasKmsEncryptionContext() ? kmsEncryptionContext() : null)
                .add("Settings", settings()).add("ModelSettings", modelSettings())
                .add("JobExecutionSettings", jobExecutionSettings()).add("ContentRedaction", contentRedaction())
                .add("IdentifyLanguage", identifyLanguage()).add("IdentifyMultipleLanguages", identifyMultipleLanguages())
                .add("LanguageOptions", hasLanguageOptions() ? languageOptionsAsStrings() : null).add("Subtitles", subtitles())
                .add("Tags", hasTags() ? tags() : null)
                .add("LanguageIdSettings", hasLanguageIdSettings() ? languageIdSettingsAsStrings() : null)
                .add("ToxicityDetection", hasToxicityDetection() ? toxicityDetection() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptionJobName":
            return Optional.ofNullable(clazz.cast(transcriptionJobName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "MediaSampleRateHertz":
            return Optional.ofNullable(clazz.cast(mediaSampleRateHertz()));
        case "MediaFormat":
            return Optional.ofNullable(clazz.cast(mediaFormatAsString()));
        case "Media":
            return Optional.ofNullable(clazz.cast(media()));
        case "OutputBucketName":
            return Optional.ofNullable(clazz.cast(outputBucketName()));
        case "OutputKey":
            return Optional.ofNullable(clazz.cast(outputKey()));
        case "OutputEncryptionKMSKeyId":
            return Optional.ofNullable(clazz.cast(outputEncryptionKMSKeyId()));
        case "KMSEncryptionContext":
            return Optional.ofNullable(clazz.cast(kmsEncryptionContext()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "ModelSettings":
            return Optional.ofNullable(clazz.cast(modelSettings()));
        case "JobExecutionSettings":
            return Optional.ofNullable(clazz.cast(jobExecutionSettings()));
        case "ContentRedaction":
            return Optional.ofNullable(clazz.cast(contentRedaction()));
        case "IdentifyLanguage":
            return Optional.ofNullable(clazz.cast(identifyLanguage()));
        case "IdentifyMultipleLanguages":
            return Optional.ofNullable(clazz.cast(identifyMultipleLanguages()));
        case "LanguageOptions":
            return Optional.ofNullable(clazz.cast(languageOptionsAsStrings()));
        case "Subtitles":
            return Optional.ofNullable(clazz.cast(subtitles()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "LanguageIdSettings":
            return Optional.ofNullable(clazz.cast(languageIdSettingsAsStrings()));
        case "ToxicityDetection":
            return Optional.ofNullable(clazz.cast(toxicityDetection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TranscriptionJobName", TRANSCRIPTION_JOB_NAME_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("MediaSampleRateHertz", MEDIA_SAMPLE_RATE_HERTZ_FIELD);
        map.put("MediaFormat", MEDIA_FORMAT_FIELD);
        map.put("Media", MEDIA_FIELD);
        map.put("OutputBucketName", OUTPUT_BUCKET_NAME_FIELD);
        map.put("OutputKey", OUTPUT_KEY_FIELD);
        map.put("OutputEncryptionKMSKeyId", OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD);
        map.put("KMSEncryptionContext", KMS_ENCRYPTION_CONTEXT_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("ModelSettings", MODEL_SETTINGS_FIELD);
        map.put("JobExecutionSettings", JOB_EXECUTION_SETTINGS_FIELD);
        map.put("ContentRedaction", CONTENT_REDACTION_FIELD);
        map.put("IdentifyLanguage", IDENTIFY_LANGUAGE_FIELD);
        map.put("IdentifyMultipleLanguages", IDENTIFY_MULTIPLE_LANGUAGES_FIELD);
        map.put("LanguageOptions", LANGUAGE_OPTIONS_FIELD);
        map.put("Subtitles", SUBTITLES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("LanguageIdSettings", LANGUAGE_ID_SETTINGS_FIELD);
        map.put("ToxicityDetection", TOXICITY_DETECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTranscriptionJobRequest, T> g) {
        return obj -> g.apply((StartTranscriptionJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartTranscriptionJobRequest> {
        /**
         * <p>
         * A unique name, chosen by you, for your transcription job. The name that you specify is also used as the
         * default name of your transcription output file. If you want to specify a different name for your
         * transcription output, use the <code>OutputKey</code> parameter.
         * </p>
         * <p>
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         * If you try to create a new job with the same name as an existing job, you get a
         * <code>ConflictException</code> error.
         * </p>
         * 
         * @param transcriptionJobName
         *        A unique name, chosen by you, for your transcription job. The name that you specify is also used as
         *        the default name of your transcription output file. If you want to specify a different name for your
         *        transcription output, use the <code>OutputKey</code> parameter.</p>
         *        <p>
         *        This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services
         *        account. If you try to create a new job with the same name as an existing job, you get a
         *        <code>ConflictException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptionJobName(String transcriptionJobName);

        /**
         * <p>
         * The language code that represents the language spoken in the input media file.
         * </p>
         * <p>
         * If you're unsure of the language spoken in your media file, consider using <code>IdentifyLanguage</code> or
         * <code>IdentifyMultipleLanguages</code> to enable automatic language identification.
         * </p>
         * <p>
         * Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
         * <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters,
         * your transcription job fails.
         * </p>
         * <p>
         * For a list of supported languages and their associated language codes, refer to the <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>
         * table.
         * </p>
         * <note>
         * <p>
         * To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>) in Amazon Web Services GovCloud (US)
         * (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), Canada (Calgary,
         * ca-west-1) and Africa (Cape Town, af-south-1), your media file must be encoded at a sample rate of 16,000 Hz
         * or higher.
         * </p>
         * </note>
         * 
         * @param languageCode
         *        The language code that represents the language spoken in the input media file.</p>
         *        <p>
         *        If you're unsure of the language spoken in your media file, consider using
         *        <code>IdentifyLanguage</code> or <code>IdentifyMultipleLanguages</code> to enable automatic language
         *        identification.
         *        </p>
         *        <p>
         *        Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
         *        <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these
         *        parameters, your transcription job fails.
         *        </p>
         *        <p>
         *        For a list of supported languages and their associated language codes, refer to the <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported
         *        languages</a> table.
         *        </p>
         *        <note>
         *        <p>
         *        To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>) in Amazon Web Services GovCloud
         *        (US) (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), Canada
         *        (Calgary, ca-west-1) and Africa (Cape Town, af-south-1), your media file must be encoded at a sample
         *        rate of 16,000 Hz or higher.
         *        </p>
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code that represents the language spoken in the input media file.
         * </p>
         * <p>
         * If you're unsure of the language spoken in your media file, consider using <code>IdentifyLanguage</code> or
         * <code>IdentifyMultipleLanguages</code> to enable automatic language identification.
         * </p>
         * <p>
         * Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
         * <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters,
         * your transcription job fails.
         * </p>
         * <p>
         * For a list of supported languages and their associated language codes, refer to the <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>
         * table.
         * </p>
         * <note>
         * <p>
         * To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>) in Amazon Web Services GovCloud (US)
         * (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), Canada (Calgary,
         * ca-west-1) and Africa (Cape Town, af-south-1), your media file must be encoded at a sample rate of 16,000 Hz
         * or higher.
         * </p>
         * </note>
         * 
         * @param languageCode
         *        The language code that represents the language spoken in the input media file.</p>
         *        <p>
         *        If you're unsure of the language spoken in your media file, consider using
         *        <code>IdentifyLanguage</code> or <code>IdentifyMultipleLanguages</code> to enable automatic language
         *        identification.
         *        </p>
         *        <p>
         *        Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
         *        <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these
         *        parameters, your transcription job fails.
         *        </p>
         *        <p>
         *        For a list of supported languages and their associated language codes, refer to the <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported
         *        languages</a> table.
         *        </p>
         *        <note>
         *        <p>
         *        To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>) in Amazon Web Services GovCloud
         *        (US) (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), Canada
         *        (Calgary, ca-west-1) and Africa (Cape Town, af-south-1), your media file must be encoded at a sample
         *        rate of 16,000 Hz or higher.
         *        </p>
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The sample rate, in hertz, of the audio track in your input media file.
         * </p>
         * <p>
         * If you do not specify the media sample rate, Amazon Transcribe determines it for you. If you specify the
         * sample rate, it must match the rate detected by Amazon Transcribe. If there's a mismatch between the value
         * that you specify and the value detected, your job fails. In most cases, you can omit
         * <code>MediaSampleRateHertz</code> and let Amazon Transcribe determine the sample rate.
         * </p>
         * 
         * @param mediaSampleRateHertz
         *        The sample rate, in hertz, of the audio track in your input media file.</p>
         *        <p>
         *        If you do not specify the media sample rate, Amazon Transcribe determines it for you. If you specify
         *        the sample rate, it must match the rate detected by Amazon Transcribe. If there's a mismatch between
         *        the value that you specify and the value detected, your job fails. In most cases, you can omit
         *        <code>MediaSampleRateHertz</code> and let Amazon Transcribe determine the sample rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSampleRateHertz(Integer mediaSampleRateHertz);

        /**
         * <p>
         * Specify the format of your input media file.
         * </p>
         * 
         * @param mediaFormat
         *        Specify the format of your input media file.
         * @see MediaFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaFormat
         */
        Builder mediaFormat(String mediaFormat);

        /**
         * <p>
         * Specify the format of your input media file.
         * </p>
         * 
         * @param mediaFormat
         *        Specify the format of your input media file.
         * @see MediaFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaFormat
         */
        Builder mediaFormat(MediaFormat mediaFormat);

        /**
         * <p>
         * Describes the Amazon S3 location of the media file you want to use in your request.
         * </p>
         * 
         * @param media
         *        Describes the Amazon S3 location of the media file you want to use in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder media(Media media);

        /**
         * <p>
         * Describes the Amazon S3 location of the media file you want to use in your request.
         * </p>
         * This is a convenience method that creates an instance of the {@link Media.Builder} avoiding the need to
         * create one manually via {@link Media#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Media.Builder#build()} is called immediately and its result is
         * passed to {@link #media(Media)}.
         * 
         * @param media
         *        a consumer that will call methods on {@link Media.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #media(Media)
         */
        default Builder media(Consumer<Media.Builder> media) {
            return media(Media.builder().applyMutation(media).build());
        }

        /**
         * <p>
         * The name of the Amazon S3 bucket where you want your transcription output stored. Do not include the
         * <code>S3://</code> prefix of the specified bucket.
         * </p>
         * <p>
         * If you want your output to go to a sub-folder of this bucket, specify it using the <code>OutputKey</code>
         * parameter; <code>OutputBucketName</code> only accepts the name of a bucket.
         * </p>
         * <p>
         * For example, if you want your output stored in <code>S3://DOC-EXAMPLE-BUCKET</code>, set
         * <code>OutputBucketName</code> to <code>DOC-EXAMPLE-BUCKET</code>. However, if you want your output stored in
         * <code>S3://DOC-EXAMPLE-BUCKET/test-files/</code>, set <code>OutputBucketName</code> to
         * <code>DOC-EXAMPLE-BUCKET</code> and <code>OutputKey</code> to <code>test-files/</code>.
         * </p>
         * <p>
         * Note that Amazon Transcribe must have permission to use the specified location. You can change Amazon S3
         * permissions using the <a href="https://console.aws.amazon.com/s3">Amazon Web Services Management Console</a>.
         * See also <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
         * >Permissions Required for IAM User Roles</a>.
         * </p>
         * <p>
         * If you do not specify <code>OutputBucketName</code>, your transcript is placed in a service-managed Amazon S3
         * bucket and you are provided with a URI to access your transcript.
         * </p>
         * 
         * @param outputBucketName
         *        The name of the Amazon S3 bucket where you want your transcription output stored. Do not include the
         *        <code>S3://</code> prefix of the specified bucket.</p>
         *        <p>
         *        If you want your output to go to a sub-folder of this bucket, specify it using the
         *        <code>OutputKey</code> parameter; <code>OutputBucketName</code> only accepts the name of a bucket.
         *        </p>
         *        <p>
         *        For example, if you want your output stored in <code>S3://DOC-EXAMPLE-BUCKET</code>, set
         *        <code>OutputBucketName</code> to <code>DOC-EXAMPLE-BUCKET</code>. However, if you want your output
         *        stored in <code>S3://DOC-EXAMPLE-BUCKET/test-files/</code>, set <code>OutputBucketName</code> to
         *        <code>DOC-EXAMPLE-BUCKET</code> and <code>OutputKey</code> to <code>test-files/</code>.
         *        </p>
         *        <p>
         *        Note that Amazon Transcribe must have permission to use the specified location. You can change Amazon
         *        S3 permissions using the <a href="https://console.aws.amazon.com/s3">Amazon Web Services Management
         *        Console</a>. See also <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
         *        >Permissions Required for IAM User Roles</a>.
         *        </p>
         *        <p>
         *        If you do not specify <code>OutputBucketName</code>, your transcript is placed in a service-managed
         *        Amazon S3 bucket and you are provided with a URI to access your transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBucketName(String outputBucketName);

        /**
         * <p>
         * Use in combination with <code>OutputBucketName</code> to specify the output location of your transcript and,
         * optionally, a unique name for your output file. The default name for your transcription output is the same as
         * the name you specified for your transcription job (<code>TranscriptionJobName</code>).
         * </p>
         * <p>
         * Here are some examples of how you can use <code>OutputKey</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and 'my-transcript.json' as the
         * <code>OutputKey</code>, your transcription output path is
         * <code>s3://DOC-EXAMPLE-BUCKET/my-transcript.json</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify 'my-first-transcription' as the <code>TranscriptionJobName</code>, 'DOC-EXAMPLE-BUCKET' as the
         * <code>OutputBucketName</code>, and 'my-transcript' as the <code>OutputKey</code>, your transcription output
         * path is <code>s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and 'test-files/my-transcript.json'
         * as the <code>OutputKey</code>, your transcription output path is
         * <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify 'my-first-transcription' as the <code>TranscriptionJobName</code>, 'DOC-EXAMPLE-BUCKET' as the
         * <code>OutputBucketName</code>, and 'test-files/my-transcript' as the <code>OutputKey</code>, your
         * transcription output path is
         * <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify the name of an Amazon S3 bucket sub-folder that doesn't exist, one is created for you.
         * </p>
         * 
         * @param outputKey
         *        Use in combination with <code>OutputBucketName</code> to specify the output location of your
         *        transcript and, optionally, a unique name for your output file. The default name for your
         *        transcription output is the same as the name you specified for your transcription job (
         *        <code>TranscriptionJobName</code>).</p>
         *        <p>
         *        Here are some examples of how you can use <code>OutputKey</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and 'my-transcript.json' as
         *        the <code>OutputKey</code>, your transcription output path is
         *        <code>s3://DOC-EXAMPLE-BUCKET/my-transcript.json</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify 'my-first-transcription' as the <code>TranscriptionJobName</code>, 'DOC-EXAMPLE-BUCKET'
         *        as the <code>OutputBucketName</code>, and 'my-transcript' as the <code>OutputKey</code>, your
         *        transcription output path is
         *        <code>s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and
         *        'test-files/my-transcript.json' as the <code>OutputKey</code>, your transcription output path is
         *        <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify 'my-first-transcription' as the <code>TranscriptionJobName</code>, 'DOC-EXAMPLE-BUCKET'
         *        as the <code>OutputBucketName</code>, and 'test-files/my-transcript' as the <code>OutputKey</code>,
         *        your transcription output path is
         *        <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify the name of an Amazon S3 bucket sub-folder that doesn't exist, one is created for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKey(String outputKey);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a KMS key that you want to use to encrypt your transcription output.
         * </p>
         * <p>
         * KMS key ARNs have the format <code>arn:partition:kms:region:account:key/key-id</code>. For example:
         * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN"> KMS key ARNs</a>.
         * </p>
         * <p>
         * If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
         * </p>
         * <p>
         * Note that the role making the request and the role specified in the <code>DataAccessRoleArn</code> request
         * parameter (if present) must have permission to use the specified KMS key.
         * </p>
         * 
         * @param outputEncryptionKMSKeyId
         *        The Amazon Resource Name (ARN) of a KMS key that you want to use to encrypt your transcription
         *        output.</p>
         *        <p>
         *        KMS key ARNs have the format <code>arn:partition:kms:region:account:key/key-id</code>. For example:
         *        <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN"> KMS key
         *        ARNs</a>.
         *        </p>
         *        <p>
         *        If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key
         *        (SSE-S3).
         *        </p>
         *        <p>
         *        Note that the role making the request and the role specified in the <code>DataAccessRoleArn</code>
         *        request parameter (if present) must have permission to use the specified KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId);

        /**
         * <p>
         * A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added
         * layer of security for your data. For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption
         * context</a> and <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in KMS</a>.
         * </p>
         * 
         * @param kmsEncryptionContext
         *        A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an
         *        added layer of security for your data. For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption
         *        context</a> and <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in
         *        KMS</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext);

        /**
         * <p>
         * Specify additional optional settings in your request, including channel identification, alternative
         * transcriptions, speaker partitioning. You can use that to apply custom vocabularies and vocabulary filters.
         * </p>
         * <p>
         * If you want to include a custom vocabulary or a custom vocabulary filter (or both) with your request but
         * <b>do not</b> want to use automatic language identification, use <code>Settings</code> with the
         * <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both) sub-parameter.
         * </p>
         * <p>
         * If you're using automatic language identification with your request and want to include a custom language
         * model, a custom vocabulary, or a custom vocabulary filter, use instead the
         * <code/> parameter with the <code>LanguageModelName</code>, <code>VocabularyName</code> or
         * <code>VocabularyFilterName</code> sub-parameters.
         * </p>
         * 
         * @param settings
         *        Specify additional optional settings in your request, including channel identification, alternative
         *        transcriptions, speaker partitioning. You can use that to apply custom vocabularies and vocabulary
         *        filters.</p>
         *        <p>
         *        If you want to include a custom vocabulary or a custom vocabulary filter (or both) with your request
         *        but <b>do not</b> want to use automatic language identification, use <code>Settings</code> with the
         *        <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both) sub-parameter.
         *        </p>
         *        <p>
         *        If you're using automatic language identification with your request and want to include a custom
         *        language model, a custom vocabulary, or a custom vocabulary filter, use instead the
         *        <code/> parameter with the <code>LanguageModelName</code>, <code>VocabularyName</code> or
         *        <code>VocabularyFilterName</code> sub-parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(Settings settings);

        /**
         * <p>
         * Specify additional optional settings in your request, including channel identification, alternative
         * transcriptions, speaker partitioning. You can use that to apply custom vocabularies and vocabulary filters.
         * </p>
         * <p>
         * If you want to include a custom vocabulary or a custom vocabulary filter (or both) with your request but
         * <b>do not</b> want to use automatic language identification, use <code>Settings</code> with the
         * <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both) sub-parameter.
         * </p>
         * <p>
         * If you're using automatic language identification with your request and want to include a custom language
         * model, a custom vocabulary, or a custom vocabulary filter, use instead the
         * <code/> parameter with the <code>LanguageModelName</code>, <code>VocabularyName</code> or
         * <code>VocabularyFilterName</code> sub-parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link Settings.Builder} avoiding the need to
         * create one manually via {@link Settings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Settings.Builder#build()} is called immediately and its result is
         * passed to {@link #settings(Settings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(Settings)
         */
        default Builder settings(Consumer<Settings.Builder> settings) {
            return settings(Settings.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * Specify the custom language model you want to include with your transcription job. If you include
         * <code>ModelSettings</code> in your request, you must include the <code>LanguageModelName</code>
         * sub-parameter.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
         * models</a>.
         * </p>
         * 
         * @param modelSettings
         *        Specify the custom language model you want to include with your transcription job. If you include
         *        <code>ModelSettings</code> in your request, you must include the <code>LanguageModelName</code>
         *        sub-parameter.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
         *        models</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSettings(ModelSettings modelSettings);

        /**
         * <p>
         * Specify the custom language model you want to include with your transcription job. If you include
         * <code>ModelSettings</code> in your request, you must include the <code>LanguageModelName</code>
         * sub-parameter.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language
         * models</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelSettings.Builder} avoiding the need
         * to create one manually via {@link ModelSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #modelSettings(ModelSettings)}.
         * 
         * @param modelSettings
         *        a consumer that will call methods on {@link ModelSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelSettings(ModelSettings)
         */
        default Builder modelSettings(Consumer<ModelSettings.Builder> modelSettings) {
            return modelSettings(ModelSettings.builder().applyMutation(modelSettings).build());
        }

        /**
         * <p>
         * Makes it possible to control how your transcription job is processed. Currently, the only
         * <code>JobExecutionSettings</code> modification you can choose is enabling job queueing using the
         * <code>AllowDeferredExecution</code> sub-parameter.
         * </p>
         * <p>
         * If you include <code>JobExecutionSettings</code> in your request, you must also include the sub-parameters:
         * <code>AllowDeferredExecution</code> and <code>DataAccessRoleArn</code>.
         * </p>
         * 
         * @param jobExecutionSettings
         *        Makes it possible to control how your transcription job is processed. Currently, the only
         *        <code>JobExecutionSettings</code> modification you can choose is enabling job queueing using the
         *        <code>AllowDeferredExecution</code> sub-parameter.</p>
         *        <p>
         *        If you include <code>JobExecutionSettings</code> in your request, you must also include the
         *        sub-parameters: <code>AllowDeferredExecution</code> and <code>DataAccessRoleArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobExecutionSettings(JobExecutionSettings jobExecutionSettings);

        /**
         * <p>
         * Makes it possible to control how your transcription job is processed. Currently, the only
         * <code>JobExecutionSettings</code> modification you can choose is enabling job queueing using the
         * <code>AllowDeferredExecution</code> sub-parameter.
         * </p>
         * <p>
         * If you include <code>JobExecutionSettings</code> in your request, you must also include the sub-parameters:
         * <code>AllowDeferredExecution</code> and <code>DataAccessRoleArn</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobExecutionSettings.Builder} avoiding
         * the need to create one manually via {@link JobExecutionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobExecutionSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #jobExecutionSettings(JobExecutionSettings)}.
         * 
         * @param jobExecutionSettings
         *        a consumer that will call methods on {@link JobExecutionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobExecutionSettings(JobExecutionSettings)
         */
        default Builder jobExecutionSettings(Consumer<JobExecutionSettings.Builder> jobExecutionSettings) {
            return jobExecutionSettings(JobExecutionSettings.builder().applyMutation(jobExecutionSettings).build());
        }

        /**
         * <p>
         * Makes it possible to redact or flag specified personally identifiable information (PII) in your transcript.
         * If you use <code>ContentRedaction</code>, you must also include the sub-parameters:
         * <code>RedactionOutput</code> and <code>RedactionType</code>. You can optionally include
         * <code>PiiEntityTypes</code> to choose which types of PII you want to redact. If you do not include
         * <code>PiiEntityTypes</code> in your request, all PII is redacted.
         * </p>
         * 
         * @param contentRedaction
         *        Makes it possible to redact or flag specified personally identifiable information (PII) in your
         *        transcript. If you use <code>ContentRedaction</code>, you must also include the sub-parameters:
         *        <code>RedactionOutput</code> and <code>RedactionType</code>. You can optionally include
         *        <code>PiiEntityTypes</code> to choose which types of PII you want to redact. If you do not include
         *        <code>PiiEntityTypes</code> in your request, all PII is redacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentRedaction(ContentRedaction contentRedaction);

        /**
         * <p>
         * Makes it possible to redact or flag specified personally identifiable information (PII) in your transcript.
         * If you use <code>ContentRedaction</code>, you must also include the sub-parameters:
         * <code>RedactionOutput</code> and <code>RedactionType</code>. You can optionally include
         * <code>PiiEntityTypes</code> to choose which types of PII you want to redact. If you do not include
         * <code>PiiEntityTypes</code> in your request, all PII is redacted.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentRedaction.Builder} avoiding the
         * need to create one manually via {@link ContentRedaction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentRedaction.Builder#build()} is called immediately and its
         * result is passed to {@link #contentRedaction(ContentRedaction)}.
         * 
         * @param contentRedaction
         *        a consumer that will call methods on {@link ContentRedaction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentRedaction(ContentRedaction)
         */
        default Builder contentRedaction(Consumer<ContentRedaction.Builder> contentRedaction) {
            return contentRedaction(ContentRedaction.builder().applyMutation(contentRedaction).build());
        }

        /**
         * <p>
         * Enables automatic language identification in your transcription job request. Use this parameter if your media
         * file contains only one language. If your media contains multiple languages, use
         * <code>IdentifyMultipleLanguages</code> instead.
         * </p>
         * <p>
         * If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes, using
         * <code>LanguageOptions</code>, that you think may be present in your media file. Including
         * <code>LanguageOptions</code> restricts <code>IdentifyLanguage</code> to only the language options that you
         * specify, which can improve transcription accuracy.
         * </p>
         * <p>
         * If you want to apply a custom language model, a custom vocabulary, or a custom vocabulary filter to your
         * automatic language identification request, include <code>LanguageIdSettings</code> with the relevant
         * sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and
         * <code>VocabularyFilterName</code>). If you include <code>LanguageIdSettings</code>, also include
         * <code>LanguageOptions</code>.
         * </p>
         * <p>
         * Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
         * <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters,
         * your transcription job fails.
         * </p>
         * 
         * @param identifyLanguage
         *        Enables automatic language identification in your transcription job request. Use this parameter if
         *        your media file contains only one language. If your media contains multiple languages, use
         *        <code>IdentifyMultipleLanguages</code> instead.</p>
         *        <p>
         *        If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes,
         *        using <code>LanguageOptions</code>, that you think may be present in your media file. Including
         *        <code>LanguageOptions</code> restricts <code>IdentifyLanguage</code> to only the language options that
         *        you specify, which can improve transcription accuracy.
         *        </p>
         *        <p>
         *        If you want to apply a custom language model, a custom vocabulary, or a custom vocabulary filter to
         *        your automatic language identification request, include <code>LanguageIdSettings</code> with the
         *        relevant sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and
         *        <code>VocabularyFilterName</code>). If you include <code>LanguageIdSettings</code>, also include
         *        <code>LanguageOptions</code>.
         *        </p>
         *        <p>
         *        Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
         *        <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these
         *        parameters, your transcription job fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifyLanguage(Boolean identifyLanguage);

        /**
         * <p>
         * Enables automatic multi-language identification in your transcription job request. Use this parameter if your
         * media file contains more than one language. If your media contains only one language, use
         * <code>IdentifyLanguage</code> instead.
         * </p>
         * <p>
         * If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language codes,
         * using <code>LanguageOptions</code>, that you think may be present in your media file. Including
         * <code>LanguageOptions</code> restricts <code>IdentifyLanguage</code> to only the language options that you
         * specify, which can improve transcription accuracy.
         * </p>
         * <p>
         * If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic language
         * identification request, include <code>LanguageIdSettings</code> with the relevant sub-parameters (
         * <code>VocabularyName</code> and <code>VocabularyFilterName</code>). If you include
         * <code>LanguageIdSettings</code>, also include <code>LanguageOptions</code>.
         * </p>
         * <p>
         * Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
         * <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters,
         * your transcription job fails.
         * </p>
         * 
         * @param identifyMultipleLanguages
         *        Enables automatic multi-language identification in your transcription job request. Use this parameter
         *        if your media file contains more than one language. If your media contains only one language, use
         *        <code>IdentifyLanguage</code> instead.</p>
         *        <p>
         *        If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language
         *        codes, using <code>LanguageOptions</code>, that you think may be present in your media file. Including
         *        <code>LanguageOptions</code> restricts <code>IdentifyLanguage</code> to only the language options that
         *        you specify, which can improve transcription accuracy.
         *        </p>
         *        <p>
         *        If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic language
         *        identification request, include <code>LanguageIdSettings</code> with the relevant sub-parameters (
         *        <code>VocabularyName</code> and <code>VocabularyFilterName</code>). If you include
         *        <code>LanguageIdSettings</code>, also include <code>LanguageOptions</code>.
         *        </p>
         *        <p>
         *        Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or
         *        <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these
         *        parameters, your transcription job fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifyMultipleLanguages(Boolean identifyMultipleLanguages);

        /**
         * <p>
         * You can specify two or more language codes that represent the languages you think may be present in your
         * media. Including more than five is not recommended. If you're unsure what languages are present, do not
         * include this parameter.
         * </p>
         * <p>
         * If you include <code>LanguageOptions</code> in your request, you must also include
         * <code>IdentifyLanguage</code>.
         * </p>
         * <p>
         * For more information, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>.
         * </p>
         * <p>
         * To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>)in Amazon Web Services GovCloud (US)
         * (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), in Canada (Calgary)
         * ca-west-1 and Africa (Cape Town) af-south-1, your media file must be encoded at a sample rate of 16,000 Hz or
         * higher.
         * </p>
         * 
         * @param languageOptions
         *        You can specify two or more language codes that represent the languages you think may be present in
         *        your media. Including more than five is not recommended. If you're unsure what languages are present,
         *        do not include this parameter.</p>
         *        <p>
         *        If you include <code>LanguageOptions</code> in your request, you must also include
         *        <code>IdentifyLanguage</code>.
         *        </p>
         *        <p>
         *        For more information, refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported
         *        languages</a>.
         *        </p>
         *        <p>
         *        To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>)in Amazon Web Services GovCloud
         *        (US) (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), in Canada
         *        (Calgary) ca-west-1 and Africa (Cape Town) af-south-1, your media file must be encoded at a sample
         *        rate of 16,000 Hz or higher.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageOptionsWithStrings(Collection<String> languageOptions);

        /**
         * <p>
         * You can specify two or more language codes that represent the languages you think may be present in your
         * media. Including more than five is not recommended. If you're unsure what languages are present, do not
         * include this parameter.
         * </p>
         * <p>
         * If you include <code>LanguageOptions</code> in your request, you must also include
         * <code>IdentifyLanguage</code>.
         * </p>
         * <p>
         * For more information, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>.
         * </p>
         * <p>
         * To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>)in Amazon Web Services GovCloud (US)
         * (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), in Canada (Calgary)
         * ca-west-1 and Africa (Cape Town) af-south-1, your media file must be encoded at a sample rate of 16,000 Hz or
         * higher.
         * </p>
         * 
         * @param languageOptions
         *        You can specify two or more language codes that represent the languages you think may be present in
         *        your media. Including more than five is not recommended. If you're unsure what languages are present,
         *        do not include this parameter.</p>
         *        <p>
         *        If you include <code>LanguageOptions</code> in your request, you must also include
         *        <code>IdentifyLanguage</code>.
         *        </p>
         *        <p>
         *        For more information, refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported
         *        languages</a>.
         *        </p>
         *        <p>
         *        To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>)in Amazon Web Services GovCloud
         *        (US) (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), in Canada
         *        (Calgary) ca-west-1 and Africa (Cape Town) af-south-1, your media file must be encoded at a sample
         *        rate of 16,000 Hz or higher.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageOptionsWithStrings(String... languageOptions);

        /**
         * <p>
         * You can specify two or more language codes that represent the languages you think may be present in your
         * media. Including more than five is not recommended. If you're unsure what languages are present, do not
         * include this parameter.
         * </p>
         * <p>
         * If you include <code>LanguageOptions</code> in your request, you must also include
         * <code>IdentifyLanguage</code>.
         * </p>
         * <p>
         * For more information, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>.
         * </p>
         * <p>
         * To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>)in Amazon Web Services GovCloud (US)
         * (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), in Canada (Calgary)
         * ca-west-1 and Africa (Cape Town) af-south-1, your media file must be encoded at a sample rate of 16,000 Hz or
         * higher.
         * </p>
         * 
         * @param languageOptions
         *        You can specify two or more language codes that represent the languages you think may be present in
         *        your media. Including more than five is not recommended. If you're unsure what languages are present,
         *        do not include this parameter.</p>
         *        <p>
         *        If you include <code>LanguageOptions</code> in your request, you must also include
         *        <code>IdentifyLanguage</code>.
         *        </p>
         *        <p>
         *        For more information, refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported
         *        languages</a>.
         *        </p>
         *        <p>
         *        To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>)in Amazon Web Services GovCloud
         *        (US) (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), in Canada
         *        (Calgary) ca-west-1 and Africa (Cape Town) af-south-1, your media file must be encoded at a sample
         *        rate of 16,000 Hz or higher.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageOptions(Collection<LanguageCode> languageOptions);

        /**
         * <p>
         * You can specify two or more language codes that represent the languages you think may be present in your
         * media. Including more than five is not recommended. If you're unsure what languages are present, do not
         * include this parameter.
         * </p>
         * <p>
         * If you include <code>LanguageOptions</code> in your request, you must also include
         * <code>IdentifyLanguage</code>.
         * </p>
         * <p>
         * For more information, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>.
         * </p>
         * <p>
         * To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>)in Amazon Web Services GovCloud (US)
         * (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), in Canada (Calgary)
         * ca-west-1 and Africa (Cape Town) af-south-1, your media file must be encoded at a sample rate of 16,000 Hz or
         * higher.
         * </p>
         * 
         * @param languageOptions
         *        You can specify two or more language codes that represent the languages you think may be present in
         *        your media. Including more than five is not recommended. If you're unsure what languages are present,
         *        do not include this parameter.</p>
         *        <p>
         *        If you include <code>LanguageOptions</code> in your request, you must also include
         *        <code>IdentifyLanguage</code>.
         *        </p>
         *        <p>
         *        For more information, refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported
         *        languages</a>.
         *        </p>
         *        <p>
         *        To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>)in Amazon Web Services GovCloud
         *        (US) (US-West, us-gov-west-1), Amazon Web Services GovCloud (US) (US-East, us-gov-east-1), in Canada
         *        (Calgary) ca-west-1 and Africa (Cape Town) af-south-1, your media file must be encoded at a sample
         *        rate of 16,000 Hz or higher.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageOptions(LanguageCode... languageOptions);

        /**
         * <p>
         * Produces subtitle files for your input media. You can specify WebVTT (*.vtt) and SubRip (*.srt) formats.
         * </p>
         * 
         * @param subtitles
         *        Produces subtitle files for your input media. You can specify WebVTT (*.vtt) and SubRip (*.srt)
         *        formats.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subtitles(Subtitles subtitles);

        /**
         * <p>
         * Produces subtitle files for your input media. You can specify WebVTT (*.vtt) and SubRip (*.srt) formats.
         * </p>
         * This is a convenience method that creates an instance of the {@link Subtitles.Builder} avoiding the need to
         * create one manually via {@link Subtitles#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Subtitles.Builder#build()} is called immediately and its result
         * is passed to {@link #subtitles(Subtitles)}.
         * 
         * @param subtitles
         *        a consumer that will call methods on {@link Subtitles.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subtitles(Subtitles)
         */
        default Builder subtitles(Consumer<Subtitles.Builder> subtitles) {
            return subtitles(Subtitles.builder().applyMutation(subtitles).build());
        }

        /**
         * <p>
         * Adds one or more custom tags, each in the form of a key:value pair, to a new transcription job at the time
         * you start this new job.
         * </p>
         * <p>
         * To learn more about using tags with Amazon Transcribe, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * </p>
         * 
         * @param tags
         *        Adds one or more custom tags, each in the form of a key:value pair, to a new transcription job at the
         *        time you start this new job.</p>
         *        <p>
         *        To learn more about using tags with Amazon Transcribe, refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Adds one or more custom tags, each in the form of a key:value pair, to a new transcription job at the time
         * you start this new job.
         * </p>
         * <p>
         * To learn more about using tags with Amazon Transcribe, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * </p>
         * 
         * @param tags
         *        Adds one or more custom tags, each in the form of a key:value pair, to a new transcription job at the
         *        time you start this new job.</p>
         *        <p>
         *        To learn more about using tags with Amazon Transcribe, refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Adds one or more custom tags, each in the form of a key:value pair, to a new transcription job at the time
         * you start this new job.
         * </p>
         * <p>
         * To learn more about using tags with Amazon Transcribe, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribe.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.transcribe.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribe.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribe.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * If using automatic language identification in your request and you want to apply a custom language model, a
         * custom vocabulary, or a custom vocabulary filter, include <code>LanguageIdSettings</code> with the relevant
         * sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and
         * <code>VocabularyFilterName</code>). Note that multi-language identification (
         * <code>IdentifyMultipleLanguages</code>) doesn't support custom language models.
         * </p>
         * <p>
         * <code>LanguageIdSettings</code> supports two to five language codes. Each language code you include can have
         * an associated custom language model, custom vocabulary, and custom vocabulary filter. The language codes that
         * you specify must match the languages of the associated custom language models, custom vocabularies, and
         * custom vocabulary filters.
         * </p>
         * <p>
         * It's recommended that you include <code>LanguageOptions</code> when using <code>LanguageIdSettings</code> to
         * ensure that the correct language dialect is identified. For example, if you specify a custom vocabulary that
         * is in <code>en-US</code> but Amazon Transcribe determines that the language spoken in your media is
         * <code>en-AU</code>, your custom vocabulary <i>is not</i> applied to your transcription. If you include
         * <code>LanguageOptions</code> and include <code>en-US</code> as the only English language dialect, your custom
         * vocabulary <i>is</i> applied to your transcription.
         * </p>
         * <p>
         * If you want to include a custom language model with your request but <b>do not</b> want to use automatic
         * language identification, use instead the <code/> parameter with the <code>LanguageModelName</code>
         * sub-parameter. If you want to include a custom vocabulary or a custom vocabulary filter (or both) with your
         * request but <b>do not</b> want to use automatic language identification, use instead the
         * <code/> parameter with the <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both)
         * sub-parameter.
         * </p>
         * 
         * @param languageIdSettings
         *        If using automatic language identification in your request and you want to apply a custom language
         *        model, a custom vocabulary, or a custom vocabulary filter, include <code>LanguageIdSettings</code>
         *        with the relevant sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and
         *        <code>VocabularyFilterName</code>). Note that multi-language identification (
         *        <code>IdentifyMultipleLanguages</code>) doesn't support custom language models.</p>
         *        <p>
         *        <code>LanguageIdSettings</code> supports two to five language codes. Each language code you include
         *        can have an associated custom language model, custom vocabulary, and custom vocabulary filter. The
         *        language codes that you specify must match the languages of the associated custom language models,
         *        custom vocabularies, and custom vocabulary filters.
         *        </p>
         *        <p>
         *        It's recommended that you include <code>LanguageOptions</code> when using
         *        <code>LanguageIdSettings</code> to ensure that the correct language dialect is identified. For
         *        example, if you specify a custom vocabulary that is in <code>en-US</code> but Amazon Transcribe
         *        determines that the language spoken in your media is <code>en-AU</code>, your custom vocabulary <i>is
         *        not</i> applied to your transcription. If you include <code>LanguageOptions</code> and include
         *        <code>en-US</code> as the only English language dialect, your custom vocabulary <i>is</i> applied to
         *        your transcription.
         *        </p>
         *        <p>
         *        If you want to include a custom language model with your request but <b>do not</b> want to use
         *        automatic language identification, use instead the
         *        <code/> parameter with the <code>LanguageModelName</code> sub-parameter. If you want to include a
         *        custom vocabulary or a custom vocabulary filter (or both) with your request but <b>do not</b> want to
         *        use automatic language identification, use instead the
         *        <code/> parameter with the <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both)
         *        sub-parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageIdSettingsWithStrings(Map<String, LanguageIdSettings> languageIdSettings);

        /**
         * <p>
         * If using automatic language identification in your request and you want to apply a custom language model, a
         * custom vocabulary, or a custom vocabulary filter, include <code>LanguageIdSettings</code> with the relevant
         * sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and
         * <code>VocabularyFilterName</code>). Note that multi-language identification (
         * <code>IdentifyMultipleLanguages</code>) doesn't support custom language models.
         * </p>
         * <p>
         * <code>LanguageIdSettings</code> supports two to five language codes. Each language code you include can have
         * an associated custom language model, custom vocabulary, and custom vocabulary filter. The language codes that
         * you specify must match the languages of the associated custom language models, custom vocabularies, and
         * custom vocabulary filters.
         * </p>
         * <p>
         * It's recommended that you include <code>LanguageOptions</code> when using <code>LanguageIdSettings</code> to
         * ensure that the correct language dialect is identified. For example, if you specify a custom vocabulary that
         * is in <code>en-US</code> but Amazon Transcribe determines that the language spoken in your media is
         * <code>en-AU</code>, your custom vocabulary <i>is not</i> applied to your transcription. If you include
         * <code>LanguageOptions</code> and include <code>en-US</code> as the only English language dialect, your custom
         * vocabulary <i>is</i> applied to your transcription.
         * </p>
         * <p>
         * If you want to include a custom language model with your request but <b>do not</b> want to use automatic
         * language identification, use instead the <code/> parameter with the <code>LanguageModelName</code>
         * sub-parameter. If you want to include a custom vocabulary or a custom vocabulary filter (or both) with your
         * request but <b>do not</b> want to use automatic language identification, use instead the
         * <code/> parameter with the <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both)
         * sub-parameter.
         * </p>
         * 
         * @param languageIdSettings
         *        If using automatic language identification in your request and you want to apply a custom language
         *        model, a custom vocabulary, or a custom vocabulary filter, include <code>LanguageIdSettings</code>
         *        with the relevant sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and
         *        <code>VocabularyFilterName</code>). Note that multi-language identification (
         *        <code>IdentifyMultipleLanguages</code>) doesn't support custom language models.</p>
         *        <p>
         *        <code>LanguageIdSettings</code> supports two to five language codes. Each language code you include
         *        can have an associated custom language model, custom vocabulary, and custom vocabulary filter. The
         *        language codes that you specify must match the languages of the associated custom language models,
         *        custom vocabularies, and custom vocabulary filters.
         *        </p>
         *        <p>
         *        It's recommended that you include <code>LanguageOptions</code> when using
         *        <code>LanguageIdSettings</code> to ensure that the correct language dialect is identified. For
         *        example, if you specify a custom vocabulary that is in <code>en-US</code> but Amazon Transcribe
         *        determines that the language spoken in your media is <code>en-AU</code>, your custom vocabulary <i>is
         *        not</i> applied to your transcription. If you include <code>LanguageOptions</code> and include
         *        <code>en-US</code> as the only English language dialect, your custom vocabulary <i>is</i> applied to
         *        your transcription.
         *        </p>
         *        <p>
         *        If you want to include a custom language model with your request but <b>do not</b> want to use
         *        automatic language identification, use instead the
         *        <code/> parameter with the <code>LanguageModelName</code> sub-parameter. If you want to include a
         *        custom vocabulary or a custom vocabulary filter (or both) with your request but <b>do not</b> want to
         *        use automatic language identification, use instead the
         *        <code/> parameter with the <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both)
         *        sub-parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageIdSettings(Map<LanguageCode, LanguageIdSettings> languageIdSettings);

        /**
         * <p>
         * Enables toxic speech detection in your transcript. If you include <code>ToxicityDetection</code> in your
         * request, you must also include <code>ToxicityCategories</code>.
         * </p>
         * <p>
         * For information on the types of toxic speech Amazon Transcribe can detect, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/toxic-language.html">Detecting toxic speech</a>.
         * </p>
         * 
         * @param toxicityDetection
         *        Enables toxic speech detection in your transcript. If you include <code>ToxicityDetection</code> in
         *        your request, you must also include <code>ToxicityCategories</code>.</p>
         *        <p>
         *        For information on the types of toxic speech Amazon Transcribe can detect, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/toxic-language.html">Detecting toxic
         *        speech</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toxicityDetection(Collection<ToxicityDetectionSettings> toxicityDetection);

        /**
         * <p>
         * Enables toxic speech detection in your transcript. If you include <code>ToxicityDetection</code> in your
         * request, you must also include <code>ToxicityCategories</code>.
         * </p>
         * <p>
         * For information on the types of toxic speech Amazon Transcribe can detect, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/toxic-language.html">Detecting toxic speech</a>.
         * </p>
         * 
         * @param toxicityDetection
         *        Enables toxic speech detection in your transcript. If you include <code>ToxicityDetection</code> in
         *        your request, you must also include <code>ToxicityCategories</code>.</p>
         *        <p>
         *        For information on the types of toxic speech Amazon Transcribe can detect, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/toxic-language.html">Detecting toxic
         *        speech</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toxicityDetection(ToxicityDetectionSettings... toxicityDetection);

        /**
         * <p>
         * Enables toxic speech detection in your transcript. If you include <code>ToxicityDetection</code> in your
         * request, you must also include <code>ToxicityCategories</code>.
         * </p>
         * <p>
         * For information on the types of toxic speech Amazon Transcribe can detect, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/toxic-language.html">Detecting toxic speech</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribe.model.ToxicityDetectionSettings.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.transcribe.model.ToxicityDetectionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribe.model.ToxicityDetectionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #toxicityDetection(List<ToxicityDetectionSettings>)}.
         * 
         * @param toxicityDetection
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribe.model.ToxicityDetectionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toxicityDetection(java.util.Collection<ToxicityDetectionSettings>)
         */
        Builder toxicityDetection(Consumer<ToxicityDetectionSettings.Builder>... toxicityDetection);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String transcriptionJobName;

        private String languageCode;

        private Integer mediaSampleRateHertz;

        private String mediaFormat;

        private Media media;

        private String outputBucketName;

        private String outputKey;

        private String outputEncryptionKMSKeyId;

        private Map<String, String> kmsEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private Settings settings;

        private ModelSettings modelSettings;

        private JobExecutionSettings jobExecutionSettings;

        private ContentRedaction contentRedaction;

        private Boolean identifyLanguage;

        private Boolean identifyMultipleLanguages;

        private List<String> languageOptions = DefaultSdkAutoConstructList.getInstance();

        private Subtitles subtitles;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Map<String, LanguageIdSettings> languageIdSettings = DefaultSdkAutoConstructMap.getInstance();

        private List<ToxicityDetectionSettings> toxicityDetection = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartTranscriptionJobRequest model) {
            super(model);
            transcriptionJobName(model.transcriptionJobName);
            languageCode(model.languageCode);
            mediaSampleRateHertz(model.mediaSampleRateHertz);
            mediaFormat(model.mediaFormat);
            media(model.media);
            outputBucketName(model.outputBucketName);
            outputKey(model.outputKey);
            outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
            kmsEncryptionContext(model.kmsEncryptionContext);
            settings(model.settings);
            modelSettings(model.modelSettings);
            jobExecutionSettings(model.jobExecutionSettings);
            contentRedaction(model.contentRedaction);
            identifyLanguage(model.identifyLanguage);
            identifyMultipleLanguages(model.identifyMultipleLanguages);
            languageOptionsWithStrings(model.languageOptions);
            subtitles(model.subtitles);
            tags(model.tags);
            languageIdSettingsWithStrings(model.languageIdSettings);
            toxicityDetection(model.toxicityDetection);
        }

        public final String getTranscriptionJobName() {
            return transcriptionJobName;
        }

        public final void setTranscriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
        }

        @Override
        public final Builder transcriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaFormat() {
            return mediaFormat;
        }

        public final void setMediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
        }

        @Override
        public final Builder mediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
            return this;
        }

        @Override
        public final Builder mediaFormat(MediaFormat mediaFormat) {
            this.mediaFormat(mediaFormat == null ? null : mediaFormat.toString());
            return this;
        }

        public final Media.Builder getMedia() {
            return media != null ? media.toBuilder() : null;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final String getOutputBucketName() {
            return outputBucketName;
        }

        public final void setOutputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
        }

        @Override
        public final Builder outputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
            return this;
        }

        public final String getOutputKey() {
            return outputKey;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return outputEncryptionKMSKeyId;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        @Override
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        public final Map<String, String> getKmsEncryptionContext() {
            if (kmsEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return kmsEncryptionContext;
        }

        public final void setKmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KMSEncryptionContextMapCopier.copy(kmsEncryptionContext);
        }

        @Override
        public final Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KMSEncryptionContextMapCopier.copy(kmsEncryptionContext);
            return this;
        }

        public final Settings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(Settings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public final ModelSettings.Builder getModelSettings() {
            return modelSettings != null ? modelSettings.toBuilder() : null;
        }

        public final void setModelSettings(ModelSettings.BuilderImpl modelSettings) {
            this.modelSettings = modelSettings != null ? modelSettings.build() : null;
        }

        @Override
        public final Builder modelSettings(ModelSettings modelSettings) {
            this.modelSettings = modelSettings;
            return this;
        }

        public final JobExecutionSettings.Builder getJobExecutionSettings() {
            return jobExecutionSettings != null ? jobExecutionSettings.toBuilder() : null;
        }

        public final void setJobExecutionSettings(JobExecutionSettings.BuilderImpl jobExecutionSettings) {
            this.jobExecutionSettings = jobExecutionSettings != null ? jobExecutionSettings.build() : null;
        }

        @Override
        public final Builder jobExecutionSettings(JobExecutionSettings jobExecutionSettings) {
            this.jobExecutionSettings = jobExecutionSettings;
            return this;
        }

        public final ContentRedaction.Builder getContentRedaction() {
            return contentRedaction != null ? contentRedaction.toBuilder() : null;
        }

        public final void setContentRedaction(ContentRedaction.BuilderImpl contentRedaction) {
            this.contentRedaction = contentRedaction != null ? contentRedaction.build() : null;
        }

        @Override
        public final Builder contentRedaction(ContentRedaction contentRedaction) {
            this.contentRedaction = contentRedaction;
            return this;
        }

        public final Boolean getIdentifyLanguage() {
            return identifyLanguage;
        }

        public final void setIdentifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
        }

        @Override
        public final Builder identifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
            return this;
        }

        public final Boolean getIdentifyMultipleLanguages() {
            return identifyMultipleLanguages;
        }

        public final void setIdentifyMultipleLanguages(Boolean identifyMultipleLanguages) {
            this.identifyMultipleLanguages = identifyMultipleLanguages;
        }

        @Override
        public final Builder identifyMultipleLanguages(Boolean identifyMultipleLanguages) {
            this.identifyMultipleLanguages = identifyMultipleLanguages;
            return this;
        }

        public final Collection<String> getLanguageOptions() {
            if (languageOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return languageOptions;
        }

        public final void setLanguageOptions(Collection<String> languageOptions) {
            this.languageOptions = LanguageOptionsCopier.copy(languageOptions);
        }

        @Override
        public final Builder languageOptionsWithStrings(Collection<String> languageOptions) {
            this.languageOptions = LanguageOptionsCopier.copy(languageOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languageOptionsWithStrings(String... languageOptions) {
            languageOptionsWithStrings(Arrays.asList(languageOptions));
            return this;
        }

        @Override
        public final Builder languageOptions(Collection<LanguageCode> languageOptions) {
            this.languageOptions = LanguageOptionsCopier.copyEnumToString(languageOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languageOptions(LanguageCode... languageOptions) {
            languageOptions(Arrays.asList(languageOptions));
            return this;
        }

        public final Subtitles.Builder getSubtitles() {
            return subtitles != null ? subtitles.toBuilder() : null;
        }

        public final void setSubtitles(Subtitles.BuilderImpl subtitles) {
            this.subtitles = subtitles != null ? subtitles.build() : null;
        }

        @Override
        public final Builder subtitles(Subtitles subtitles) {
            this.subtitles = subtitles;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, LanguageIdSettings.Builder> getLanguageIdSettings() {
            Map<String, LanguageIdSettings.Builder> result = LanguageIdSettingsMapCopier.copyToBuilder(this.languageIdSettings);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLanguageIdSettings(Map<String, LanguageIdSettings.BuilderImpl> languageIdSettings) {
            this.languageIdSettings = LanguageIdSettingsMapCopier.copyFromBuilder(languageIdSettings);
        }

        @Override
        public final Builder languageIdSettingsWithStrings(Map<String, LanguageIdSettings> languageIdSettings) {
            this.languageIdSettings = LanguageIdSettingsMapCopier.copy(languageIdSettings);
            return this;
        }

        @Override
        public final Builder languageIdSettings(Map<LanguageCode, LanguageIdSettings> languageIdSettings) {
            this.languageIdSettings = LanguageIdSettingsMapCopier.copyEnumToString(languageIdSettings);
            return this;
        }

        public final List<ToxicityDetectionSettings.Builder> getToxicityDetection() {
            List<ToxicityDetectionSettings.Builder> result = ToxicityDetectionCopier.copyToBuilder(this.toxicityDetection);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToxicityDetection(Collection<ToxicityDetectionSettings.BuilderImpl> toxicityDetection) {
            this.toxicityDetection = ToxicityDetectionCopier.copyFromBuilder(toxicityDetection);
        }

        @Override
        public final Builder toxicityDetection(Collection<ToxicityDetectionSettings> toxicityDetection) {
            this.toxicityDetection = ToxicityDetectionCopier.copy(toxicityDetection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toxicityDetection(ToxicityDetectionSettings... toxicityDetection) {
            toxicityDetection(Arrays.asList(toxicityDetection));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toxicityDetection(Consumer<ToxicityDetectionSettings.Builder>... toxicityDetection) {
            toxicityDetection(Stream.of(toxicityDetection).map(c -> ToxicityDetectionSettings.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTranscriptionJobRequest build() {
            return new StartTranscriptionJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
