/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.CategoryProperties;
import software.amazon.awssdk.services.transcribe.model.CategoryPropertiesListCopier;
import software.amazon.awssdk.services.transcribe.model.TranscribeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCallAnalyticsCategoriesResponse
extends TranscribeResponse
implements ToCopyableBuilder<Builder, ListCallAnalyticsCategoriesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCallAnalyticsCategoriesResponse.getter(ListCallAnalyticsCategoriesResponse::nextToken)).setter(ListCallAnalyticsCategoriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<CategoryProperties>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Categories").getter(ListCallAnalyticsCategoriesResponse.getter(ListCallAnalyticsCategoriesResponse::categories)).setter(ListCallAnalyticsCategoriesResponse.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CategoryProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CATEGORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Categories", CATEGORIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<CategoryProperties> categories;

    private ListCallAnalyticsCategoriesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.categories = builder.categories;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<CategoryProperties> categories() {
        return this.categories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCallAnalyticsCategoriesResponse)) {
            return false;
        }
        ListCallAnalyticsCategoriesResponse other = (ListCallAnalyticsCategoriesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories());
    }

    public final String toString() {
        return ToString.builder((String)"ListCallAnalyticsCategoriesResponse").add("NextToken", (Object)this.nextToken()).add("Categories", this.hasCategories() ? this.categories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCallAnalyticsCategoriesResponse, T> g) {
        return obj -> g.apply((ListCallAnalyticsCategoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CategoryProperties> categories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCallAnalyticsCategoriesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.categories(model.categories);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CategoryProperties.Builder> getCategories() {
            List<CategoryProperties.Builder> result = CategoryPropertiesListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<CategoryProperties.BuilderImpl> categories) {
            this.categories = CategoryPropertiesListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<CategoryProperties> categories) {
            this.categories = CategoryPropertiesListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(CategoryProperties ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<CategoryProperties.Builder> ... categories) {
            this.categories(Stream.of(categories).map(c -> (CategoryProperties)((CategoryProperties.Builder)CategoryProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCallAnalyticsCategoriesResponse build() {
            return new ListCallAnalyticsCategoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TranscribeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCallAnalyticsCategoriesResponse> {
        public Builder nextToken(String var1);

        public Builder categories(Collection<CategoryProperties> var1);

        public Builder categories(CategoryProperties ... var1);

        public Builder categories(Consumer<CategoryProperties.Builder> ... var1);
    }
}

