/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse;

public class ListCallAnalyticsCategoriesIterable
implements SdkIterable<ListCallAnalyticsCategoriesResponse> {
    private final TranscribeClient client;
    private final ListCallAnalyticsCategoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCallAnalyticsCategoriesIterable(TranscribeClient client, ListCallAnalyticsCategoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCallAnalyticsCategoriesResponseFetcher();
    }

    public Iterator<ListCallAnalyticsCategoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCallAnalyticsCategoriesResponseFetcher
    implements SyncPageFetcher<ListCallAnalyticsCategoriesResponse> {
        private ListCallAnalyticsCategoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListCallAnalyticsCategoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCallAnalyticsCategoriesResponse nextPage(ListCallAnalyticsCategoriesResponse previousPage) {
            if (previousPage == null) {
                return ListCallAnalyticsCategoriesIterable.this.client.listCallAnalyticsCategories(ListCallAnalyticsCategoriesIterable.this.firstRequest);
            }
            return ListCallAnalyticsCategoriesIterable.this.client.listCallAnalyticsCategories((ListCallAnalyticsCategoriesRequest)((Object)ListCallAnalyticsCategoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

