/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLanguageModelsRequest extends TranscribeRequest implements
        ToCopyableBuilder<ListLanguageModelsRequest.Builder, ListLanguageModelsRequest> {
    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusEquals").getter(getter(ListLanguageModelsRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListLanguageModelsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLanguageModelsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListLanguageModelsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_EQUALS_FIELD,
            NAME_CONTAINS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String statusEquals;

    private final String nameContains;

    private final String nextToken;

    private final Integer maxResults;

    private ListLanguageModelsRequest(BuilderImpl builder) {
        super(builder);
        this.statusEquals = builder.statusEquals;
        this.nameContains = builder.nameContains;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * When specified, returns only custom language models with the specified status. Language models are ordered by
     * creation date, with the newest models first. If you don't specify a status, Amazon Transcribe returns all custom
     * language models ordered by date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return When specified, returns only custom language models with the specified status. Language models are
     *         ordered by creation date, with the newest models first. If you don't specify a status, Amazon Transcribe
     *         returns all custom language models ordered by date.
     * @see ModelStatus
     */
    public final ModelStatus statusEquals() {
        return ModelStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * When specified, returns only custom language models with the specified status. Language models are ordered by
     * creation date, with the newest models first. If you don't specify a status, Amazon Transcribe returns all custom
     * language models ordered by date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return When specified, returns only custom language models with the specified status. Language models are
     *         ordered by creation date, with the newest models first. If you don't specify a status, Amazon Transcribe
     *         returns all custom language models ordered by date.
     * @see ModelStatus
     */
    public final String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * When specified, the custom language model names returned contain the substring you've specified.
     * </p>
     * 
     * @return When specified, the custom language model names returned contain the substring you've specified.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * When included, fetches the next set of jobs if the result of the previous request was truncated.
     * </p>
     * 
     * @return When included, fetches the next set of jobs if the result of the previous request was truncated.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of language models to return in the response. If there are fewer results in the list, the
     * response contains only the actual results.
     * </p>
     * 
     * @return The maximum number of language models to return in the response. If there are fewer results in the list,
     *         the response contains only the actual results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLanguageModelsRequest)) {
            return false;
        }
        ListLanguageModelsRequest other = (ListLanguageModelsRequest) obj;
        return Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(nameContains(), other.nameContains()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLanguageModelsRequest").add("StatusEquals", statusEqualsAsString())
                .add("NameContains", nameContains()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLanguageModelsRequest, T> g) {
        return obj -> g.apply((ListLanguageModelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLanguageModelsRequest> {
        /**
         * <p>
         * When specified, returns only custom language models with the specified status. Language models are ordered by
         * creation date, with the newest models first. If you don't specify a status, Amazon Transcribe returns all
         * custom language models ordered by date.
         * </p>
         * 
         * @param statusEquals
         *        When specified, returns only custom language models with the specified status. Language models are
         *        ordered by creation date, with the newest models first. If you don't specify a status, Amazon
         *        Transcribe returns all custom language models ordered by date.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * When specified, returns only custom language models with the specified status. Language models are ordered by
         * creation date, with the newest models first. If you don't specify a status, Amazon Transcribe returns all
         * custom language models ordered by date.
         * </p>
         * 
         * @param statusEquals
         *        When specified, returns only custom language models with the specified status. Language models are
         *        ordered by creation date, with the newest models first. If you don't specify a status, Amazon
         *        Transcribe returns all custom language models ordered by date.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder statusEquals(ModelStatus statusEquals);

        /**
         * <p>
         * When specified, the custom language model names returned contain the substring you've specified.
         * </p>
         * 
         * @param nameContains
         *        When specified, the custom language model names returned contain the substring you've specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * When included, fetches the next set of jobs if the result of the previous request was truncated.
         * </p>
         * 
         * @param nextToken
         *        When included, fetches the next set of jobs if the result of the previous request was truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of language models to return in the response. If there are fewer results in the list, the
         * response contains only the actual results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of language models to return in the response. If there are fewer results in the
         *        list, the response contains only the actual results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String statusEquals;

        private String nameContains;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLanguageModelsRequest model) {
            super(model);
            statusEquals(model.statusEquals);
            nameContains(model.nameContains);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(ModelStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        public final String getNameContains() {
            return nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLanguageModelsRequest build() {
            return new ListLanguageModelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
