/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVocabularyFilterRequest extends TranscribeRequest implements
        ToCopyableBuilder<CreateVocabularyFilterRequest.Builder, CreateVocabularyFilterRequest> {
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVocabularyFilterRequest::vocabularyFilterName)).setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVocabularyFilterRequest::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<List<String>> WORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateVocabularyFilterRequest::words))
            .setter(setter(Builder::words))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Words").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVocabularyFilterRequest::vocabularyFilterFileUri))
            .setter(setter(Builder::vocabularyFilterFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterFileUri").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_FILTER_NAME_FIELD,
            LANGUAGE_CODE_FIELD, WORDS_FIELD, VOCABULARY_FILTER_FILE_URI_FIELD));

    private final String vocabularyFilterName;

    private final String languageCode;

    private final List<String> words;

    private final String vocabularyFilterFileUri;

    private CreateVocabularyFilterRequest(BuilderImpl builder) {
        super(builder);
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.languageCode = builder.languageCode;
        this.words = builder.words;
        this.vocabularyFilterFileUri = builder.vocabularyFilterFileUri;
    }

    /**
     * <p>
     * The vocabulary filter name. The name must be unique within the account that contains it.If you try to create a
     * vocabulary filter with the same name as a previous vocabulary filter you will receive a
     * <code>ConflictException</code> error.
     * </p>
     * 
     * @return The vocabulary filter name. The name must be unique within the account that contains it.If you try to
     *         create a vocabulary filter with the same name as a previous vocabulary filter you will receive a
     *         <code>ConflictException</code> error.
     */
    public String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * The language code of the words in the vocabulary filter. All words in the filter must be in the same language.
     * The vocabulary filter can only be used with transcription jobs in the specified language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the words in the vocabulary filter. All words in the filter must be in the same
     *         language. The vocabulary filter can only be used with transcription jobs in the specified language.
     * @see LanguageCode
     */
    public LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code of the words in the vocabulary filter. All words in the filter must be in the same language.
     * The vocabulary filter can only be used with transcription jobs in the specified language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the words in the vocabulary filter. All words in the filter must be in the same
     *         language. The vocabulary filter can only be used with transcription jobs in the specified language.
     * @see LanguageCode
     */
    public String languageCodeAsString() {
        return languageCode;
    }

    /**
     * Returns true if the Words property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWords() {
        return words != null && !(words instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The words to use in the vocabulary filter. Only use characters from the character set defined for custom
     * vocabularies. For a list of character sets, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for Custom
     * Vocabularies</a>.
     * </p>
     * <p>
     * If you provide a list of words in the <code>Words</code> parameter, you can't use the
     * <code>VocabularyFilterFileUri</code> parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The words to use in the vocabulary filter. Only use characters from the character set defined for custom
     *         vocabularies. For a list of character sets, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for
     *         Custom Vocabularies</a>.</p>
     *         <p>
     *         If you provide a list of words in the <code>Words</code> parameter, you can't use the
     *         <code>VocabularyFilterFileUri</code> parameter.
     */
    public List<String> words() {
        return words;
    }

    /**
     * <p>
     * The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use characters from the
     * character set defined for custom vocabularies. For a list of character sets, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for Custom
     * Vocabularies</a>.
     * </p>
     * <p>
     * The specified file must be less than 50 KB of UTF-8 characters.
     * </p>
     * <p>
     * If you provide the location of a list of words in the <code>VocabularyFilterFileUri</code> parameter, you can't
     * use the <code>Words</code> parameter.
     * </p>
     * 
     * @return The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use characters
     *         from the character set defined for custom vocabularies. For a list of character sets, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for
     *         Custom Vocabularies</a>.</p>
     *         <p>
     *         The specified file must be less than 50 KB of UTF-8 characters.
     *         </p>
     *         <p>
     *         If you provide the location of a list of words in the <code>VocabularyFilterFileUri</code> parameter, you
     *         can't use the <code>Words</code> parameter.
     */
    public String vocabularyFilterFileUri() {
        return vocabularyFilterFileUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(words());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterFileUri());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVocabularyFilterRequest)) {
            return false;
        }
        CreateVocabularyFilterRequest other = (CreateVocabularyFilterRequest) obj;
        return Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(words(), other.words())
                && Objects.equals(vocabularyFilterFileUri(), other.vocabularyFilterFileUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVocabularyFilterRequest").add("VocabularyFilterName", vocabularyFilterName())
                .add("LanguageCode", languageCodeAsString()).add("Words", words())
                .add("VocabularyFilterFileUri", vocabularyFilterFileUri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "Words":
            return Optional.ofNullable(clazz.cast(words()));
        case "VocabularyFilterFileUri":
            return Optional.ofNullable(clazz.cast(vocabularyFilterFileUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVocabularyFilterRequest, T> g) {
        return obj -> g.apply((CreateVocabularyFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVocabularyFilterRequest> {
        /**
         * <p>
         * The vocabulary filter name. The name must be unique within the account that contains it.If you try to create
         * a vocabulary filter with the same name as a previous vocabulary filter you will receive a
         * <code>ConflictException</code> error.
         * </p>
         * 
         * @param vocabularyFilterName
         *        The vocabulary filter name. The name must be unique within the account that contains it.If you try to
         *        create a vocabulary filter with the same name as a previous vocabulary filter you will receive a
         *        <code>ConflictException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * The language code of the words in the vocabulary filter. All words in the filter must be in the same
         * language. The vocabulary filter can only be used with transcription jobs in the specified language.
         * </p>
         * 
         * @param languageCode
         *        The language code of the words in the vocabulary filter. All words in the filter must be in the same
         *        language. The vocabulary filter can only be used with transcription jobs in the specified language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code of the words in the vocabulary filter. All words in the filter must be in the same
         * language. The vocabulary filter can only be used with transcription jobs in the specified language.
         * </p>
         * 
         * @param languageCode
         *        The language code of the words in the vocabulary filter. All words in the filter must be in the same
         *        language. The vocabulary filter can only be used with transcription jobs in the specified language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The words to use in the vocabulary filter. Only use characters from the character set defined for custom
         * vocabularies. For a list of character sets, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for
         * Custom Vocabularies</a>.
         * </p>
         * <p>
         * If you provide a list of words in the <code>Words</code> parameter, you can't use the
         * <code>VocabularyFilterFileUri</code> parameter.
         * </p>
         * 
         * @param words
         *        The words to use in the vocabulary filter. Only use characters from the character set defined for
         *        custom vocabularies. For a list of character sets, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets
         *        for Custom Vocabularies</a>.</p>
         *        <p>
         *        If you provide a list of words in the <code>Words</code> parameter, you can't use the
         *        <code>VocabularyFilterFileUri</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder words(Collection<String> words);

        /**
         * <p>
         * The words to use in the vocabulary filter. Only use characters from the character set defined for custom
         * vocabularies. For a list of character sets, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for
         * Custom Vocabularies</a>.
         * </p>
         * <p>
         * If you provide a list of words in the <code>Words</code> parameter, you can't use the
         * <code>VocabularyFilterFileUri</code> parameter.
         * </p>
         * 
         * @param words
         *        The words to use in the vocabulary filter. Only use characters from the character set defined for
         *        custom vocabularies. For a list of character sets, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets
         *        for Custom Vocabularies</a>.</p>
         *        <p>
         *        If you provide a list of words in the <code>Words</code> parameter, you can't use the
         *        <code>VocabularyFilterFileUri</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder words(String... words);

        /**
         * <p>
         * The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use characters from
         * the character set defined for custom vocabularies. For a list of character sets, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for
         * Custom Vocabularies</a>.
         * </p>
         * <p>
         * The specified file must be less than 50 KB of UTF-8 characters.
         * </p>
         * <p>
         * If you provide the location of a list of words in the <code>VocabularyFilterFileUri</code> parameter, you
         * can't use the <code>Words</code> parameter.
         * </p>
         * 
         * @param vocabularyFilterFileUri
         *        The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use
         *        characters from the character set defined for custom vocabularies. For a list of character sets, see
         *        <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets
         *        for Custom Vocabularies</a>.</p>
         *        <p>
         *        The specified file must be less than 50 KB of UTF-8 characters.
         *        </p>
         *        <p>
         *        If you provide the location of a list of words in the <code>VocabularyFilterFileUri</code> parameter,
         *        you can't use the <code>Words</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterFileUri(String vocabularyFilterFileUri);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String vocabularyFilterName;

        private String languageCode;

        private List<String> words = DefaultSdkAutoConstructList.getInstance();

        private String vocabularyFilterFileUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVocabularyFilterRequest model) {
            super(model);
            vocabularyFilterName(model.vocabularyFilterName);
            languageCode(model.languageCode);
            words(model.words);
            vocabularyFilterFileUri(model.vocabularyFilterFileUri);
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Collection<String> getWords() {
            return words;
        }

        @Override
        public final Builder words(Collection<String> words) {
            this.words = WordsCopier.copy(words);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder words(String... words) {
            words(Arrays.asList(words));
            return this;
        }

        public final void setWords(Collection<String> words) {
            this.words = WordsCopier.copy(words);
        }

        public final String getVocabularyFilterFileUri() {
            return vocabularyFilterFileUri;
        }

        @Override
        public final Builder vocabularyFilterFileUri(String vocabularyFilterFileUri) {
            this.vocabularyFilterFileUri = vocabularyFilterFileUri;
            return this;
        }

        public final void setVocabularyFilterFileUri(String vocabularyFilterFileUri) {
            this.vocabularyFilterFileUri = vocabularyFilterFileUri;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVocabularyFilterRequest build() {
            return new CreateVocabularyFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
