/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolNetworkPackageResponse extends TnbResponse implements
        ToCopyableBuilder<GetSolNetworkPackageResponse.Builder, GetSolNetworkPackageResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetSolNetworkPackageResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetSolNetworkPackageResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<GetSolNetworkPackageMetadata> METADATA_FIELD = SdkField
            .<GetSolNetworkPackageMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(GetSolNetworkPackageResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(GetSolNetworkPackageMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> NSD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("nsdId")
            .getter(getter(GetSolNetworkPackageResponse::nsdId)).setter(setter(Builder::nsdId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdId").build()).build();

    private static final SdkField<String> NSD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdName").getter(getter(GetSolNetworkPackageResponse::nsdName)).setter(setter(Builder::nsdName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdName").build()).build();

    private static final SdkField<String> NSD_ONBOARDING_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdOnboardingState").getter(getter(GetSolNetworkPackageResponse::nsdOnboardingStateAsString))
            .setter(setter(Builder::nsdOnboardingState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdOnboardingState").build())
            .build();

    private static final SdkField<String> NSD_OPERATIONAL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdOperationalState").getter(getter(GetSolNetworkPackageResponse::nsdOperationalStateAsString))
            .setter(setter(Builder::nsdOperationalState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdOperationalState").build())
            .build();

    private static final SdkField<String> NSD_USAGE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdUsageState").getter(getter(GetSolNetworkPackageResponse::nsdUsageStateAsString))
            .setter(setter(Builder::nsdUsageState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdUsageState").build()).build();

    private static final SdkField<String> NSD_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nsdVersion").getter(getter(GetSolNetworkPackageResponse::nsdVersion))
            .setter(setter(Builder::nsdVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdVersion").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetSolNetworkPackageResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> VNF_PKG_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vnfPkgIds")
            .getter(getter(GetSolNetworkPackageResponse::vnfPkgIds))
            .setter(setter(Builder::vnfPkgIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfPkgIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            METADATA_FIELD, NSD_ID_FIELD, NSD_NAME_FIELD, NSD_ONBOARDING_STATE_FIELD, NSD_OPERATIONAL_STATE_FIELD,
            NSD_USAGE_STATE_FIELD, NSD_VERSION_FIELD, TAGS_FIELD, VNF_PKG_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String id;

    private final GetSolNetworkPackageMetadata metadata;

    private final String nsdId;

    private final String nsdName;

    private final String nsdOnboardingState;

    private final String nsdOperationalState;

    private final String nsdUsageState;

    private final String nsdVersion;

    private final Map<String, String> tags;

    private final List<String> vnfPkgIds;

    private GetSolNetworkPackageResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.nsdId = builder.nsdId;
        this.nsdName = builder.nsdName;
        this.nsdOnboardingState = builder.nsdOnboardingState;
        this.nsdOperationalState = builder.nsdOperationalState;
        this.nsdUsageState = builder.nsdUsageState;
        this.nsdVersion = builder.nsdVersion;
        this.tags = builder.tags;
        this.vnfPkgIds = builder.vnfPkgIds;
    }

    /**
     * <p>
     * Network package ARN.
     * </p>
     * 
     * @return Network package ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Network package ID.
     * </p>
     * 
     * @return Network package ID.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the Metadata property for this object.
     * 
     * @return The value of the Metadata property for this object.
     */
    public final GetSolNetworkPackageMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Network service descriptor ID.
     * </p>
     * 
     * @return Network service descriptor ID.
     */
    public final String nsdId() {
        return nsdId;
    }

    /**
     * <p>
     * Network service descriptor name.
     * </p>
     * 
     * @return Network service descriptor name.
     */
    public final String nsdName() {
        return nsdName;
    }

    /**
     * <p>
     * Network service descriptor onboarding state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOnboardingState} will return {@link NsdOnboardingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #nsdOnboardingStateAsString}.
     * </p>
     * 
     * @return Network service descriptor onboarding state.
     * @see NsdOnboardingState
     */
    public final NsdOnboardingState nsdOnboardingState() {
        return NsdOnboardingState.fromValue(nsdOnboardingState);
    }

    /**
     * <p>
     * Network service descriptor onboarding state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOnboardingState} will return {@link NsdOnboardingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #nsdOnboardingStateAsString}.
     * </p>
     * 
     * @return Network service descriptor onboarding state.
     * @see NsdOnboardingState
     */
    public final String nsdOnboardingStateAsString() {
        return nsdOnboardingState;
    }

    /**
     * <p>
     * Network service descriptor operational state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOperationalState} will return {@link NsdOperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nsdOperationalStateAsString}.
     * </p>
     * 
     * @return Network service descriptor operational state.
     * @see NsdOperationalState
     */
    public final NsdOperationalState nsdOperationalState() {
        return NsdOperationalState.fromValue(nsdOperationalState);
    }

    /**
     * <p>
     * Network service descriptor operational state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nsdOperationalState} will return {@link NsdOperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nsdOperationalStateAsString}.
     * </p>
     * 
     * @return Network service descriptor operational state.
     * @see NsdOperationalState
     */
    public final String nsdOperationalStateAsString() {
        return nsdOperationalState;
    }

    /**
     * <p>
     * Network service descriptor usage state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nsdUsageState}
     * will return {@link NsdUsageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nsdUsageStateAsString}.
     * </p>
     * 
     * @return Network service descriptor usage state.
     * @see NsdUsageState
     */
    public final NsdUsageState nsdUsageState() {
        return NsdUsageState.fromValue(nsdUsageState);
    }

    /**
     * <p>
     * Network service descriptor usage state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nsdUsageState}
     * will return {@link NsdUsageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nsdUsageStateAsString}.
     * </p>
     * 
     * @return Network service descriptor usage state.
     * @see NsdUsageState
     */
    public final String nsdUsageStateAsString() {
        return nsdUsageState;
    }

    /**
     * <p>
     * Network service descriptor version.
     * </p>
     * 
     * @return Network service descriptor version.
     */
    public final String nsdVersion() {
        return nsdVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
     *         optional value. You can use tags to search and filter your resources or track your Amazon Web Services
     *         costs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the VnfPkgIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVnfPkgIds() {
        return vnfPkgIds != null && !(vnfPkgIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifies the function package for the function package descriptor referenced by the onboarded network package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVnfPkgIds} method.
     * </p>
     * 
     * @return Identifies the function package for the function package descriptor referenced by the onboarded network
     *         package.
     */
    public final List<String> vnfPkgIds() {
        return vnfPkgIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(nsdId());
        hashCode = 31 * hashCode + Objects.hashCode(nsdName());
        hashCode = 31 * hashCode + Objects.hashCode(nsdOnboardingStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nsdOperationalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nsdUsageStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nsdVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVnfPkgIds() ? vnfPkgIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolNetworkPackageResponse)) {
            return false;
        }
        GetSolNetworkPackageResponse other = (GetSolNetworkPackageResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(nsdId(), other.nsdId())
                && Objects.equals(nsdName(), other.nsdName())
                && Objects.equals(nsdOnboardingStateAsString(), other.nsdOnboardingStateAsString())
                && Objects.equals(nsdOperationalStateAsString(), other.nsdOperationalStateAsString())
                && Objects.equals(nsdUsageStateAsString(), other.nsdUsageStateAsString())
                && Objects.equals(nsdVersion(), other.nsdVersion()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasVnfPkgIds() == other.hasVnfPkgIds()
                && Objects.equals(vnfPkgIds(), other.vnfPkgIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolNetworkPackageResponse").add("Arn", arn()).add("Id", id()).add("Metadata", metadata())
                .add("NsdId", nsdId()).add("NsdName", nsdName()).add("NsdOnboardingState", nsdOnboardingStateAsString())
                .add("NsdOperationalState", nsdOperationalStateAsString()).add("NsdUsageState", nsdUsageStateAsString())
                .add("NsdVersion", nsdVersion()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VnfPkgIds", hasVnfPkgIds() ? vnfPkgIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "nsdId":
            return Optional.ofNullable(clazz.cast(nsdId()));
        case "nsdName":
            return Optional.ofNullable(clazz.cast(nsdName()));
        case "nsdOnboardingState":
            return Optional.ofNullable(clazz.cast(nsdOnboardingStateAsString()));
        case "nsdOperationalState":
            return Optional.ofNullable(clazz.cast(nsdOperationalStateAsString()));
        case "nsdUsageState":
            return Optional.ofNullable(clazz.cast(nsdUsageStateAsString()));
        case "nsdVersion":
            return Optional.ofNullable(clazz.cast(nsdVersion()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vnfPkgIds":
            return Optional.ofNullable(clazz.cast(vnfPkgIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("nsdId", NSD_ID_FIELD);
        map.put("nsdName", NSD_NAME_FIELD);
        map.put("nsdOnboardingState", NSD_ONBOARDING_STATE_FIELD);
        map.put("nsdOperationalState", NSD_OPERATIONAL_STATE_FIELD);
        map.put("nsdUsageState", NSD_USAGE_STATE_FIELD);
        map.put("nsdVersion", NSD_VERSION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("vnfPkgIds", VNF_PKG_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolNetworkPackageResponse, T> g) {
        return obj -> g.apply((GetSolNetworkPackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSolNetworkPackageResponse> {
        /**
         * <p>
         * Network package ARN.
         * </p>
         * 
         * @param arn
         *        Network package ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Network package ID.
         * </p>
         * 
         * @param id
         *        Network package ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * @param metadata
         *        The new value for the Metadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(GetSolNetworkPackageMetadata metadata);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GetSolNetworkPackageMetadata.Builder}
         * avoiding the need to create one manually via {@link GetSolNetworkPackageMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GetSolNetworkPackageMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(GetSolNetworkPackageMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link GetSolNetworkPackageMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(GetSolNetworkPackageMetadata)
         */
        default Builder metadata(Consumer<GetSolNetworkPackageMetadata.Builder> metadata) {
            return metadata(GetSolNetworkPackageMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Network service descriptor ID.
         * </p>
         * 
         * @param nsdId
         *        Network service descriptor ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdId(String nsdId);

        /**
         * <p>
         * Network service descriptor name.
         * </p>
         * 
         * @param nsdName
         *        Network service descriptor name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdName(String nsdName);

        /**
         * <p>
         * Network service descriptor onboarding state.
         * </p>
         * 
         * @param nsdOnboardingState
         *        Network service descriptor onboarding state.
         * @see NsdOnboardingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOnboardingState
         */
        Builder nsdOnboardingState(String nsdOnboardingState);

        /**
         * <p>
         * Network service descriptor onboarding state.
         * </p>
         * 
         * @param nsdOnboardingState
         *        Network service descriptor onboarding state.
         * @see NsdOnboardingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOnboardingState
         */
        Builder nsdOnboardingState(NsdOnboardingState nsdOnboardingState);

        /**
         * <p>
         * Network service descriptor operational state.
         * </p>
         * 
         * @param nsdOperationalState
         *        Network service descriptor operational state.
         * @see NsdOperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOperationalState
         */
        Builder nsdOperationalState(String nsdOperationalState);

        /**
         * <p>
         * Network service descriptor operational state.
         * </p>
         * 
         * @param nsdOperationalState
         *        Network service descriptor operational state.
         * @see NsdOperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdOperationalState
         */
        Builder nsdOperationalState(NsdOperationalState nsdOperationalState);

        /**
         * <p>
         * Network service descriptor usage state.
         * </p>
         * 
         * @param nsdUsageState
         *        Network service descriptor usage state.
         * @see NsdUsageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdUsageState
         */
        Builder nsdUsageState(String nsdUsageState);

        /**
         * <p>
         * Network service descriptor usage state.
         * </p>
         * 
         * @param nsdUsageState
         *        Network service descriptor usage state.
         * @see NsdUsageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NsdUsageState
         */
        Builder nsdUsageState(NsdUsageState nsdUsageState);

        /**
         * <p>
         * Network service descriptor version.
         * </p>
         * 
         * @param nsdVersion
         *        Network service descriptor version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nsdVersion(String nsdVersion);

        /**
         * <p>
         * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         * optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
         * </p>
         * 
         * @param tags
         *        A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an
         *        optional value. You can use tags to search and filter your resources or track your Amazon Web Services
         *        costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Identifies the function package for the function package descriptor referenced by the onboarded network
         * package.
         * </p>
         * 
         * @param vnfPkgIds
         *        Identifies the function package for the function package descriptor referenced by the onboarded
         *        network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfPkgIds(Collection<String> vnfPkgIds);

        /**
         * <p>
         * Identifies the function package for the function package descriptor referenced by the onboarded network
         * package.
         * </p>
         * 
         * @param vnfPkgIds
         *        Identifies the function package for the function package descriptor referenced by the onboarded
         *        network package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfPkgIds(String... vnfPkgIds);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private GetSolNetworkPackageMetadata metadata;

        private String nsdId;

        private String nsdName;

        private String nsdOnboardingState;

        private String nsdOperationalState;

        private String nsdUsageState;

        private String nsdVersion;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> vnfPkgIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolNetworkPackageResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            metadata(model.metadata);
            nsdId(model.nsdId);
            nsdName(model.nsdName);
            nsdOnboardingState(model.nsdOnboardingState);
            nsdOperationalState(model.nsdOperationalState);
            nsdUsageState(model.nsdUsageState);
            nsdVersion(model.nsdVersion);
            tags(model.tags);
            vnfPkgIds(model.vnfPkgIds);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final GetSolNetworkPackageMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(GetSolNetworkPackageMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(GetSolNetworkPackageMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsdId() {
            return nsdId;
        }

        public final void setNsdId(String nsdId) {
            this.nsdId = nsdId;
        }

        @Override
        public final Builder nsdId(String nsdId) {
            this.nsdId = nsdId;
            return this;
        }

        public final String getNsdName() {
            return nsdName;
        }

        public final void setNsdName(String nsdName) {
            this.nsdName = nsdName;
        }

        @Override
        public final Builder nsdName(String nsdName) {
            this.nsdName = nsdName;
            return this;
        }

        public final String getNsdOnboardingState() {
            return nsdOnboardingState;
        }

        public final void setNsdOnboardingState(String nsdOnboardingState) {
            this.nsdOnboardingState = nsdOnboardingState;
        }

        @Override
        public final Builder nsdOnboardingState(String nsdOnboardingState) {
            this.nsdOnboardingState = nsdOnboardingState;
            return this;
        }

        @Override
        public final Builder nsdOnboardingState(NsdOnboardingState nsdOnboardingState) {
            this.nsdOnboardingState(nsdOnboardingState == null ? null : nsdOnboardingState.toString());
            return this;
        }

        public final String getNsdOperationalState() {
            return nsdOperationalState;
        }

        public final void setNsdOperationalState(String nsdOperationalState) {
            this.nsdOperationalState = nsdOperationalState;
        }

        @Override
        public final Builder nsdOperationalState(String nsdOperationalState) {
            this.nsdOperationalState = nsdOperationalState;
            return this;
        }

        @Override
        public final Builder nsdOperationalState(NsdOperationalState nsdOperationalState) {
            this.nsdOperationalState(nsdOperationalState == null ? null : nsdOperationalState.toString());
            return this;
        }

        public final String getNsdUsageState() {
            return nsdUsageState;
        }

        public final void setNsdUsageState(String nsdUsageState) {
            this.nsdUsageState = nsdUsageState;
        }

        @Override
        public final Builder nsdUsageState(String nsdUsageState) {
            this.nsdUsageState = nsdUsageState;
            return this;
        }

        @Override
        public final Builder nsdUsageState(NsdUsageState nsdUsageState) {
            this.nsdUsageState(nsdUsageState == null ? null : nsdUsageState.toString());
            return this;
        }

        public final String getNsdVersion() {
            return nsdVersion;
        }

        public final void setNsdVersion(String nsdVersion) {
            this.nsdVersion = nsdVersion;
        }

        @Override
        public final Builder nsdVersion(String nsdVersion) {
            this.nsdVersion = nsdVersion;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getVnfPkgIds() {
            if (vnfPkgIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vnfPkgIds;
        }

        public final void setVnfPkgIds(Collection<String> vnfPkgIds) {
            this.vnfPkgIds = VnfPkgIdListCopier.copy(vnfPkgIds);
        }

        @Override
        public final Builder vnfPkgIds(Collection<String> vnfPkgIds) {
            this.vnfPkgIds = VnfPkgIdListCopier.copy(vnfPkgIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vnfPkgIds(String... vnfPkgIds) {
            vnfPkgIds(Arrays.asList(vnfPkgIds));
            return this;
        }

        @Override
        public GetSolNetworkPackageResponse build() {
            return new GetSolNetworkPackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
