/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.tnb.model.TagMapCopier;
import software.amazon.awssdk.services.tnb.model.TnbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSolNetworkInstanceRequest
extends TnbRequest
implements ToCopyableBuilder<Builder, CreateSolNetworkInstanceRequest> {
    private static final SdkField<String> NS_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsDescription").getter(CreateSolNetworkInstanceRequest.getter(CreateSolNetworkInstanceRequest::nsDescription)).setter(CreateSolNetworkInstanceRequest.setter(Builder::nsDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsDescription").build()}).build();
    private static final SdkField<String> NS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsName").getter(CreateSolNetworkInstanceRequest.getter(CreateSolNetworkInstanceRequest::nsName)).setter(CreateSolNetworkInstanceRequest.setter(Builder::nsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsName").build()}).build();
    private static final SdkField<String> NSD_INFO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdInfoId").getter(CreateSolNetworkInstanceRequest.getter(CreateSolNetworkInstanceRequest::nsdInfoId)).setter(CreateSolNetworkInstanceRequest.setter(Builder::nsdInfoId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdInfoId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSolNetworkInstanceRequest.getter(CreateSolNetworkInstanceRequest::tags)).setter(CreateSolNetworkInstanceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NS_DESCRIPTION_FIELD, NS_NAME_FIELD, NSD_INFO_ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nsDescription", NS_DESCRIPTION_FIELD);
            this.put("nsName", NS_NAME_FIELD);
            this.put("nsdInfoId", NSD_INFO_ID_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String nsDescription;
    private final String nsName;
    private final String nsdInfoId;
    private final Map<String, String> tags;

    private CreateSolNetworkInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.nsDescription = builder.nsDescription;
        this.nsName = builder.nsName;
        this.nsdInfoId = builder.nsdInfoId;
        this.tags = builder.tags;
    }

    public final String nsDescription() {
        return this.nsDescription;
    }

    public final String nsName() {
        return this.nsName;
    }

    public final String nsdInfoId() {
        return this.nsdInfoId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nsDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdInfoId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSolNetworkInstanceRequest)) {
            return false;
        }
        CreateSolNetworkInstanceRequest other = (CreateSolNetworkInstanceRequest)((Object)obj);
        return Objects.equals(this.nsDescription(), other.nsDescription()) && Objects.equals(this.nsName(), other.nsName()) && Objects.equals(this.nsdInfoId(), other.nsdInfoId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSolNetworkInstanceRequest").add("NsDescription", (Object)this.nsDescription()).add("NsName", (Object)this.nsName()).add("NsdInfoId", (Object)this.nsdInfoId()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nsDescription": {
                return Optional.ofNullable(clazz.cast(this.nsDescription()));
            }
            case "nsName": {
                return Optional.ofNullable(clazz.cast(this.nsName()));
            }
            case "nsdInfoId": {
                return Optional.ofNullable(clazz.cast(this.nsdInfoId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSolNetworkInstanceRequest, T> g) {
        return obj -> g.apply((CreateSolNetworkInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbRequest.BuilderImpl
    implements Builder {
        private String nsDescription;
        private String nsName;
        private String nsdInfoId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSolNetworkInstanceRequest model) {
            super(model);
            this.nsDescription(model.nsDescription);
            this.nsName(model.nsName);
            this.nsdInfoId(model.nsdInfoId);
            this.tags(model.tags);
        }

        public final String getNsDescription() {
            return this.nsDescription;
        }

        public final void setNsDescription(String nsDescription) {
            this.nsDescription = nsDescription;
        }

        @Override
        public final Builder nsDescription(String nsDescription) {
            this.nsDescription = nsDescription;
            return this;
        }

        public final String getNsName() {
            return this.nsName;
        }

        public final void setNsName(String nsName) {
            this.nsName = nsName;
        }

        @Override
        public final Builder nsName(String nsName) {
            this.nsName = nsName;
            return this;
        }

        public final String getNsdInfoId() {
            return this.nsdInfoId;
        }

        public final void setNsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
        }

        @Override
        public final Builder nsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSolNetworkInstanceRequest build() {
            return new CreateSolNetworkInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TnbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSolNetworkInstanceRequest> {
        public Builder nsDescription(String var1);

        public Builder nsName(String var1);

        public Builder nsdInfoId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

