/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.tnb.TnbClient;
import software.amazon.awssdk.services.tnb.internal.UserAgentUtils;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionPackageInfo;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesResponse;

public class ListSolFunctionPackagesIterable
implements SdkIterable<ListSolFunctionPackagesResponse> {
    private final TnbClient client;
    private final ListSolFunctionPackagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSolFunctionPackagesIterable(TnbClient client, ListSolFunctionPackagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSolFunctionPackagesResponseFetcher();
    }

    public Iterator<ListSolFunctionPackagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListSolFunctionPackageInfo> functionPackages() {
        Function<ListSolFunctionPackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.functionPackages() != null) {
                return response.functionPackages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSolFunctionPackagesResponseFetcher
    implements SyncPageFetcher<ListSolFunctionPackagesResponse> {
        private ListSolFunctionPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListSolFunctionPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSolFunctionPackagesResponse nextPage(ListSolFunctionPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListSolFunctionPackagesIterable.this.client.listSolFunctionPackages(ListSolFunctionPackagesIterable.this.firstRequest);
            }
            return ListSolFunctionPackagesIterable.this.client.listSolFunctionPackages((ListSolFunctionPackagesRequest)((Object)ListSolFunctionPackagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

