/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.tnb.DefaultTnbAsyncClient;
import software.amazon.awssdk.services.tnb.DefaultTnbBaseClientBuilder;
import software.amazon.awssdk.services.tnb.TnbAsyncClient;
import software.amazon.awssdk.services.tnb.TnbAsyncClientBuilder;
import software.amazon.awssdk.services.tnb.TnbServiceClientConfiguration;
import software.amazon.awssdk.services.tnb.endpoints.TnbEndpointProvider;

@SdkInternalApi
final class DefaultTnbAsyncClientBuilder
extends DefaultTnbBaseClientBuilder<TnbAsyncClientBuilder, TnbAsyncClient>
implements TnbAsyncClientBuilder {
    DefaultTnbAsyncClientBuilder() {
    }

    @Override
    public DefaultTnbAsyncClientBuilder endpointProvider(TnbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final TnbAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultTnbAsyncClientBuilder.validateClientOptions(clientConfiguration);
        TnbServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultTnbAsyncClient client = new DefaultTnbAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private TnbServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return TnbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

