/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.tnb.TnbAsyncClient;
import software.amazon.awssdk.services.tnb.internal.UserAgentUtils;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionPackageInfo;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesResponse;

public class ListSolFunctionPackagesPublisher
implements SdkPublisher<ListSolFunctionPackagesResponse> {
    private final TnbAsyncClient client;
    private final ListSolFunctionPackagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSolFunctionPackagesPublisher(TnbAsyncClient client, ListSolFunctionPackagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSolFunctionPackagesPublisher(TnbAsyncClient client, ListSolFunctionPackagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSolFunctionPackagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSolFunctionPackagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListSolFunctionPackageInfo> functionPackages() {
        Function<ListSolFunctionPackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.functionPackages() != null) {
                return response.functionPackages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSolFunctionPackagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSolFunctionPackagesResponseFetcher
    implements AsyncPageFetcher<ListSolFunctionPackagesResponse> {
        private ListSolFunctionPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListSolFunctionPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSolFunctionPackagesResponse> nextPage(ListSolFunctionPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListSolFunctionPackagesPublisher.this.client.listSolFunctionPackages(ListSolFunctionPackagesPublisher.this.firstRequest);
            }
            return ListSolFunctionPackagesPublisher.this.client.listSolFunctionPackages((ListSolFunctionPackagesRequest)((Object)ListSolFunctionPackagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

