/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamwrite.model.DataModel;
import software.amazon.awssdk.services.timestreamwrite.model.DataModelS3Configuration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataModelConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataModelConfiguration> {
    private static final SdkField<DataModel> DATA_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataModel").getter(DataModelConfiguration.getter(DataModelConfiguration::dataModel)).setter(DataModelConfiguration.setter(Builder::dataModel)).constructor(DataModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataModel").build()}).build();
    private static final SdkField<DataModelS3Configuration> DATA_MODEL_S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataModelS3Configuration").getter(DataModelConfiguration.getter(DataModelConfiguration::dataModelS3Configuration)).setter(DataModelConfiguration.setter(Builder::dataModelS3Configuration)).constructor(DataModelS3Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataModelS3Configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_MODEL_FIELD, DATA_MODEL_S3_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataModelConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DataModel dataModel;
    private final DataModelS3Configuration dataModelS3Configuration;

    private DataModelConfiguration(BuilderImpl builder) {
        this.dataModel = builder.dataModel;
        this.dataModelS3Configuration = builder.dataModelS3Configuration;
    }

    public final DataModel dataModel() {
        return this.dataModel;
    }

    public final DataModelS3Configuration dataModelS3Configuration() {
        return this.dataModelS3Configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataModelS3Configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataModelConfiguration)) {
            return false;
        }
        DataModelConfiguration other = (DataModelConfiguration)obj;
        return Objects.equals(this.dataModel(), other.dataModel()) && Objects.equals(this.dataModelS3Configuration(), other.dataModelS3Configuration());
    }

    public final String toString() {
        return ToString.builder((String)"DataModelConfiguration").add("DataModel", (Object)this.dataModel()).add("DataModelS3Configuration", (Object)this.dataModelS3Configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataModel": {
                return Optional.ofNullable(clazz.cast(this.dataModel()));
            }
            case "DataModelS3Configuration": {
                return Optional.ofNullable(clazz.cast(this.dataModelS3Configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataModel", DATA_MODEL_FIELD);
        map.put("DataModelS3Configuration", DATA_MODEL_S3_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataModelConfiguration, T> g) {
        return obj -> g.apply((DataModelConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataModel dataModel;
        private DataModelS3Configuration dataModelS3Configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataModelConfiguration model) {
            this.dataModel(model.dataModel);
            this.dataModelS3Configuration(model.dataModelS3Configuration);
        }

        public final DataModel.Builder getDataModel() {
            return this.dataModel != null ? this.dataModel.toBuilder() : null;
        }

        public final void setDataModel(DataModel.BuilderImpl dataModel) {
            this.dataModel = dataModel != null ? dataModel.build() : null;
        }

        @Override
        public final Builder dataModel(DataModel dataModel) {
            this.dataModel = dataModel;
            return this;
        }

        public final DataModelS3Configuration.Builder getDataModelS3Configuration() {
            return this.dataModelS3Configuration != null ? this.dataModelS3Configuration.toBuilder() : null;
        }

        public final void setDataModelS3Configuration(DataModelS3Configuration.BuilderImpl dataModelS3Configuration) {
            this.dataModelS3Configuration = dataModelS3Configuration != null ? dataModelS3Configuration.build() : null;
        }

        @Override
        public final Builder dataModelS3Configuration(DataModelS3Configuration dataModelS3Configuration) {
            this.dataModelS3Configuration = dataModelS3Configuration;
            return this;
        }

        public DataModelConfiguration build() {
            return new DataModelConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataModelConfiguration> {
        public Builder dataModel(DataModel var1);

        default public Builder dataModel(Consumer<DataModel.Builder> dataModel) {
            return this.dataModel((DataModel)((DataModel.Builder)DataModel.builder().applyMutation(dataModel)).build());
        }

        public Builder dataModelS3Configuration(DataModelS3Configuration var1);

        default public Builder dataModelS3Configuration(Consumer<DataModelS3Configuration.Builder> dataModelS3Configuration) {
            return this.dataModelS3Configuration((DataModelS3Configuration)((DataModelS3Configuration.Builder)DataModelS3Configuration.builder().applyMutation(dataModelS3Configuration)).build());
        }
    }
}

