/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteAsyncClient;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteAsyncEndpointDiscoveryCacheLoader;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteServiceClientConfiguration;
import software.amazon.awssdk.services.timestreamwrite.internal.TimestreamWriteServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.timestreamwrite.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreamwrite.model.ConflictException;
import software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskResponse;
import software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.CreateTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeBatchLoadTaskRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeBatchLoadTaskResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.InternalServerException;
import software.amazon.awssdk.services.timestreamwrite.model.InvalidEndpointException;
import software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.RejectedRecordsException;
import software.amazon.awssdk.services.timestreamwrite.model.ResourceNotFoundException;
import software.amazon.awssdk.services.timestreamwrite.model.ResumeBatchLoadTaskRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ResumeBatchLoadTaskResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.timestreamwrite.model.TagResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.TagResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ThrottlingException;
import software.amazon.awssdk.services.timestreamwrite.model.TimestreamWriteException;
import software.amazon.awssdk.services.timestreamwrite.model.UntagResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UntagResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ValidationException;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsResponse;
import software.amazon.awssdk.services.timestreamwrite.transform.CreateBatchLoadTaskRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.CreateDatabaseRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.CreateTableRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DeleteDatabaseRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DeleteTableRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DescribeBatchLoadTaskRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DescribeDatabaseRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DescribeTableRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.ListBatchLoadTasksRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.ListDatabasesRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.ListTablesRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.ResumeBatchLoadTaskRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.UpdateDatabaseRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.UpdateTableRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.WriteRecordsRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultTimestreamWriteAsyncClient
implements TimestreamWriteAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultTimestreamWriteAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private EndpointDiscoveryRefreshCache endpointDiscoveryCache;

    protected DefaultTimestreamWriteAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        if (((Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)).booleanValue()) {
            this.endpointDiscoveryCache = EndpointDiscoveryRefreshCache.create((EndpointDiscoveryCacheLoader)TimestreamWriteAsyncEndpointDiscoveryCacheLoader.create(this));
            if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE) {
                log.warn("Endpoint discovery is enabled for this client, and an endpoint override was also specified. This will disable endpoint discovery for methods that require it, instead using the specified endpoint override. This may or may not be what you intended.");
            }
        }
    }

    @Override
    public CompletableFuture<CreateBatchLoadTaskResponse> createBatchLoadTask(CreateBatchLoadTaskRequest createBatchLoadTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBatchLoadTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, createBatchLoadTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBatchLoadTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBatchLoadTaskResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = createBatchLoadTaskRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createBatchLoadTaskRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$createBatchLoadTask$2(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, createBatchLoadTaskRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$createBatchLoadTask$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$createBatchLoadTask$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDatabaseResponse> createDatabase(CreateDatabaseRequest createDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, createDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = createDatabaseRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createDatabaseRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$createDatabase$8(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, createDatabaseRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$createDatabase$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$createDatabase$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTableResponse> createTable(CreateTableRequest createTableRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, createTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = createTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createTableRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$createTable$14(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, createTableRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$createTable$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$createTable$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDatabaseResponse> deleteDatabase(DeleteDatabaseRequest deleteDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = deleteDatabaseRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteDatabaseRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$deleteDatabase$20(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, deleteDatabaseRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$deleteDatabase$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$deleteDatabase$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTableResponse> deleteTable(DeleteTableRequest deleteTableRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = deleteTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteTableRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$deleteTable$26(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, deleteTableRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$deleteTable$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$deleteTable$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeBatchLoadTaskResponse> describeBatchLoadTask(DescribeBatchLoadTaskRequest describeBatchLoadTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBatchLoadTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, describeBatchLoadTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBatchLoadTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBatchLoadTaskResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeBatchLoadTaskRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeBatchLoadTaskRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeBatchLoadTask$32(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeBatchLoadTaskRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$describeBatchLoadTask$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$describeBatchLoadTask$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDatabaseResponse> describeDatabase(DescribeDatabaseRequest describeDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, describeDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeDatabaseRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeDatabaseRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeDatabase$38(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeDatabaseRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$describeDatabase$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$describeDatabase$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEndpointsResponse> describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, describeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEndpointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$describeEndpoints$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$describeEndpoints$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTableResponse> describeTable(DescribeTableRequest describeTableRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, describeTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeTableRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeTable$47(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeTableRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$describeTable$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$describeTable$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListBatchLoadTasksResponse> listBatchLoadTasks(ListBatchLoadTasksRequest listBatchLoadTasksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBatchLoadTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, listBatchLoadTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBatchLoadTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBatchLoadTasksResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = listBatchLoadTasksRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listBatchLoadTasksRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$listBatchLoadTasks$53(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, listBatchLoadTasksRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$listBatchLoadTasks$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$listBatchLoadTasks$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDatabasesResponse> listDatabases(ListDatabasesRequest listDatabasesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDatabasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, listDatabasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatabases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatabasesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = listDatabasesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listDatabasesRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$listDatabases$59(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, listDatabasesRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$listDatabases$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$listDatabases$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTablesResponse> listTables(ListTablesRequest listTablesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTablesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, listTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTables");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTablesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = listTablesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listTablesRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$listTables$65(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, listTablesRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$listTables$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$listTables$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = listTagsForResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listTagsForResourceRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$listTagsForResource$71(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, listTagsForResourceRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$listTagsForResource$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$listTagsForResource$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResumeBatchLoadTaskResponse> resumeBatchLoadTask(ResumeBatchLoadTaskRequest resumeBatchLoadTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resumeBatchLoadTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, resumeBatchLoadTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResumeBatchLoadTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResumeBatchLoadTaskResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = resumeBatchLoadTaskRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)resumeBatchLoadTaskRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$resumeBatchLoadTask$77(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, resumeBatchLoadTaskRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$resumeBatchLoadTask$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$resumeBatchLoadTask$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = tagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)tagResourceRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$tagResource$83(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, tagResourceRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$tagResource$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$tagResource$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = untagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)untagResourceRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$untagResource$89(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, untagResourceRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$untagResource$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$untagResource$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDatabaseResponse> updateDatabase(UpdateDatabaseRequest updateDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, updateDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = updateDatabaseRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateDatabaseRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$updateDatabase$95(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, updateDatabaseRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$updateDatabase$97(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$updateDatabase$98((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTableResponse> updateTable(UpdateTableRequest updateTableRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, updateTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = updateTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateTableRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$updateTable$101(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, updateTableRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$updateTable$103(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$updateTable$104((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<WriteRecordsResponse> writeRecords(WriteRecordsRequest writeRecordsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)writeRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(clientConfiguration, writeRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"WriteRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, WriteRecordsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = writeRecordsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)writeRecordsRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$writeRecords$107(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, writeRecordsRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$writeRecords$109(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$writeRecords$110((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final TimestreamWriteServiceClientConfiguration serviceClientConfiguration() {
        return new TimestreamWriteServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "timestream";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TimestreamWriteException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEndpointException").exceptionBuilderSupplier(InvalidEndpointException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RejectedRecordsException").exceptionBuilderSupplier(RejectedRecordsException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        TimestreamWriteServiceClientConfigurationBuilder serviceConfigBuilder = new TimestreamWriteServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$writeRecords$110(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$writeRecords$109(List metricPublishers, MetricCollector apiCallMetricCollector, WriteRecordsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$writeRecords$107(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, WriteRecordsRequest writeRecordsRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("WriteRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new WriteRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)writeRecordsRequest));
    }

    private static /* synthetic */ void lambda$updateTable$104(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTable$103(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$updateTable$101(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UpdateTableRequest updateTableRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateTableRequest));
    }

    private static /* synthetic */ void lambda$updateDatabase$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDatabase$97(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$updateDatabase$95(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UpdateDatabaseRequest updateDatabaseRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateDatabaseRequest));
    }

    private static /* synthetic */ void lambda$untagResource$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$91(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$untagResource$89(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UntagResourceRequest untagResourceRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)untagResourceRequest));
    }

    private static /* synthetic */ void lambda$tagResource$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$85(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$tagResource$83(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, TagResourceRequest tagResourceRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)tagResourceRequest));
    }

    private static /* synthetic */ void lambda$resumeBatchLoadTask$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resumeBatchLoadTask$79(List metricPublishers, MetricCollector apiCallMetricCollector, ResumeBatchLoadTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$resumeBatchLoadTask$77(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ResumeBatchLoadTaskRequest resumeBatchLoadTaskRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResumeBatchLoadTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ResumeBatchLoadTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)resumeBatchLoadTaskRequest));
    }

    private static /* synthetic */ void lambda$listTagsForResource$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$73(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$listTagsForResource$71(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ListTagsForResourceRequest listTagsForResourceRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTagsForResourceRequest));
    }

    private static /* synthetic */ void lambda$listTables$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTables$67(List metricPublishers, MetricCollector apiCallMetricCollector, ListTablesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$listTables$65(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ListTablesRequest listTablesRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTables").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTablesRequest));
    }

    private static /* synthetic */ void lambda$listDatabases$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatabases$61(List metricPublishers, MetricCollector apiCallMetricCollector, ListDatabasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$listDatabases$59(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ListDatabasesRequest listDatabasesRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatabases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listDatabasesRequest));
    }

    private static /* synthetic */ void lambda$listBatchLoadTasks$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBatchLoadTasks$55(List metricPublishers, MetricCollector apiCallMetricCollector, ListBatchLoadTasksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$listBatchLoadTasks$53(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ListBatchLoadTasksRequest listBatchLoadTasksRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBatchLoadTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListBatchLoadTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listBatchLoadTasksRequest));
    }

    private static /* synthetic */ void lambda$describeTable$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTable$49(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeTable$47(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeTableRequest describeTableRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeTableRequest));
    }

    private static /* synthetic */ void lambda$describeEndpoints$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoints$43(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDatabase$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDatabase$40(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeDatabase$38(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeDatabaseRequest describeDatabaseRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeDatabaseRequest));
    }

    private static /* synthetic */ void lambda$describeBatchLoadTask$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBatchLoadTask$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeBatchLoadTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeBatchLoadTask$32(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeBatchLoadTaskRequest describeBatchLoadTaskRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBatchLoadTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeBatchLoadTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeBatchLoadTaskRequest));
    }

    private static /* synthetic */ void lambda$deleteTable$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTable$28(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$deleteTable$26(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DeleteTableRequest deleteTableRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteTableRequest));
    }

    private static /* synthetic */ void lambda$deleteDatabase$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDatabase$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$deleteDatabase$20(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DeleteDatabaseRequest deleteDatabaseRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteDatabaseRequest));
    }

    private static /* synthetic */ void lambda$createTable$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTable$16(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$createTable$14(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, CreateTableRequest createTableRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createTableRequest));
    }

    private static /* synthetic */ void lambda$createDatabase$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatabase$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$createDatabase$8(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, CreateDatabaseRequest createDatabaseRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createDatabaseRequest));
    }

    private static /* synthetic */ void lambda$createBatchLoadTask$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBatchLoadTask$4(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBatchLoadTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$createBatchLoadTask$2(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, CreateBatchLoadTaskRequest createBatchLoadTaskRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBatchLoadTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateBatchLoadTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createBatchLoadTaskRequest));
    }
}

