/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionStats
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionStats> {
    private static final SdkField<Long> EXECUTION_TIME_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ExecutionTimeInMillis").getter(ExecutionStats.getter(ExecutionStats::executionTimeInMillis)).setter(ExecutionStats.setter(Builder::executionTimeInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimeInMillis").build()}).build();
    private static final SdkField<Long> DATA_WRITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DataWrites").getter(ExecutionStats.getter(ExecutionStats::dataWrites)).setter(ExecutionStats.setter(Builder::dataWrites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataWrites").build()}).build();
    private static final SdkField<Long> BYTES_METERED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesMetered").getter(ExecutionStats.getter(ExecutionStats::bytesMetered)).setter(ExecutionStats.setter(Builder::bytesMetered)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesMetered").build()}).build();
    private static final SdkField<Long> CUMULATIVE_BYTES_SCANNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CumulativeBytesScanned").getter(ExecutionStats.getter(ExecutionStats::cumulativeBytesScanned)).setter(ExecutionStats.setter(Builder::cumulativeBytesScanned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CumulativeBytesScanned").build()}).build();
    private static final SdkField<Long> RECORDS_INGESTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RecordsIngested").getter(ExecutionStats.getter(ExecutionStats::recordsIngested)).setter(ExecutionStats.setter(Builder::recordsIngested)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsIngested").build()}).build();
    private static final SdkField<Long> QUERY_RESULT_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("QueryResultRows").getter(ExecutionStats.getter(ExecutionStats::queryResultRows)).setter(ExecutionStats.setter(Builder::queryResultRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryResultRows").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_TIME_IN_MILLIS_FIELD, DATA_WRITES_FIELD, BYTES_METERED_FIELD, CUMULATIVE_BYTES_SCANNED_FIELD, RECORDS_INGESTED_FIELD, QUERY_RESULT_ROWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ExecutionTimeInMillis", EXECUTION_TIME_IN_MILLIS_FIELD);
            this.put("DataWrites", DATA_WRITES_FIELD);
            this.put("BytesMetered", BYTES_METERED_FIELD);
            this.put("CumulativeBytesScanned", CUMULATIVE_BYTES_SCANNED_FIELD);
            this.put("RecordsIngested", RECORDS_INGESTED_FIELD);
            this.put("QueryResultRows", QUERY_RESULT_ROWS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long executionTimeInMillis;
    private final Long dataWrites;
    private final Long bytesMetered;
    private final Long cumulativeBytesScanned;
    private final Long recordsIngested;
    private final Long queryResultRows;

    private ExecutionStats(BuilderImpl builder) {
        this.executionTimeInMillis = builder.executionTimeInMillis;
        this.dataWrites = builder.dataWrites;
        this.bytesMetered = builder.bytesMetered;
        this.cumulativeBytesScanned = builder.cumulativeBytesScanned;
        this.recordsIngested = builder.recordsIngested;
        this.queryResultRows = builder.queryResultRows;
    }

    public final Long executionTimeInMillis() {
        return this.executionTimeInMillis;
    }

    public final Long dataWrites() {
        return this.dataWrites;
    }

    public final Long bytesMetered() {
        return this.bytesMetered;
    }

    public final Long cumulativeBytesScanned() {
        return this.cumulativeBytesScanned;
    }

    public final Long recordsIngested() {
        return this.recordsIngested;
    }

    public final Long queryResultRows() {
        return this.queryResultRows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataWrites());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesMetered());
        hashCode = 31 * hashCode + Objects.hashCode(this.cumulativeBytesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordsIngested());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryResultRows());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionStats)) {
            return false;
        }
        ExecutionStats other = (ExecutionStats)obj;
        return Objects.equals(this.executionTimeInMillis(), other.executionTimeInMillis()) && Objects.equals(this.dataWrites(), other.dataWrites()) && Objects.equals(this.bytesMetered(), other.bytesMetered()) && Objects.equals(this.cumulativeBytesScanned(), other.cumulativeBytesScanned()) && Objects.equals(this.recordsIngested(), other.recordsIngested()) && Objects.equals(this.queryResultRows(), other.queryResultRows());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionStats").add("ExecutionTimeInMillis", (Object)this.executionTimeInMillis()).add("DataWrites", (Object)this.dataWrites()).add("BytesMetered", (Object)this.bytesMetered()).add("CumulativeBytesScanned", (Object)this.cumulativeBytesScanned()).add("RecordsIngested", (Object)this.recordsIngested()).add("QueryResultRows", (Object)this.queryResultRows()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionTimeInMillis": {
                return Optional.ofNullable(clazz.cast(this.executionTimeInMillis()));
            }
            case "DataWrites": {
                return Optional.ofNullable(clazz.cast(this.dataWrites()));
            }
            case "BytesMetered": {
                return Optional.ofNullable(clazz.cast(this.bytesMetered()));
            }
            case "CumulativeBytesScanned": {
                return Optional.ofNullable(clazz.cast(this.cumulativeBytesScanned()));
            }
            case "RecordsIngested": {
                return Optional.ofNullable(clazz.cast(this.recordsIngested()));
            }
            case "QueryResultRows": {
                return Optional.ofNullable(clazz.cast(this.queryResultRows()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionStats, T> g) {
        return obj -> g.apply((ExecutionStats)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long executionTimeInMillis;
        private Long dataWrites;
        private Long bytesMetered;
        private Long cumulativeBytesScanned;
        private Long recordsIngested;
        private Long queryResultRows;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionStats model) {
            this.executionTimeInMillis(model.executionTimeInMillis);
            this.dataWrites(model.dataWrites);
            this.bytesMetered(model.bytesMetered);
            this.cumulativeBytesScanned(model.cumulativeBytesScanned);
            this.recordsIngested(model.recordsIngested);
            this.queryResultRows(model.queryResultRows);
        }

        public final Long getExecutionTimeInMillis() {
            return this.executionTimeInMillis;
        }

        public final void setExecutionTimeInMillis(Long executionTimeInMillis) {
            this.executionTimeInMillis = executionTimeInMillis;
        }

        @Override
        public final Builder executionTimeInMillis(Long executionTimeInMillis) {
            this.executionTimeInMillis = executionTimeInMillis;
            return this;
        }

        public final Long getDataWrites() {
            return this.dataWrites;
        }

        public final void setDataWrites(Long dataWrites) {
            this.dataWrites = dataWrites;
        }

        @Override
        public final Builder dataWrites(Long dataWrites) {
            this.dataWrites = dataWrites;
            return this;
        }

        public final Long getBytesMetered() {
            return this.bytesMetered;
        }

        public final void setBytesMetered(Long bytesMetered) {
            this.bytesMetered = bytesMetered;
        }

        @Override
        public final Builder bytesMetered(Long bytesMetered) {
            this.bytesMetered = bytesMetered;
            return this;
        }

        public final Long getCumulativeBytesScanned() {
            return this.cumulativeBytesScanned;
        }

        public final void setCumulativeBytesScanned(Long cumulativeBytesScanned) {
            this.cumulativeBytesScanned = cumulativeBytesScanned;
        }

        @Override
        public final Builder cumulativeBytesScanned(Long cumulativeBytesScanned) {
            this.cumulativeBytesScanned = cumulativeBytesScanned;
            return this;
        }

        public final Long getRecordsIngested() {
            return this.recordsIngested;
        }

        public final void setRecordsIngested(Long recordsIngested) {
            this.recordsIngested = recordsIngested;
        }

        @Override
        public final Builder recordsIngested(Long recordsIngested) {
            this.recordsIngested = recordsIngested;
            return this;
        }

        public final Long getQueryResultRows() {
            return this.queryResultRows;
        }

        public final void setQueryResultRows(Long queryResultRows) {
            this.queryResultRows = queryResultRows;
        }

        @Override
        public final Builder queryResultRows(Long queryResultRows) {
            this.queryResultRows = queryResultRows;
            return this;
        }

        public ExecutionStats build() {
            return new ExecutionStats(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionStats> {
        public Builder executionTimeInMillis(Long var1);

        public Builder dataWrites(Long var1);

        public Builder bytesMetered(Long var1);

        public Builder cumulativeBytesScanned(Long var1);

        public Builder recordsIngested(Long var1);

        public Builder queryResultRows(Long var1);
    }
}

