/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.TimestreamInfluxDbAsyncClient;
import software.amazon.awssdk.services.timestreaminfluxdb.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbClusterSummary;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersResponse;

public class ListDbClustersPublisher
implements SdkPublisher<ListDbClustersResponse> {
    private final TimestreamInfluxDbAsyncClient client;
    private final ListDbClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDbClustersPublisher(TimestreamInfluxDbAsyncClient client, ListDbClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDbClustersPublisher(TimestreamInfluxDbAsyncClient client, ListDbClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDbClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDbClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DbClusterSummary> items() {
        Function<ListDbClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDbClustersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDbClustersResponseFetcher
    implements AsyncPageFetcher<ListDbClustersResponse> {
        private ListDbClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListDbClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDbClustersResponse> nextPage(ListDbClustersResponse previousPage) {
            if (previousPage == null) {
                return ListDbClustersPublisher.this.client.listDbClusters(ListDbClustersPublisher.this.firstRequest);
            }
            return ListDbClustersPublisher.this.client.listDbClusters((ListDbClustersRequest)((Object)ListDbClustersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

