/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.TimestreamInfluxDbAsyncClient;
import software.amazon.awssdk.services.timestreaminfluxdb.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbInstanceForClusterSummary;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterResponse;

public class ListDbInstancesForClusterPublisher
implements SdkPublisher<ListDbInstancesForClusterResponse> {
    private final TimestreamInfluxDbAsyncClient client;
    private final ListDbInstancesForClusterRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDbInstancesForClusterPublisher(TimestreamInfluxDbAsyncClient client, ListDbInstancesForClusterRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDbInstancesForClusterPublisher(TimestreamInfluxDbAsyncClient client, ListDbInstancesForClusterRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDbInstancesForClusterResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDbInstancesForClusterResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DbInstanceForClusterSummary> items() {
        Function<ListDbInstancesForClusterResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDbInstancesForClusterResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDbInstancesForClusterResponseFetcher
    implements AsyncPageFetcher<ListDbInstancesForClusterResponse> {
        private ListDbInstancesForClusterResponseFetcher() {
        }

        public boolean hasNextPage(ListDbInstancesForClusterResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDbInstancesForClusterResponse> nextPage(ListDbInstancesForClusterResponse previousPage) {
            if (previousPage == null) {
                return ListDbInstancesForClusterPublisher.this.client.listDbInstancesForCluster(ListDbInstancesForClusterPublisher.this.firstRequest);
            }
            return ListDbInstancesForClusterPublisher.this.client.listDbInstancesForCluster((ListDbInstancesForClusterRequest)((Object)ListDbInstancesForClusterPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

