/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreaminfluxdb.model.LogLevel;
import software.amazon.awssdk.services.timestreaminfluxdb.model.TracingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InfluxDBv2Parameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InfluxDBv2Parameters> {
    private static final SdkField<Boolean> FLUX_LOG_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("fluxLogEnabled").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::fluxLogEnabled)).setter(InfluxDBv2Parameters.setter(Builder::fluxLogEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fluxLogEnabled").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logLevel").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::logLevelAsString)).setter(InfluxDBv2Parameters.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final SdkField<Boolean> NO_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("noTasks").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::noTasks)).setter(InfluxDBv2Parameters.setter(Builder::noTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noTasks").build()}).build();
    private static final SdkField<Integer> QUERY_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queryConcurrency").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::queryConcurrency)).setter(InfluxDBv2Parameters.setter(Builder::queryConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryConcurrency").build()}).build();
    private static final SdkField<Integer> QUERY_QUEUE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queryQueueSize").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::queryQueueSize)).setter(InfluxDBv2Parameters.setter(Builder::queryQueueSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryQueueSize").build()}).build();
    private static final SdkField<String> TRACING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tracingType").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::tracingTypeAsString)).setter(InfluxDBv2Parameters.setter(Builder::tracingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingType").build()}).build();
    private static final SdkField<Boolean> METRICS_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("metricsDisabled").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::metricsDisabled)).setter(InfluxDBv2Parameters.setter(Builder::metricsDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsDisabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLUX_LOG_ENABLED_FIELD, LOG_LEVEL_FIELD, NO_TASKS_FIELD, QUERY_CONCURRENCY_FIELD, QUERY_QUEUE_SIZE_FIELD, TRACING_TYPE_FIELD, METRICS_DISABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean fluxLogEnabled;
    private final String logLevel;
    private final Boolean noTasks;
    private final Integer queryConcurrency;
    private final Integer queryQueueSize;
    private final String tracingType;
    private final Boolean metricsDisabled;

    private InfluxDBv2Parameters(BuilderImpl builder) {
        this.fluxLogEnabled = builder.fluxLogEnabled;
        this.logLevel = builder.logLevel;
        this.noTasks = builder.noTasks;
        this.queryConcurrency = builder.queryConcurrency;
        this.queryQueueSize = builder.queryQueueSize;
        this.tracingType = builder.tracingType;
        this.metricsDisabled = builder.metricsDisabled;
    }

    public final Boolean fluxLogEnabled() {
        return this.fluxLogEnabled;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final Boolean noTasks() {
        return this.noTasks;
    }

    public final Integer queryConcurrency() {
        return this.queryConcurrency;
    }

    public final Integer queryQueueSize() {
        return this.queryQueueSize;
    }

    public final TracingType tracingType() {
        return TracingType.fromValue(this.tracingType);
    }

    public final String tracingTypeAsString() {
        return this.tracingType;
    }

    public final Boolean metricsDisabled() {
        return this.metricsDisabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fluxLogEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.noTasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryQueueSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsDisabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InfluxDBv2Parameters)) {
            return false;
        }
        InfluxDBv2Parameters other = (InfluxDBv2Parameters)obj;
        return Objects.equals(this.fluxLogEnabled(), other.fluxLogEnabled()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.noTasks(), other.noTasks()) && Objects.equals(this.queryConcurrency(), other.queryConcurrency()) && Objects.equals(this.queryQueueSize(), other.queryQueueSize()) && Objects.equals(this.tracingTypeAsString(), other.tracingTypeAsString()) && Objects.equals(this.metricsDisabled(), other.metricsDisabled());
    }

    public final String toString() {
        return ToString.builder((String)"InfluxDBv2Parameters").add("FluxLogEnabled", (Object)this.fluxLogEnabled()).add("LogLevel", (Object)this.logLevelAsString()).add("NoTasks", (Object)this.noTasks()).add("QueryConcurrency", (Object)this.queryConcurrency()).add("QueryQueueSize", (Object)this.queryQueueSize()).add("TracingType", (Object)this.tracingTypeAsString()).add("MetricsDisabled", (Object)this.metricsDisabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fluxLogEnabled": {
                return Optional.ofNullable(clazz.cast(this.fluxLogEnabled()));
            }
            case "logLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "noTasks": {
                return Optional.ofNullable(clazz.cast(this.noTasks()));
            }
            case "queryConcurrency": {
                return Optional.ofNullable(clazz.cast(this.queryConcurrency()));
            }
            case "queryQueueSize": {
                return Optional.ofNullable(clazz.cast(this.queryQueueSize()));
            }
            case "tracingType": {
                return Optional.ofNullable(clazz.cast(this.tracingTypeAsString()));
            }
            case "metricsDisabled": {
                return Optional.ofNullable(clazz.cast(this.metricsDisabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InfluxDBv2Parameters, T> g) {
        return obj -> g.apply((InfluxDBv2Parameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean fluxLogEnabled;
        private String logLevel;
        private Boolean noTasks;
        private Integer queryConcurrency;
        private Integer queryQueueSize;
        private String tracingType;
        private Boolean metricsDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(InfluxDBv2Parameters model) {
            this.fluxLogEnabled(model.fluxLogEnabled);
            this.logLevel(model.logLevel);
            this.noTasks(model.noTasks);
            this.queryConcurrency(model.queryConcurrency);
            this.queryQueueSize(model.queryQueueSize);
            this.tracingType(model.tracingType);
            this.metricsDisabled(model.metricsDisabled);
        }

        public final Boolean getFluxLogEnabled() {
            return this.fluxLogEnabled;
        }

        public final void setFluxLogEnabled(Boolean fluxLogEnabled) {
            this.fluxLogEnabled = fluxLogEnabled;
        }

        @Override
        public final Builder fluxLogEnabled(Boolean fluxLogEnabled) {
            this.fluxLogEnabled = fluxLogEnabled;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final Boolean getNoTasks() {
            return this.noTasks;
        }

        public final void setNoTasks(Boolean noTasks) {
            this.noTasks = noTasks;
        }

        @Override
        public final Builder noTasks(Boolean noTasks) {
            this.noTasks = noTasks;
            return this;
        }

        public final Integer getQueryConcurrency() {
            return this.queryConcurrency;
        }

        public final void setQueryConcurrency(Integer queryConcurrency) {
            this.queryConcurrency = queryConcurrency;
        }

        @Override
        public final Builder queryConcurrency(Integer queryConcurrency) {
            this.queryConcurrency = queryConcurrency;
            return this;
        }

        public final Integer getQueryQueueSize() {
            return this.queryQueueSize;
        }

        public final void setQueryQueueSize(Integer queryQueueSize) {
            this.queryQueueSize = queryQueueSize;
        }

        @Override
        public final Builder queryQueueSize(Integer queryQueueSize) {
            this.queryQueueSize = queryQueueSize;
            return this;
        }

        public final String getTracingType() {
            return this.tracingType;
        }

        public final void setTracingType(String tracingType) {
            this.tracingType = tracingType;
        }

        @Override
        public final Builder tracingType(String tracingType) {
            this.tracingType = tracingType;
            return this;
        }

        @Override
        public final Builder tracingType(TracingType tracingType) {
            this.tracingType(tracingType == null ? null : tracingType.toString());
            return this;
        }

        public final Boolean getMetricsDisabled() {
            return this.metricsDisabled;
        }

        public final void setMetricsDisabled(Boolean metricsDisabled) {
            this.metricsDisabled = metricsDisabled;
        }

        @Override
        public final Builder metricsDisabled(Boolean metricsDisabled) {
            this.metricsDisabled = metricsDisabled;
            return this;
        }

        public InfluxDBv2Parameters build() {
            return new InfluxDBv2Parameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InfluxDBv2Parameters> {
        public Builder fluxLogEnabled(Boolean var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder noTasks(Boolean var1);

        public Builder queryConcurrency(Integer var1);

        public Builder queryQueueSize(Integer var1);

        public Builder tracingType(String var1);

        public Builder tracingType(TracingType var1);

        public Builder metricsDisabled(Boolean var1);
    }
}

