/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TracingType {
    LOG("log"),
    JAEGER("jaeger"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TracingType> VALUE_MAP;
    private final String value;

    private TracingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TracingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TracingType> knownValues() {
        EnumSet<TracingType> knownValues = EnumSet.allOf(TracingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TracingType.class, TracingType::toString);
    }
}

