/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.Block;
import software.amazon.awssdk.services.textract.model.BlockListCopier;
import software.amazon.awssdk.services.textract.model.DocumentMetadata;
import software.amazon.awssdk.services.textract.model.JobStatus;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.services.textract.model.Warning;
import software.amazon.awssdk.services.textract.model.WarningsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDocumentAnalysisResponse
extends TextractResponse
implements ToCopyableBuilder<Builder, GetDocumentAnalysisResponse> {
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetDocumentAnalysisResponse.getter(GetDocumentAnalysisResponse::documentMetadata)).setter(GetDocumentAnalysisResponse.setter(Builder::documentMetadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDocumentAnalysisResponse.getter(GetDocumentAnalysisResponse::jobStatusAsString)).setter(GetDocumentAnalysisResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDocumentAnalysisResponse.getter(GetDocumentAnalysisResponse::nextToken)).setter(GetDocumentAnalysisResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Block>> BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetDocumentAnalysisResponse.getter(GetDocumentAnalysisResponse::blocks)).setter(GetDocumentAnalysisResponse.setter(Builder::blocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Block::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Warning>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetDocumentAnalysisResponse.getter(GetDocumentAnalysisResponse::warnings)).setter(GetDocumentAnalysisResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Warning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDocumentAnalysisResponse.getter(GetDocumentAnalysisResponse::statusMessage)).setter(GetDocumentAnalysisResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_METADATA_FIELD, JOB_STATUS_FIELD, NEXT_TOKEN_FIELD, BLOCKS_FIELD, WARNINGS_FIELD, STATUS_MESSAGE_FIELD));
    private final DocumentMetadata documentMetadata;
    private final String jobStatus;
    private final String nextToken;
    private final List<Block> blocks;
    private final List<Warning> warnings;
    private final String statusMessage;

    private GetDocumentAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.documentMetadata = builder.documentMetadata;
        this.jobStatus = builder.jobStatus;
        this.nextToken = builder.nextToken;
        this.blocks = builder.blocks;
        this.warnings = builder.warnings;
        this.statusMessage = builder.statusMessage;
    }

    public DocumentMetadata documentMetadata() {
        return this.documentMetadata;
    }

    public JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<Block> blocks() {
        return this.blocks;
    }

    public List<Warning> warnings() {
        return this.warnings;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.blocks());
        hashCode = 31 * hashCode + Objects.hashCode(this.warnings());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentAnalysisResponse)) {
            return false;
        }
        GetDocumentAnalysisResponse other = (GetDocumentAnalysisResponse)((Object)obj);
        return Objects.equals(this.documentMetadata(), other.documentMetadata()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.blocks(), other.blocks()) && Objects.equals(this.warnings(), other.warnings()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public String toString() {
        return ToString.builder((String)"GetDocumentAnalysisResponse").add("DocumentMetadata", (Object)this.documentMetadata()).add("JobStatus", (Object)this.jobStatusAsString()).add("NextToken", (Object)this.nextToken()).add("Blocks", this.blocks()).add("Warnings", this.warnings()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentMetadata": {
                return Optional.ofNullable(clazz.cast(this.documentMetadata()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Blocks": {
                return Optional.ofNullable(clazz.cast(this.blocks()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentAnalysisResponse, T> g) {
        return obj -> g.apply((GetDocumentAnalysisResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractResponse.BuilderImpl
    implements Builder {
        private DocumentMetadata documentMetadata;
        private String jobStatus;
        private String nextToken;
        private List<Block> blocks = DefaultSdkAutoConstructList.getInstance();
        private List<Warning> warnings = DefaultSdkAutoConstructList.getInstance();
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentAnalysisResponse model) {
            super(model);
            this.documentMetadata(model.documentMetadata);
            this.jobStatus(model.jobStatus);
            this.nextToken(model.nextToken);
            this.blocks(model.blocks);
            this.warnings(model.warnings);
            this.statusMessage(model.statusMessage);
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return this.documentMetadata != null ? this.documentMetadata.toBuilder() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        public final String getJobStatusAsString() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Block.Builder> getBlocks() {
            return this.blocks != null ? (Collection)this.blocks.stream().map(Block::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blocks(Collection<Block> blocks) {
            this.blocks = BlockListCopier.copy(blocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Block ... blocks) {
            this.blocks(Arrays.asList(blocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Consumer<Block.Builder> ... blocks) {
            this.blocks(Stream.of(blocks).map(c -> (Block)((Block.Builder)Block.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlocks(Collection<Block.BuilderImpl> blocks) {
            this.blocks = BlockListCopier.copyFromBuilder(blocks);
        }

        public final Collection<Warning.Builder> getWarnings() {
            return this.warnings != null ? (Collection)this.warnings.stream().map(Warning::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder warnings(Collection<Warning> warnings) {
            this.warnings = WarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Warning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<Warning.Builder> ... warnings) {
            this.warnings(Stream.of(warnings).map(c -> (Warning)((Warning.Builder)Warning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWarnings(Collection<Warning.BuilderImpl> warnings) {
            this.warnings = WarningsCopier.copyFromBuilder(warnings);
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public GetDocumentAnalysisResponse build() {
            return new GetDocumentAnalysisResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TextractResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDocumentAnalysisResponse> {
        public Builder documentMetadata(DocumentMetadata var1);

        default public Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return this.documentMetadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(documentMetadata)).build());
        }

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder nextToken(String var1);

        public Builder blocks(Collection<Block> var1);

        public Builder blocks(Block ... var1);

        public Builder blocks(Consumer<Block.Builder> ... var1);

        public Builder warnings(Collection<Warning> var1);

        public Builder warnings(Warning ... var1);

        public Builder warnings(Consumer<Warning.Builder> ... var1);

        public Builder statusMessage(String var1);
    }
}

