/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.AdapterPagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Adapter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Adapter> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterId").getter(Adapter.getter(Adapter::adapterId)).setter(Adapter.setter(Builder::adapterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()}).build();
    private static final SdkField<List<String>> PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Pages").getter(Adapter.getter(Adapter::pages)).setter(Adapter.setter(Builder::pages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(Adapter.getter(Adapter::version)).setter(Adapter.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD, PAGES_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Adapter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String adapterId;
    private final List<String> pages;
    private final String version;

    private Adapter(BuilderImpl builder) {
        this.adapterId = builder.adapterId;
        this.pages = builder.pages;
        this.version = builder.version;
    }

    public final String adapterId() {
        return this.adapterId;
    }

    public final boolean hasPages() {
        return this.pages != null && !(this.pages instanceof SdkAutoConstructList);
    }

    public final List<String> pages() {
        return this.pages;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPages() ? this.pages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Adapter)) {
            return false;
        }
        Adapter other = (Adapter)obj;
        return Objects.equals(this.adapterId(), other.adapterId()) && this.hasPages() == other.hasPages() && Objects.equals(this.pages(), other.pages()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"Adapter").add("AdapterId", (Object)this.adapterId()).add("Pages", this.hasPages() ? this.pages() : null).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdapterId": {
                return Optional.ofNullable(clazz.cast(this.adapterId()));
            }
            case "Pages": {
                return Optional.ofNullable(clazz.cast(this.pages()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AdapterId", ADAPTER_ID_FIELD);
        map.put("Pages", PAGES_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Adapter, T> g) {
        return obj -> g.apply((Adapter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adapterId;
        private List<String> pages = DefaultSdkAutoConstructList.getInstance();
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(Adapter model) {
            this.adapterId(model.adapterId);
            this.pages(model.pages);
            this.version(model.version);
        }

        public final String getAdapterId() {
            return this.adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final Collection<String> getPages() {
            if (this.pages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pages;
        }

        public final void setPages(Collection<String> pages) {
            this.pages = AdapterPagesCopier.copy(pages);
        }

        @Override
        public final Builder pages(Collection<String> pages) {
            this.pages = AdapterPagesCopier.copy(pages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pages(String ... pages) {
            this.pages(Arrays.asList(pages));
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public Adapter build() {
            return new Adapter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Adapter> {
        public Builder adapterId(String var1);

        public Builder pages(Collection<String> var1);

        public Builder pages(String ... var1);

        public Builder version(String var1);
    }
}

