/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The class assigned to a Page object detected in an input document. Contains information regarding the predicted
 * type/class of a document's page and the page number that the Page object was detected on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PageClassification implements SdkPojo, Serializable,
        ToCopyableBuilder<PageClassification.Builder, PageClassification> {
    private static final SdkField<List<Prediction>> PAGE_TYPE_FIELD = SdkField
            .<List<Prediction>> builder(MarshallingType.LIST)
            .memberName("PageType")
            .getter(getter(PageClassification::pageType))
            .setter(setter(Builder::pageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Prediction> builder(MarshallingType.SDK_POJO)
                                            .constructor(Prediction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Prediction>> PAGE_NUMBER_FIELD = SdkField
            .<List<Prediction>> builder(MarshallingType.LIST)
            .memberName("PageNumber")
            .getter(getter(PageClassification::pageNumber))
            .setter(setter(Builder::pageNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Prediction> builder(MarshallingType.SDK_POJO)
                                            .constructor(Prediction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_TYPE_FIELD,
            PAGE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Prediction> pageType;

    private final List<Prediction> pageNumber;

    private PageClassification(BuilderImpl builder) {
        this.pageType = builder.pageType;
        this.pageNumber = builder.pageNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the PageType property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPageType() {
        return pageType != null && !(pageType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The class, or document type, assigned to a detected Page object. The class, or document type, assigned to a
     * detected Page object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPageType} method.
     * </p>
     * 
     * @return The class, or document type, assigned to a detected Page object. The class, or document type, assigned to
     *         a detected Page object.
     */
    public final List<Prediction> pageType() {
        return pageType;
    }

    /**
     * For responses, this returns true if the service returned a value for the PageNumber property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPageNumber() {
        return pageNumber != null && !(pageNumber instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The page number the value was detected on, relative to Amazon Textract's starting position.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPageNumber} method.
     * </p>
     * 
     * @return The page number the value was detected on, relative to Amazon Textract's starting position.
     */
    public final List<Prediction> pageNumber() {
        return pageNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPageType() ? pageType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPageNumber() ? pageNumber() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PageClassification)) {
            return false;
        }
        PageClassification other = (PageClassification) obj;
        return hasPageType() == other.hasPageType() && Objects.equals(pageType(), other.pageType())
                && hasPageNumber() == other.hasPageNumber() && Objects.equals(pageNumber(), other.pageNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PageClassification").add("PageType", hasPageType() ? pageType() : null)
                .add("PageNumber", hasPageNumber() ? pageNumber() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PageType":
            return Optional.ofNullable(clazz.cast(pageType()));
        case "PageNumber":
            return Optional.ofNullable(clazz.cast(pageNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PageType", PAGE_TYPE_FIELD);
        map.put("PageNumber", PAGE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PageClassification, T> g) {
        return obj -> g.apply((PageClassification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PageClassification> {
        /**
         * <p>
         * The class, or document type, assigned to a detected Page object. The class, or document type, assigned to a
         * detected Page object.
         * </p>
         * 
         * @param pageType
         *        The class, or document type, assigned to a detected Page object. The class, or document type, assigned
         *        to a detected Page object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageType(Collection<Prediction> pageType);

        /**
         * <p>
         * The class, or document type, assigned to a detected Page object. The class, or document type, assigned to a
         * detected Page object.
         * </p>
         * 
         * @param pageType
         *        The class, or document type, assigned to a detected Page object. The class, or document type, assigned
         *        to a detected Page object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageType(Prediction... pageType);

        /**
         * <p>
         * The class, or document type, assigned to a detected Page object. The class, or document type, assigned to a
         * detected Page object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.Prediction.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.textract.model.Prediction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.Prediction.Builder#build()} is called immediately and
         * its result is passed to {@link #pageType(List<Prediction>)}.
         * 
         * @param pageType
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.Prediction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pageType(java.util.Collection<Prediction>)
         */
        Builder pageType(Consumer<Prediction.Builder>... pageType);

        /**
         * <p>
         * The page number the value was detected on, relative to Amazon Textract's starting position.
         * </p>
         * 
         * @param pageNumber
         *        The page number the value was detected on, relative to Amazon Textract's starting position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageNumber(Collection<Prediction> pageNumber);

        /**
         * <p>
         * The page number the value was detected on, relative to Amazon Textract's starting position.
         * </p>
         * 
         * @param pageNumber
         *        The page number the value was detected on, relative to Amazon Textract's starting position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageNumber(Prediction... pageNumber);

        /**
         * <p>
         * The page number the value was detected on, relative to Amazon Textract's starting position.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.Prediction.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.textract.model.Prediction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.Prediction.Builder#build()} is called immediately and
         * its result is passed to {@link #pageNumber(List<Prediction>)}.
         * 
         * @param pageNumber
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.Prediction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pageNumber(java.util.Collection<Prediction>)
         */
        Builder pageNumber(Consumer<Prediction.Builder>... pageNumber);
    }

    static final class BuilderImpl implements Builder {
        private List<Prediction> pageType = DefaultSdkAutoConstructList.getInstance();

        private List<Prediction> pageNumber = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PageClassification model) {
            pageType(model.pageType);
            pageNumber(model.pageNumber);
        }

        public final List<Prediction.Builder> getPageType() {
            List<Prediction.Builder> result = PredictionListCopier.copyToBuilder(this.pageType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPageType(Collection<Prediction.BuilderImpl> pageType) {
            this.pageType = PredictionListCopier.copyFromBuilder(pageType);
        }

        @Override
        public final Builder pageType(Collection<Prediction> pageType) {
            this.pageType = PredictionListCopier.copy(pageType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageType(Prediction... pageType) {
            pageType(Arrays.asList(pageType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageType(Consumer<Prediction.Builder>... pageType) {
            pageType(Stream.of(pageType).map(c -> Prediction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Prediction.Builder> getPageNumber() {
            List<Prediction.Builder> result = PredictionListCopier.copyToBuilder(this.pageNumber);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPageNumber(Collection<Prediction.BuilderImpl> pageNumber) {
            this.pageNumber = PredictionListCopier.copyFromBuilder(pageNumber);
        }

        @Override
        public final Builder pageNumber(Collection<Prediction> pageNumber) {
            this.pageNumber = PredictionListCopier.copy(pageNumber);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageNumber(Prediction... pageNumber) {
            pageNumber(Arrays.asList(pageNumber));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageNumber(Consumer<Prediction.Builder>... pageNumber) {
            pageNumber(Stream.of(pageNumber).map(c -> Prediction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PageClassification build() {
            return new PageClassification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
