/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAdapterVersionResponse extends TextractResponse implements
        ToCopyableBuilder<GetAdapterVersionResponse.Builder, GetAdapterVersionResponse> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdapterId").getter(getter(GetAdapterVersionResponse::adapterId)).setter(setter(Builder::adapterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()).build();

    private static final SdkField<String> ADAPTER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdapterVersion").getter(getter(GetAdapterVersionResponse::adapterVersion))
            .setter(setter(Builder::adapterVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterVersion").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(GetAdapterVersionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FeatureTypes")
            .getter(getter(GetAdapterVersionResponse::featureTypesAsStrings))
            .setter(setter(Builder::featureTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetAdapterVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetAdapterVersionResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<AdapterVersionDatasetConfig> DATASET_CONFIG_FIELD = SdkField
            .<AdapterVersionDatasetConfig> builder(MarshallingType.SDK_POJO).memberName("DatasetConfig")
            .getter(getter(GetAdapterVersionResponse::datasetConfig)).setter(setter(Builder::datasetConfig))
            .constructor(AdapterVersionDatasetConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyId").getter(getter(GetAdapterVersionResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()).build();

    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.<OutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OutputConfig").getter(getter(GetAdapterVersionResponse::outputConfig))
            .setter(setter(Builder::outputConfig)).constructor(OutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<List<AdapterVersionEvaluationMetric>> EVALUATION_METRICS_FIELD = SdkField
            .<List<AdapterVersionEvaluationMetric>> builder(MarshallingType.LIST)
            .memberName("EvaluationMetrics")
            .getter(getter(GetAdapterVersionResponse::evaluationMetrics))
            .setter(setter(Builder::evaluationMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdapterVersionEvaluationMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdapterVersionEvaluationMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetAdapterVersionResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD,
            ADAPTER_VERSION_FIELD, CREATION_TIME_FIELD, FEATURE_TYPES_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD,
            DATASET_CONFIG_FIELD, KMS_KEY_ID_FIELD, OUTPUT_CONFIG_FIELD, EVALUATION_METRICS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String adapterId;

    private final String adapterVersion;

    private final Instant creationTime;

    private final List<String> featureTypes;

    private final String status;

    private final String statusMessage;

    private final AdapterVersionDatasetConfig datasetConfig;

    private final String kmsKeyId;

    private final OutputConfig outputConfig;

    private final List<AdapterVersionEvaluationMetric> evaluationMetrics;

    private final Map<String, String> tags;

    private GetAdapterVersionResponse(BuilderImpl builder) {
        super(builder);
        this.adapterId = builder.adapterId;
        this.adapterVersion = builder.adapterVersion;
        this.creationTime = builder.creationTime;
        this.featureTypes = builder.featureTypes;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.datasetConfig = builder.datasetConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.outputConfig = builder.outputConfig;
        this.evaluationMetrics = builder.evaluationMetrics;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A string containing a unique ID for the adapter version being retrieved.
     * </p>
     * 
     * @return A string containing a unique ID for the adapter version being retrieved.
     */
    public final String adapterId() {
        return adapterId;
    }

    /**
     * <p>
     * A string containing the adapter version that has been retrieved.
     * </p>
     * 
     * @return A string containing the adapter version that has been retrieved.
     */
    public final String adapterVersion() {
        return adapterVersion;
    }

    /**
     * <p>
     * The time that the adapter version was created.
     * </p>
     * 
     * @return The time that the adapter version was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * List of the targeted feature types for the requested adapter version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureTypes} method.
     * </p>
     * 
     * @return List of the targeted feature types for the requested adapter version.
     */
    public final List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(featureTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FeatureTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFeatureTypes() {
        return featureTypes != null && !(featureTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the targeted feature types for the requested adapter version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureTypes} method.
     * </p>
     * 
     * @return List of the targeted feature types for the requested adapter version.
     */
    public final List<String> featureTypesAsStrings() {
        return featureTypes;
    }

    /**
     * <p>
     * The status of the adapter version that has been requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AdapterVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the adapter version that has been requested.
     * @see AdapterVersionStatus
     */
    public final AdapterVersionStatus status() {
        return AdapterVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the adapter version that has been requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AdapterVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the adapter version that has been requested.
     * @see AdapterVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message that describes the status of the requested adapter version.
     * </p>
     * 
     * @return A message that describes the status of the requested adapter version.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Specifies a dataset used to train a new adapter version. Takes a ManifestS3Objec as the value.
     * </p>
     * 
     * @return Specifies a dataset used to train a new adapter version. Takes a ManifestS3Objec as the value.
     */
    public final AdapterVersionDatasetConfig datasetConfig() {
        return datasetConfig;
    }

    /**
     * <p>
     * The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt your documents.
     * </p>
     * 
     * @return The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt your documents.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * Returns the value of the OutputConfig property for this object.
     * 
     * @return The value of the OutputConfig property for this object.
     */
    public final OutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvaluationMetrics property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEvaluationMetrics() {
        return evaluationMetrics != null && !(evaluationMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The evaluation metrics (F1 score, Precision, and Recall) for the requested version, grouped by baseline metrics
     * and adapter version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluationMetrics} method.
     * </p>
     * 
     * @return The evaluation metrics (F1 score, Precision, and Recall) for the requested version, grouped by baseline
     *         metrics and adapter version.
     */
    public final List<AdapterVersionEvaluationMetric> evaluationMetrics() {
        return evaluationMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of tags (key-value pairs) that are associated with the adapter version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of tags (key-value pairs) that are associated with the adapter version.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(adapterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatureTypes() ? featureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(datasetConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluationMetrics() ? evaluationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAdapterVersionResponse)) {
            return false;
        }
        GetAdapterVersionResponse other = (GetAdapterVersionResponse) obj;
        return Objects.equals(adapterId(), other.adapterId()) && Objects.equals(adapterVersion(), other.adapterVersion())
                && Objects.equals(creationTime(), other.creationTime()) && hasFeatureTypes() == other.hasFeatureTypes()
                && Objects.equals(featureTypesAsStrings(), other.featureTypesAsStrings())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(datasetConfig(), other.datasetConfig()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(outputConfig(), other.outputConfig()) && hasEvaluationMetrics() == other.hasEvaluationMetrics()
                && Objects.equals(evaluationMetrics(), other.evaluationMetrics()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAdapterVersionResponse").add("AdapterId", adapterId())
                .add("AdapterVersion", adapterVersion()).add("CreationTime", creationTime())
                .add("FeatureTypes", hasFeatureTypes() ? featureTypesAsStrings() : null).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("DatasetConfig", datasetConfig()).add("KMSKeyId", kmsKeyId())
                .add("OutputConfig", outputConfig())
                .add("EvaluationMetrics", hasEvaluationMetrics() ? evaluationMetrics() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdapterId":
            return Optional.ofNullable(clazz.cast(adapterId()));
        case "AdapterVersion":
            return Optional.ofNullable(clazz.cast(adapterVersion()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FeatureTypes":
            return Optional.ofNullable(clazz.cast(featureTypesAsStrings()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "DatasetConfig":
            return Optional.ofNullable(clazz.cast(datasetConfig()));
        case "KMSKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "EvaluationMetrics":
            return Optional.ofNullable(clazz.cast(evaluationMetrics()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdapterId", ADAPTER_ID_FIELD);
        map.put("AdapterVersion", ADAPTER_VERSION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FeatureTypes", FEATURE_TYPES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("DatasetConfig", DATASET_CONFIG_FIELD);
        map.put("KMSKeyId", KMS_KEY_ID_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("EvaluationMetrics", EVALUATION_METRICS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAdapterVersionResponse, T> g) {
        return obj -> g.apply((GetAdapterVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TextractResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAdapterVersionResponse> {
        /**
         * <p>
         * A string containing a unique ID for the adapter version being retrieved.
         * </p>
         * 
         * @param adapterId
         *        A string containing a unique ID for the adapter version being retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterId(String adapterId);

        /**
         * <p>
         * A string containing the adapter version that has been retrieved.
         * </p>
         * 
         * @param adapterVersion
         *        A string containing the adapter version that has been retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterVersion(String adapterVersion);

        /**
         * <p>
         * The time that the adapter version was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the adapter version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * List of the targeted feature types for the requested adapter version.
         * </p>
         * 
         * @param featureTypes
         *        List of the targeted feature types for the requested adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypesWithStrings(Collection<String> featureTypes);

        /**
         * <p>
         * List of the targeted feature types for the requested adapter version.
         * </p>
         * 
         * @param featureTypes
         *        List of the targeted feature types for the requested adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypesWithStrings(String... featureTypes);

        /**
         * <p>
         * List of the targeted feature types for the requested adapter version.
         * </p>
         * 
         * @param featureTypes
         *        List of the targeted feature types for the requested adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypes(Collection<FeatureType> featureTypes);

        /**
         * <p>
         * List of the targeted feature types for the requested adapter version.
         * </p>
         * 
         * @param featureTypes
         *        List of the targeted feature types for the requested adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypes(FeatureType... featureTypes);

        /**
         * <p>
         * The status of the adapter version that has been requested.
         * </p>
         * 
         * @param status
         *        The status of the adapter version that has been requested.
         * @see AdapterVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdapterVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the adapter version that has been requested.
         * </p>
         * 
         * @param status
         *        The status of the adapter version that has been requested.
         * @see AdapterVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdapterVersionStatus
         */
        Builder status(AdapterVersionStatus status);

        /**
         * <p>
         * A message that describes the status of the requested adapter version.
         * </p>
         * 
         * @param statusMessage
         *        A message that describes the status of the requested adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Specifies a dataset used to train a new adapter version. Takes a ManifestS3Objec as the value.
         * </p>
         * 
         * @param datasetConfig
         *        Specifies a dataset used to train a new adapter version. Takes a ManifestS3Objec as the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetConfig(AdapterVersionDatasetConfig datasetConfig);

        /**
         * <p>
         * Specifies a dataset used to train a new adapter version. Takes a ManifestS3Objec as the value.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdapterVersionDatasetConfig.Builder}
         * avoiding the need to create one manually via {@link AdapterVersionDatasetConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdapterVersionDatasetConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #datasetConfig(AdapterVersionDatasetConfig)}.
         * 
         * @param datasetConfig
         *        a consumer that will call methods on {@link AdapterVersionDatasetConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetConfig(AdapterVersionDatasetConfig)
         */
        default Builder datasetConfig(Consumer<AdapterVersionDatasetConfig.Builder> datasetConfig) {
            return datasetConfig(AdapterVersionDatasetConfig.builder().applyMutation(datasetConfig).build());
        }

        /**
         * <p>
         * The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt your documents.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt your documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * Sets the value of the OutputConfig property for this object.
         *
         * @param outputConfig
         *        The new value for the OutputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfig outputConfig);

        /**
         * Sets the value of the OutputConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OutputConfig.Builder} avoiding the need
         * to create one manually via {@link OutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfig)
         */
        default Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return outputConfig(OutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The evaluation metrics (F1 score, Precision, and Recall) for the requested version, grouped by baseline
         * metrics and adapter version.
         * </p>
         * 
         * @param evaluationMetrics
         *        The evaluation metrics (F1 score, Precision, and Recall) for the requested version, grouped by
         *        baseline metrics and adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationMetrics(Collection<AdapterVersionEvaluationMetric> evaluationMetrics);

        /**
         * <p>
         * The evaluation metrics (F1 score, Precision, and Recall) for the requested version, grouped by baseline
         * metrics and adapter version.
         * </p>
         * 
         * @param evaluationMetrics
         *        The evaluation metrics (F1 score, Precision, and Recall) for the requested version, grouped by
         *        baseline metrics and adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationMetrics(AdapterVersionEvaluationMetric... evaluationMetrics);

        /**
         * <p>
         * The evaluation metrics (F1 score, Precision, and Recall) for the requested version, grouped by baseline
         * metrics and adapter version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.AdapterVersionEvaluationMetric.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.textract.model.AdapterVersionEvaluationMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.AdapterVersionEvaluationMetric.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #evaluationMetrics(List<AdapterVersionEvaluationMetric>)}.
         * 
         * @param evaluationMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.AdapterVersionEvaluationMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationMetrics(java.util.Collection<AdapterVersionEvaluationMetric>)
         */
        Builder evaluationMetrics(Consumer<AdapterVersionEvaluationMetric.Builder>... evaluationMetrics);

        /**
         * <p>
         * A set of tags (key-value pairs) that are associated with the adapter version.
         * </p>
         * 
         * @param tags
         *        A set of tags (key-value pairs) that are associated with the adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends TextractResponse.BuilderImpl implements Builder {
        private String adapterId;

        private String adapterVersion;

        private Instant creationTime;

        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String statusMessage;

        private AdapterVersionDatasetConfig datasetConfig;

        private String kmsKeyId;

        private OutputConfig outputConfig;

        private List<AdapterVersionEvaluationMetric> evaluationMetrics = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAdapterVersionResponse model) {
            super(model);
            adapterId(model.adapterId);
            adapterVersion(model.adapterVersion);
            creationTime(model.creationTime);
            featureTypesWithStrings(model.featureTypes);
            status(model.status);
            statusMessage(model.statusMessage);
            datasetConfig(model.datasetConfig);
            kmsKeyId(model.kmsKeyId);
            outputConfig(model.outputConfig);
            evaluationMetrics(model.evaluationMetrics);
            tags(model.tags);
        }

        public final String getAdapterId() {
            return adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final String getAdapterVersion() {
            return adapterVersion;
        }

        public final void setAdapterVersion(String adapterVersion) {
            this.adapterVersion = adapterVersion;
        }

        @Override
        public final Builder adapterVersion(String adapterVersion) {
            this.adapterVersion = adapterVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String... featureTypes) {
            featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType... featureTypes) {
            featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AdapterVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final AdapterVersionDatasetConfig.Builder getDatasetConfig() {
            return datasetConfig != null ? datasetConfig.toBuilder() : null;
        }

        public final void setDatasetConfig(AdapterVersionDatasetConfig.BuilderImpl datasetConfig) {
            this.datasetConfig = datasetConfig != null ? datasetConfig.build() : null;
        }

        @Override
        public final Builder datasetConfig(AdapterVersionDatasetConfig datasetConfig) {
            this.datasetConfig = datasetConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final List<AdapterVersionEvaluationMetric.Builder> getEvaluationMetrics() {
            List<AdapterVersionEvaluationMetric.Builder> result = AdapterVersionEvaluationMetricsCopier
                    .copyToBuilder(this.evaluationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationMetrics(Collection<AdapterVersionEvaluationMetric.BuilderImpl> evaluationMetrics) {
            this.evaluationMetrics = AdapterVersionEvaluationMetricsCopier.copyFromBuilder(evaluationMetrics);
        }

        @Override
        public final Builder evaluationMetrics(Collection<AdapterVersionEvaluationMetric> evaluationMetrics) {
            this.evaluationMetrics = AdapterVersionEvaluationMetricsCopier.copy(evaluationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationMetrics(AdapterVersionEvaluationMetric... evaluationMetrics) {
            evaluationMetrics(Arrays.asList(evaluationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationMetrics(Consumer<AdapterVersionEvaluationMetric.Builder>... evaluationMetrics) {
            evaluationMetrics(Stream.of(evaluationMetrics)
                    .map(c -> AdapterVersionEvaluationMetric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetAdapterVersionResponse build() {
            return new GetAdapterVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
