/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.textract.model.TextractRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAdapterVersionsRequest
extends TextractRequest
implements ToCopyableBuilder<Builder, ListAdapterVersionsRequest> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterId").getter(ListAdapterVersionsRequest.getter(ListAdapterVersionsRequest::adapterId)).setter(ListAdapterVersionsRequest.setter(Builder::adapterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()}).build();
    private static final SdkField<Instant> AFTER_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AfterCreationTime").getter(ListAdapterVersionsRequest.getter(ListAdapterVersionsRequest::afterCreationTime)).setter(ListAdapterVersionsRequest.setter(Builder::afterCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterCreationTime").build()}).build();
    private static final SdkField<Instant> BEFORE_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BeforeCreationTime").getter(ListAdapterVersionsRequest.getter(ListAdapterVersionsRequest::beforeCreationTime)).setter(ListAdapterVersionsRequest.setter(Builder::beforeCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeforeCreationTime").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAdapterVersionsRequest.getter(ListAdapterVersionsRequest::maxResults)).setter(ListAdapterVersionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAdapterVersionsRequest.getter(ListAdapterVersionsRequest::nextToken)).setter(ListAdapterVersionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD, AFTER_CREATION_TIME_FIELD, BEFORE_CREATION_TIME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAdapterVersionsRequest.memberNameToFieldInitializer();
    private final String adapterId;
    private final Instant afterCreationTime;
    private final Instant beforeCreationTime;
    private final Integer maxResults;
    private final String nextToken;

    private ListAdapterVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.adapterId = builder.adapterId;
        this.afterCreationTime = builder.afterCreationTime;
        this.beforeCreationTime = builder.beforeCreationTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String adapterId() {
        return this.adapterId;
    }

    public final Instant afterCreationTime() {
        return this.afterCreationTime;
    }

    public final Instant beforeCreationTime() {
        return this.beforeCreationTime;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAdapterVersionsRequest)) {
            return false;
        }
        ListAdapterVersionsRequest other = (ListAdapterVersionsRequest)((Object)obj);
        return Objects.equals(this.adapterId(), other.adapterId()) && Objects.equals(this.afterCreationTime(), other.afterCreationTime()) && Objects.equals(this.beforeCreationTime(), other.beforeCreationTime()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAdapterVersionsRequest").add("AdapterId", (Object)this.adapterId()).add("AfterCreationTime", (Object)this.afterCreationTime()).add("BeforeCreationTime", (Object)this.beforeCreationTime()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdapterId": {
                return Optional.ofNullable(clazz.cast(this.adapterId()));
            }
            case "AfterCreationTime": {
                return Optional.ofNullable(clazz.cast(this.afterCreationTime()));
            }
            case "BeforeCreationTime": {
                return Optional.ofNullable(clazz.cast(this.beforeCreationTime()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AdapterId", ADAPTER_ID_FIELD);
        map.put("AfterCreationTime", AFTER_CREATION_TIME_FIELD);
        map.put("BeforeCreationTime", BEFORE_CREATION_TIME_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAdapterVersionsRequest, T> g) {
        return obj -> g.apply((ListAdapterVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractRequest.BuilderImpl
    implements Builder {
        private String adapterId;
        private Instant afterCreationTime;
        private Instant beforeCreationTime;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAdapterVersionsRequest model) {
            super(model);
            this.adapterId(model.adapterId);
            this.afterCreationTime(model.afterCreationTime);
            this.beforeCreationTime(model.beforeCreationTime);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getAdapterId() {
            return this.adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final Instant getAfterCreationTime() {
            return this.afterCreationTime;
        }

        public final void setAfterCreationTime(Instant afterCreationTime) {
            this.afterCreationTime = afterCreationTime;
        }

        @Override
        public final Builder afterCreationTime(Instant afterCreationTime) {
            this.afterCreationTime = afterCreationTime;
            return this;
        }

        public final Instant getBeforeCreationTime() {
            return this.beforeCreationTime;
        }

        public final void setBeforeCreationTime(Instant beforeCreationTime) {
            this.beforeCreationTime = beforeCreationTime;
        }

        @Override
        public final Builder beforeCreationTime(Instant beforeCreationTime) {
            this.beforeCreationTime = beforeCreationTime;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAdapterVersionsRequest build() {
            return new ListAdapterVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TextractRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAdapterVersionsRequest> {
        public Builder adapterId(String var1);

        public Builder afterCreationTime(Instant var1);

        public Builder beforeCreationTime(Instant var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

