/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.ExpenseField;
import software.amazon.awssdk.services.textract.model.ExpenseFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineItemFields
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineItemFields> {
    private static final SdkField<List<ExpenseField>> LINE_ITEM_EXPENSE_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LineItemExpenseFields").getter(LineItemFields.getter(LineItemFields::lineItemExpenseFields)).setter(LineItemFields.setter(Builder::lineItemExpenseFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemExpenseFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpenseField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_ITEM_EXPENSE_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LineItemFields.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ExpenseField> lineItemExpenseFields;

    private LineItemFields(BuilderImpl builder) {
        this.lineItemExpenseFields = builder.lineItemExpenseFields;
    }

    public final boolean hasLineItemExpenseFields() {
        return this.lineItemExpenseFields != null && !(this.lineItemExpenseFields instanceof SdkAutoConstructList);
    }

    public final List<ExpenseField> lineItemExpenseFields() {
        return this.lineItemExpenseFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineItemExpenseFields() ? this.lineItemExpenseFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItemFields)) {
            return false;
        }
        LineItemFields other = (LineItemFields)obj;
        return this.hasLineItemExpenseFields() == other.hasLineItemExpenseFields() && Objects.equals(this.lineItemExpenseFields(), other.lineItemExpenseFields());
    }

    public final String toString() {
        return ToString.builder((String)"LineItemFields").add("LineItemExpenseFields", this.hasLineItemExpenseFields() ? this.lineItemExpenseFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LineItemExpenseFields": {
                return Optional.ofNullable(clazz.cast(this.lineItemExpenseFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ExpenseField>>> map = new HashMap<String, SdkField<List<ExpenseField>>>();
        map.put("LineItemExpenseFields", LINE_ITEM_EXPENSE_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineItemFields, T> g) {
        return obj -> g.apply((LineItemFields)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ExpenseField> lineItemExpenseFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LineItemFields model) {
            this.lineItemExpenseFields(model.lineItemExpenseFields);
        }

        public final List<ExpenseField.Builder> getLineItemExpenseFields() {
            List<ExpenseField.Builder> result = ExpenseFieldListCopier.copyToBuilder(this.lineItemExpenseFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineItemExpenseFields(Collection<ExpenseField.BuilderImpl> lineItemExpenseFields) {
            this.lineItemExpenseFields = ExpenseFieldListCopier.copyFromBuilder(lineItemExpenseFields);
        }

        @Override
        public final Builder lineItemExpenseFields(Collection<ExpenseField> lineItemExpenseFields) {
            this.lineItemExpenseFields = ExpenseFieldListCopier.copy(lineItemExpenseFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItemExpenseFields(ExpenseField ... lineItemExpenseFields) {
            this.lineItemExpenseFields(Arrays.asList(lineItemExpenseFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItemExpenseFields(Consumer<ExpenseField.Builder> ... lineItemExpenseFields) {
            this.lineItemExpenseFields(Stream.of(lineItemExpenseFields).map(c -> (ExpenseField)((ExpenseField.Builder)ExpenseField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LineItemFields build() {
            return new LineItemFields(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineItemFields> {
        public Builder lineItemExpenseFields(Collection<ExpenseField> var1);

        public Builder lineItemExpenseFields(ExpenseField ... var1);

        public Builder lineItemExpenseFields(Consumer<ExpenseField.Builder> ... var1);
    }
}

