/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.textract.model.AdapterVersionDatasetConfig;
import software.amazon.awssdk.services.textract.model.AdapterVersionEvaluationMetric;
import software.amazon.awssdk.services.textract.model.AdapterVersionEvaluationMetricsCopier;
import software.amazon.awssdk.services.textract.model.AdapterVersionStatus;
import software.amazon.awssdk.services.textract.model.FeatureType;
import software.amazon.awssdk.services.textract.model.FeatureTypesCopier;
import software.amazon.awssdk.services.textract.model.OutputConfig;
import software.amazon.awssdk.services.textract.model.TagMapCopier;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAdapterVersionResponse
extends TextractResponse
implements ToCopyableBuilder<Builder, GetAdapterVersionResponse> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterId").getter(GetAdapterVersionResponse.getter(GetAdapterVersionResponse::adapterId)).setter(GetAdapterVersionResponse.setter(Builder::adapterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()}).build();
    private static final SdkField<String> ADAPTER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterVersion").getter(GetAdapterVersionResponse.getter(GetAdapterVersionResponse::adapterVersion)).setter(GetAdapterVersionResponse.setter(Builder::adapterVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterVersion").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(GetAdapterVersionResponse.getter(GetAdapterVersionResponse::creationTime)).setter(GetAdapterVersionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureTypes").getter(GetAdapterVersionResponse.getter(GetAdapterVersionResponse::featureTypesAsStrings)).setter(GetAdapterVersionResponse.setter(Builder::featureTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetAdapterVersionResponse.getter(GetAdapterVersionResponse::statusAsString)).setter(GetAdapterVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetAdapterVersionResponse.getter(GetAdapterVersionResponse::statusMessage)).setter(GetAdapterVersionResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<AdapterVersionDatasetConfig> DATASET_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatasetConfig").getter(GetAdapterVersionResponse.getter(GetAdapterVersionResponse::datasetConfig)).setter(GetAdapterVersionResponse.setter(Builder::datasetConfig)).constructor(AdapterVersionDatasetConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyId").getter(GetAdapterVersionResponse.getter(GetAdapterVersionResponse::kmsKeyId)).setter(GetAdapterVersionResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(GetAdapterVersionResponse.getter(GetAdapterVersionResponse::outputConfig)).setter(GetAdapterVersionResponse.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<List<AdapterVersionEvaluationMetric>> EVALUATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EvaluationMetrics").getter(GetAdapterVersionResponse.getter(GetAdapterVersionResponse::evaluationMetrics)).setter(GetAdapterVersionResponse.setter(Builder::evaluationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdapterVersionEvaluationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetAdapterVersionResponse.getter(GetAdapterVersionResponse::tags)).setter(GetAdapterVersionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD, ADAPTER_VERSION_FIELD, CREATION_TIME_FIELD, FEATURE_TYPES_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, DATASET_CONFIG_FIELD, KMS_KEY_ID_FIELD, OUTPUT_CONFIG_FIELD, EVALUATION_METRICS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AdapterId", ADAPTER_ID_FIELD);
            this.put("AdapterVersion", ADAPTER_VERSION_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("FeatureTypes", FEATURE_TYPES_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
            this.put("DatasetConfig", DATASET_CONFIG_FIELD);
            this.put("KMSKeyId", KMS_KEY_ID_FIELD);
            this.put("OutputConfig", OUTPUT_CONFIG_FIELD);
            this.put("EvaluationMetrics", EVALUATION_METRICS_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String adapterId;
    private final String adapterVersion;
    private final Instant creationTime;
    private final List<String> featureTypes;
    private final String status;
    private final String statusMessage;
    private final AdapterVersionDatasetConfig datasetConfig;
    private final String kmsKeyId;
    private final OutputConfig outputConfig;
    private final List<AdapterVersionEvaluationMetric> evaluationMetrics;
    private final Map<String, String> tags;

    private GetAdapterVersionResponse(BuilderImpl builder) {
        super(builder);
        this.adapterId = builder.adapterId;
        this.adapterVersion = builder.adapterVersion;
        this.creationTime = builder.creationTime;
        this.featureTypes = builder.featureTypes;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.datasetConfig = builder.datasetConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.outputConfig = builder.outputConfig;
        this.evaluationMetrics = builder.evaluationMetrics;
        this.tags = builder.tags;
    }

    public final String adapterId() {
        return this.adapterId;
    }

    public final String adapterVersion() {
        return this.adapterVersion;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(this.featureTypes);
    }

    public final boolean hasFeatureTypes() {
        return this.featureTypes != null && !(this.featureTypes instanceof SdkAutoConstructList);
    }

    public final List<String> featureTypesAsStrings() {
        return this.featureTypes;
    }

    public final AdapterVersionStatus status() {
        return AdapterVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final AdapterVersionDatasetConfig datasetConfig() {
        return this.datasetConfig;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final boolean hasEvaluationMetrics() {
        return this.evaluationMetrics != null && !(this.evaluationMetrics instanceof SdkAutoConstructList);
    }

    public final List<AdapterVersionEvaluationMetric> evaluationMetrics() {
        return this.evaluationMetrics;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureTypes() ? this.featureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluationMetrics() ? this.evaluationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAdapterVersionResponse)) {
            return false;
        }
        GetAdapterVersionResponse other = (GetAdapterVersionResponse)((Object)obj);
        return Objects.equals(this.adapterId(), other.adapterId()) && Objects.equals(this.adapterVersion(), other.adapterVersion()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasFeatureTypes() == other.hasFeatureTypes() && Objects.equals(this.featureTypesAsStrings(), other.featureTypesAsStrings()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.datasetConfig(), other.datasetConfig()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.outputConfig(), other.outputConfig()) && this.hasEvaluationMetrics() == other.hasEvaluationMetrics() && Objects.equals(this.evaluationMetrics(), other.evaluationMetrics()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetAdapterVersionResponse").add("AdapterId", (Object)this.adapterId()).add("AdapterVersion", (Object)this.adapterVersion()).add("CreationTime", (Object)this.creationTime()).add("FeatureTypes", this.hasFeatureTypes() ? this.featureTypesAsStrings() : null).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("DatasetConfig", (Object)this.datasetConfig()).add("KMSKeyId", (Object)this.kmsKeyId()).add("OutputConfig", (Object)this.outputConfig()).add("EvaluationMetrics", this.hasEvaluationMetrics() ? this.evaluationMetrics() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdapterId": {
                return Optional.ofNullable(clazz.cast(this.adapterId()));
            }
            case "AdapterVersion": {
                return Optional.ofNullable(clazz.cast(this.adapterVersion()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FeatureTypes": {
                return Optional.ofNullable(clazz.cast(this.featureTypesAsStrings()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "DatasetConfig": {
                return Optional.ofNullable(clazz.cast(this.datasetConfig()));
            }
            case "KMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "EvaluationMetrics": {
                return Optional.ofNullable(clazz.cast(this.evaluationMetrics()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAdapterVersionResponse, T> g) {
        return obj -> g.apply((GetAdapterVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractResponse.BuilderImpl
    implements Builder {
        private String adapterId;
        private String adapterVersion;
        private Instant creationTime;
        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusMessage;
        private AdapterVersionDatasetConfig datasetConfig;
        private String kmsKeyId;
        private OutputConfig outputConfig;
        private List<AdapterVersionEvaluationMetric> evaluationMetrics = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAdapterVersionResponse model) {
            super(model);
            this.adapterId(model.adapterId);
            this.adapterVersion(model.adapterVersion);
            this.creationTime(model.creationTime);
            this.featureTypesWithStrings(model.featureTypes);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.datasetConfig(model.datasetConfig);
            this.kmsKeyId(model.kmsKeyId);
            this.outputConfig(model.outputConfig);
            this.evaluationMetrics(model.evaluationMetrics);
            this.tags(model.tags);
        }

        public final String getAdapterId() {
            return this.adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final String getAdapterVersion() {
            return this.adapterVersion;
        }

        public final void setAdapterVersion(String adapterVersion) {
            this.adapterVersion = adapterVersion;
        }

        @Override
        public final Builder adapterVersion(String adapterVersion) {
            this.adapterVersion = adapterVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (this.featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String ... featureTypes) {
            this.featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType ... featureTypes) {
            this.featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AdapterVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final AdapterVersionDatasetConfig.Builder getDatasetConfig() {
            return this.datasetConfig != null ? this.datasetConfig.toBuilder() : null;
        }

        public final void setDatasetConfig(AdapterVersionDatasetConfig.BuilderImpl datasetConfig) {
            this.datasetConfig = datasetConfig != null ? datasetConfig.build() : null;
        }

        @Override
        public final Builder datasetConfig(AdapterVersionDatasetConfig datasetConfig) {
            this.datasetConfig = datasetConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final List<AdapterVersionEvaluationMetric.Builder> getEvaluationMetrics() {
            List<AdapterVersionEvaluationMetric.Builder> result = AdapterVersionEvaluationMetricsCopier.copyToBuilder(this.evaluationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationMetrics(Collection<AdapterVersionEvaluationMetric.BuilderImpl> evaluationMetrics) {
            this.evaluationMetrics = AdapterVersionEvaluationMetricsCopier.copyFromBuilder(evaluationMetrics);
        }

        @Override
        public final Builder evaluationMetrics(Collection<AdapterVersionEvaluationMetric> evaluationMetrics) {
            this.evaluationMetrics = AdapterVersionEvaluationMetricsCopier.copy(evaluationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationMetrics(AdapterVersionEvaluationMetric ... evaluationMetrics) {
            this.evaluationMetrics(Arrays.asList(evaluationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationMetrics(Consumer<AdapterVersionEvaluationMetric.Builder> ... evaluationMetrics) {
            this.evaluationMetrics(Stream.of(evaluationMetrics).map(c -> (AdapterVersionEvaluationMetric)((AdapterVersionEvaluationMetric.Builder)AdapterVersionEvaluationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetAdapterVersionResponse build() {
            return new GetAdapterVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TextractResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAdapterVersionResponse> {
        public Builder adapterId(String var1);

        public Builder adapterVersion(String var1);

        public Builder creationTime(Instant var1);

        public Builder featureTypesWithStrings(Collection<String> var1);

        public Builder featureTypesWithStrings(String ... var1);

        public Builder featureTypes(Collection<FeatureType> var1);

        public Builder featureTypes(FeatureType ... var1);

        public Builder status(String var1);

        public Builder status(AdapterVersionStatus var1);

        public Builder statusMessage(String var1);

        public Builder datasetConfig(AdapterVersionDatasetConfig var1);

        default public Builder datasetConfig(Consumer<AdapterVersionDatasetConfig.Builder> datasetConfig) {
            return this.datasetConfig((AdapterVersionDatasetConfig)((AdapterVersionDatasetConfig.Builder)AdapterVersionDatasetConfig.builder().applyMutation(datasetConfig)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder evaluationMetrics(Collection<AdapterVersionEvaluationMetric> var1);

        public Builder evaluationMetrics(AdapterVersionEvaluationMetric ... var1);

        public Builder evaluationMetrics(Consumer<AdapterVersionEvaluationMetric.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

