/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.textract.model.EvaluationMetric;
import software.amazon.awssdk.services.textract.model.FeatureType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdapterVersionEvaluationMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdapterVersionEvaluationMetric> {
    private static final SdkField<EvaluationMetric> BASELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Baseline").getter(AdapterVersionEvaluationMetric.getter(AdapterVersionEvaluationMetric::baseline)).setter(AdapterVersionEvaluationMetric.setter(Builder::baseline)).constructor(EvaluationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Baseline").build()}).build();
    private static final SdkField<EvaluationMetric> ADAPTER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdapterVersion").getter(AdapterVersionEvaluationMetric.getter(AdapterVersionEvaluationMetric::adapterVersion)).setter(AdapterVersionEvaluationMetric.setter(Builder::adapterVersion)).constructor(EvaluationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterVersion").build()}).build();
    private static final SdkField<String> FEATURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureType").getter(AdapterVersionEvaluationMetric.getter(AdapterVersionEvaluationMetric::featureTypeAsString)).setter(AdapterVersionEvaluationMetric.setter(Builder::featureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_FIELD, ADAPTER_VERSION_FIELD, FEATURE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Baseline", BASELINE_FIELD);
            this.put("AdapterVersion", ADAPTER_VERSION_FIELD);
            this.put("FeatureType", FEATURE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final EvaluationMetric baseline;
    private final EvaluationMetric adapterVersion;
    private final String featureType;

    private AdapterVersionEvaluationMetric(BuilderImpl builder) {
        this.baseline = builder.baseline;
        this.adapterVersion = builder.adapterVersion;
        this.featureType = builder.featureType;
    }

    public final EvaluationMetric baseline() {
        return this.baseline;
    }

    public final EvaluationMetric adapterVersion() {
        return this.adapterVersion;
    }

    public final FeatureType featureType() {
        return FeatureType.fromValue(this.featureType);
    }

    public final String featureTypeAsString() {
        return this.featureType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseline());
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdapterVersionEvaluationMetric)) {
            return false;
        }
        AdapterVersionEvaluationMetric other = (AdapterVersionEvaluationMetric)obj;
        return Objects.equals(this.baseline(), other.baseline()) && Objects.equals(this.adapterVersion(), other.adapterVersion()) && Objects.equals(this.featureTypeAsString(), other.featureTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AdapterVersionEvaluationMetric").add("Baseline", (Object)this.baseline()).add("AdapterVersion", (Object)this.adapterVersion()).add("FeatureType", (Object)this.featureTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Baseline": {
                return Optional.ofNullable(clazz.cast(this.baseline()));
            }
            case "AdapterVersion": {
                return Optional.ofNullable(clazz.cast(this.adapterVersion()));
            }
            case "FeatureType": {
                return Optional.ofNullable(clazz.cast(this.featureTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AdapterVersionEvaluationMetric, T> g) {
        return obj -> g.apply((AdapterVersionEvaluationMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EvaluationMetric baseline;
        private EvaluationMetric adapterVersion;
        private String featureType;

        private BuilderImpl() {
        }

        private BuilderImpl(AdapterVersionEvaluationMetric model) {
            this.baseline(model.baseline);
            this.adapterVersion(model.adapterVersion);
            this.featureType(model.featureType);
        }

        public final EvaluationMetric.Builder getBaseline() {
            return this.baseline != null ? this.baseline.toBuilder() : null;
        }

        public final void setBaseline(EvaluationMetric.BuilderImpl baseline) {
            this.baseline = baseline != null ? baseline.build() : null;
        }

        @Override
        public final Builder baseline(EvaluationMetric baseline) {
            this.baseline = baseline;
            return this;
        }

        public final EvaluationMetric.Builder getAdapterVersion() {
            return this.adapterVersion != null ? this.adapterVersion.toBuilder() : null;
        }

        public final void setAdapterVersion(EvaluationMetric.BuilderImpl adapterVersion) {
            this.adapterVersion = adapterVersion != null ? adapterVersion.build() : null;
        }

        @Override
        public final Builder adapterVersion(EvaluationMetric adapterVersion) {
            this.adapterVersion = adapterVersion;
            return this;
        }

        public final String getFeatureType() {
            return this.featureType;
        }

        public final void setFeatureType(String featureType) {
            this.featureType = featureType;
        }

        @Override
        public final Builder featureType(String featureType) {
            this.featureType = featureType;
            return this;
        }

        @Override
        public final Builder featureType(FeatureType featureType) {
            this.featureType(featureType == null ? null : featureType.toString());
            return this;
        }

        public AdapterVersionEvaluationMetric build() {
            return new AdapterVersionEvaluationMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdapterVersionEvaluationMetric> {
        public Builder baseline(EvaluationMetric var1);

        default public Builder baseline(Consumer<EvaluationMetric.Builder> baseline) {
            return this.baseline((EvaluationMetric)((EvaluationMetric.Builder)EvaluationMetric.builder().applyMutation(baseline)).build());
        }

        public Builder adapterVersion(EvaluationMetric var1);

        default public Builder adapterVersion(Consumer<EvaluationMetric.Builder> adapterVersion) {
            return this.adapterVersion((EvaluationMetric)((EvaluationMetric.Builder)EvaluationMetric.builder().applyMutation(adapterVersion)).build());
        }

        public Builder featureType(String var1);

        public Builder featureType(FeatureType var1);
    }
}

