/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AdapterVersionStatus {
    ACTIVE("ACTIVE"),
    AT_RISK("AT_RISK"),
    DEPRECATED("DEPRECATED"),
    CREATION_ERROR("CREATION_ERROR"),
    CREATION_IN_PROGRESS("CREATION_IN_PROGRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AdapterVersionStatus> VALUE_MAP;
    private final String value;

    private AdapterVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AdapterVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AdapterVersionStatus> knownValues() {
        EnumSet<AdapterVersionStatus> knownValues = EnumSet.allOf(AdapterVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AdapterVersionStatus.class, AdapterVersionStatus::toString);
    }
}

