/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.DocumentGroup;
import software.amazon.awssdk.services.textract.model.DocumentGroupListCopier;
import software.amazon.awssdk.services.textract.model.UndetectedDocumentTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LendingSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LendingSummary> {
    private static final SdkField<List<DocumentGroup>> DOCUMENT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentGroups").getter(LendingSummary.getter(LendingSummary::documentGroups)).setter(LendingSummary.setter(Builder::documentGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> UNDETECTED_DOCUMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UndetectedDocumentTypes").getter(LendingSummary.getter(LendingSummary::undetectedDocumentTypes)).setter(LendingSummary.setter(Builder::undetectedDocumentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UndetectedDocumentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_GROUPS_FIELD, UNDETECTED_DOCUMENT_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DocumentGroup> documentGroups;
    private final List<String> undetectedDocumentTypes;

    private LendingSummary(BuilderImpl builder) {
        this.documentGroups = builder.documentGroups;
        this.undetectedDocumentTypes = builder.undetectedDocumentTypes;
    }

    public final boolean hasDocumentGroups() {
        return this.documentGroups != null && !(this.documentGroups instanceof SdkAutoConstructList);
    }

    public final List<DocumentGroup> documentGroups() {
        return this.documentGroups;
    }

    public final boolean hasUndetectedDocumentTypes() {
        return this.undetectedDocumentTypes != null && !(this.undetectedDocumentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> undetectedDocumentTypes() {
        return this.undetectedDocumentTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentGroups() ? this.documentGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUndetectedDocumentTypes() ? this.undetectedDocumentTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingSummary)) {
            return false;
        }
        LendingSummary other = (LendingSummary)obj;
        return this.hasDocumentGroups() == other.hasDocumentGroups() && Objects.equals(this.documentGroups(), other.documentGroups()) && this.hasUndetectedDocumentTypes() == other.hasUndetectedDocumentTypes() && Objects.equals(this.undetectedDocumentTypes(), other.undetectedDocumentTypes());
    }

    public final String toString() {
        return ToString.builder((String)"LendingSummary").add("DocumentGroups", this.hasDocumentGroups() ? this.documentGroups() : null).add("UndetectedDocumentTypes", this.hasUndetectedDocumentTypes() ? this.undetectedDocumentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentGroups": {
                return Optional.ofNullable(clazz.cast(this.documentGroups()));
            }
            case "UndetectedDocumentTypes": {
                return Optional.ofNullable(clazz.cast(this.undetectedDocumentTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LendingSummary, T> g) {
        return obj -> g.apply((LendingSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DocumentGroup> documentGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> undetectedDocumentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LendingSummary model) {
            this.documentGroups(model.documentGroups);
            this.undetectedDocumentTypes(model.undetectedDocumentTypes);
        }

        public final List<DocumentGroup.Builder> getDocumentGroups() {
            List<DocumentGroup.Builder> result = DocumentGroupListCopier.copyToBuilder(this.documentGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentGroups(Collection<DocumentGroup.BuilderImpl> documentGroups) {
            this.documentGroups = DocumentGroupListCopier.copyFromBuilder(documentGroups);
        }

        @Override
        public final Builder documentGroups(Collection<DocumentGroup> documentGroups) {
            this.documentGroups = DocumentGroupListCopier.copy(documentGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentGroups(DocumentGroup ... documentGroups) {
            this.documentGroups(Arrays.asList(documentGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentGroups(Consumer<DocumentGroup.Builder> ... documentGroups) {
            this.documentGroups(Stream.of(documentGroups).map(c -> (DocumentGroup)((DocumentGroup.Builder)DocumentGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getUndetectedDocumentTypes() {
            if (this.undetectedDocumentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.undetectedDocumentTypes;
        }

        public final void setUndetectedDocumentTypes(Collection<String> undetectedDocumentTypes) {
            this.undetectedDocumentTypes = UndetectedDocumentTypeListCopier.copy(undetectedDocumentTypes);
        }

        @Override
        public final Builder undetectedDocumentTypes(Collection<String> undetectedDocumentTypes) {
            this.undetectedDocumentTypes = UndetectedDocumentTypeListCopier.copy(undetectedDocumentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder undetectedDocumentTypes(String ... undetectedDocumentTypes) {
            this.undetectedDocumentTypes(Arrays.asList(undetectedDocumentTypes));
            return this;
        }

        public LendingSummary build() {
            return new LendingSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LendingSummary> {
        public Builder documentGroups(Collection<DocumentGroup> var1);

        public Builder documentGroups(DocumentGroup ... var1);

        public Builder documentGroups(Consumer<DocumentGroup.Builder> ... var1);

        public Builder undetectedDocumentTypes(Collection<String> var1);

        public Builder undetectedDocumentTypes(String ... var1);
    }
}

