/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.DocumentMetadata;
import software.amazon.awssdk.services.textract.model.ExpenseDocument;
import software.amazon.awssdk.services.textract.model.ExpenseDocumentListCopier;
import software.amazon.awssdk.services.textract.model.JobStatus;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.services.textract.model.Warning;
import software.amazon.awssdk.services.textract.model.WarningsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExpenseAnalysisResponse
extends TextractResponse
implements ToCopyableBuilder<Builder, GetExpenseAnalysisResponse> {
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentMetadata").getter(GetExpenseAnalysisResponse.getter(GetExpenseAnalysisResponse::documentMetadata)).setter(GetExpenseAnalysisResponse.setter(Builder::documentMetadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(GetExpenseAnalysisResponse.getter(GetExpenseAnalysisResponse::jobStatusAsString)).setter(GetExpenseAnalysisResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetExpenseAnalysisResponse.getter(GetExpenseAnalysisResponse::nextToken)).setter(GetExpenseAnalysisResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ExpenseDocument>> EXPENSE_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExpenseDocuments").getter(GetExpenseAnalysisResponse.getter(GetExpenseAnalysisResponse::expenseDocuments)).setter(GetExpenseAnalysisResponse.setter(Builder::expenseDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpenseDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpenseDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Warning>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Warnings").getter(GetExpenseAnalysisResponse.getter(GetExpenseAnalysisResponse::warnings)).setter(GetExpenseAnalysisResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Warning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetExpenseAnalysisResponse.getter(GetExpenseAnalysisResponse::statusMessage)).setter(GetExpenseAnalysisResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> ANALYZE_EXPENSE_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalyzeExpenseModelVersion").getter(GetExpenseAnalysisResponse.getter(GetExpenseAnalysisResponse::analyzeExpenseModelVersion)).setter(GetExpenseAnalysisResponse.setter(Builder::analyzeExpenseModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzeExpenseModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_METADATA_FIELD, JOB_STATUS_FIELD, NEXT_TOKEN_FIELD, EXPENSE_DOCUMENTS_FIELD, WARNINGS_FIELD, STATUS_MESSAGE_FIELD, ANALYZE_EXPENSE_MODEL_VERSION_FIELD));
    private final DocumentMetadata documentMetadata;
    private final String jobStatus;
    private final String nextToken;
    private final List<ExpenseDocument> expenseDocuments;
    private final List<Warning> warnings;
    private final String statusMessage;
    private final String analyzeExpenseModelVersion;

    private GetExpenseAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.documentMetadata = builder.documentMetadata;
        this.jobStatus = builder.jobStatus;
        this.nextToken = builder.nextToken;
        this.expenseDocuments = builder.expenseDocuments;
        this.warnings = builder.warnings;
        this.statusMessage = builder.statusMessage;
        this.analyzeExpenseModelVersion = builder.analyzeExpenseModelVersion;
    }

    public final DocumentMetadata documentMetadata() {
        return this.documentMetadata;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasExpenseDocuments() {
        return this.expenseDocuments != null && !(this.expenseDocuments instanceof SdkAutoConstructList);
    }

    public final List<ExpenseDocument> expenseDocuments() {
        return this.expenseDocuments;
    }

    public final boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public final List<Warning> warnings() {
        return this.warnings;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String analyzeExpenseModelVersion() {
        return this.analyzeExpenseModelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpenseDocuments() ? this.expenseDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzeExpenseModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExpenseAnalysisResponse)) {
            return false;
        }
        GetExpenseAnalysisResponse other = (GetExpenseAnalysisResponse)((Object)obj);
        return Objects.equals(this.documentMetadata(), other.documentMetadata()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasExpenseDocuments() == other.hasExpenseDocuments() && Objects.equals(this.expenseDocuments(), other.expenseDocuments()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.analyzeExpenseModelVersion(), other.analyzeExpenseModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetExpenseAnalysisResponse").add("DocumentMetadata", (Object)this.documentMetadata()).add("JobStatus", (Object)this.jobStatusAsString()).add("NextToken", (Object)this.nextToken()).add("ExpenseDocuments", this.hasExpenseDocuments() ? this.expenseDocuments() : null).add("Warnings", this.hasWarnings() ? this.warnings() : null).add("StatusMessage", (Object)this.statusMessage()).add("AnalyzeExpenseModelVersion", (Object)this.analyzeExpenseModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentMetadata": {
                return Optional.ofNullable(clazz.cast(this.documentMetadata()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ExpenseDocuments": {
                return Optional.ofNullable(clazz.cast(this.expenseDocuments()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "AnalyzeExpenseModelVersion": {
                return Optional.ofNullable(clazz.cast(this.analyzeExpenseModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExpenseAnalysisResponse, T> g) {
        return obj -> g.apply((GetExpenseAnalysisResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractResponse.BuilderImpl
    implements Builder {
        private DocumentMetadata documentMetadata;
        private String jobStatus;
        private String nextToken;
        private List<ExpenseDocument> expenseDocuments = DefaultSdkAutoConstructList.getInstance();
        private List<Warning> warnings = DefaultSdkAutoConstructList.getInstance();
        private String statusMessage;
        private String analyzeExpenseModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExpenseAnalysisResponse model) {
            super(model);
            this.documentMetadata(model.documentMetadata);
            this.jobStatus(model.jobStatus);
            this.nextToken(model.nextToken);
            this.expenseDocuments(model.expenseDocuments);
            this.warnings(model.warnings);
            this.statusMessage(model.statusMessage);
            this.analyzeExpenseModelVersion(model.analyzeExpenseModelVersion);
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return this.documentMetadata != null ? this.documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ExpenseDocument.Builder> getExpenseDocuments() {
            List<ExpenseDocument.Builder> result = ExpenseDocumentListCopier.copyToBuilder(this.expenseDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpenseDocuments(Collection<ExpenseDocument.BuilderImpl> expenseDocuments) {
            this.expenseDocuments = ExpenseDocumentListCopier.copyFromBuilder(expenseDocuments);
        }

        @Override
        public final Builder expenseDocuments(Collection<ExpenseDocument> expenseDocuments) {
            this.expenseDocuments = ExpenseDocumentListCopier.copy(expenseDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expenseDocuments(ExpenseDocument ... expenseDocuments) {
            this.expenseDocuments(Arrays.asList(expenseDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expenseDocuments(Consumer<ExpenseDocument.Builder> ... expenseDocuments) {
            this.expenseDocuments(Stream.of(expenseDocuments).map(c -> (ExpenseDocument)((ExpenseDocument.Builder)ExpenseDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Warning.Builder> getWarnings() {
            List<Warning.Builder> result = WarningsCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<Warning.BuilderImpl> warnings) {
            this.warnings = WarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<Warning> warnings) {
            this.warnings = WarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Warning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<Warning.Builder> ... warnings) {
            this.warnings(Stream.of(warnings).map(c -> (Warning)((Warning.Builder)Warning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getAnalyzeExpenseModelVersion() {
            return this.analyzeExpenseModelVersion;
        }

        public final void setAnalyzeExpenseModelVersion(String analyzeExpenseModelVersion) {
            this.analyzeExpenseModelVersion = analyzeExpenseModelVersion;
        }

        @Override
        public final Builder analyzeExpenseModelVersion(String analyzeExpenseModelVersion) {
            this.analyzeExpenseModelVersion = analyzeExpenseModelVersion;
            return this;
        }

        @Override
        public GetExpenseAnalysisResponse build() {
            return new GetExpenseAnalysisResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TextractResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExpenseAnalysisResponse> {
        public Builder documentMetadata(DocumentMetadata var1);

        default public Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return this.documentMetadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(documentMetadata)).build());
        }

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder nextToken(String var1);

        public Builder expenseDocuments(Collection<ExpenseDocument> var1);

        public Builder expenseDocuments(ExpenseDocument ... var1);

        public Builder expenseDocuments(Consumer<ExpenseDocument.Builder> ... var1);

        public Builder warnings(Collection<Warning> var1);

        public Builder warnings(Warning ... var1);

        public Builder warnings(Consumer<Warning.Builder> ... var1);

        public Builder statusMessage(String var1);

        public Builder analyzeExpenseModelVersion(String var1);
    }
}

