/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.textract.model.DocumentLocation;
import software.amazon.awssdk.services.textract.model.NotificationChannel;
import software.amazon.awssdk.services.textract.model.OutputConfig;
import software.amazon.awssdk.services.textract.model.TextractRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDocumentTextDetectionRequest
extends TextractRequest
implements ToCopyableBuilder<Builder, StartDocumentTextDetectionRequest> {
    private static final SdkField<DocumentLocation> DOCUMENT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentLocation").getter(StartDocumentTextDetectionRequest.getter(StartDocumentTextDetectionRequest::documentLocation)).setter(StartDocumentTextDetectionRequest.setter(Builder::documentLocation)).constructor(DocumentLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentLocation").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartDocumentTextDetectionRequest.getter(StartDocumentTextDetectionRequest::clientRequestToken)).setter(StartDocumentTextDetectionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final SdkField<String> JOB_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobTag").getter(StartDocumentTextDetectionRequest.getter(StartDocumentTextDetectionRequest::jobTag)).setter(StartDocumentTextDetectionRequest.setter(Builder::jobTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()}).build();
    private static final SdkField<NotificationChannel> NOTIFICATION_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationChannel").getter(StartDocumentTextDetectionRequest.getter(StartDocumentTextDetectionRequest::notificationChannel)).setter(StartDocumentTextDetectionRequest.setter(Builder::notificationChannel)).constructor(NotificationChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(StartDocumentTextDetectionRequest.getter(StartDocumentTextDetectionRequest::outputConfig)).setter(StartDocumentTextDetectionRequest.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyId").getter(StartDocumentTextDetectionRequest.getter(StartDocumentTextDetectionRequest::kmsKeyId)).setter(StartDocumentTextDetectionRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_LOCATION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, JOB_TAG_FIELD, NOTIFICATION_CHANNEL_FIELD, OUTPUT_CONFIG_FIELD, KMS_KEY_ID_FIELD));
    private final DocumentLocation documentLocation;
    private final String clientRequestToken;
    private final String jobTag;
    private final NotificationChannel notificationChannel;
    private final OutputConfig outputConfig;
    private final String kmsKeyId;

    private StartDocumentTextDetectionRequest(BuilderImpl builder) {
        super(builder);
        this.documentLocation = builder.documentLocation;
        this.clientRequestToken = builder.clientRequestToken;
        this.jobTag = builder.jobTag;
        this.notificationChannel = builder.notificationChannel;
        this.outputConfig = builder.outputConfig;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final DocumentLocation documentLocation() {
        return this.documentLocation;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String jobTag() {
        return this.jobTag;
    }

    public final NotificationChannel notificationChannel() {
        return this.notificationChannel;
    }

    public final OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.documentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDocumentTextDetectionRequest)) {
            return false;
        }
        StartDocumentTextDetectionRequest other = (StartDocumentTextDetectionRequest)((Object)obj);
        return Objects.equals(this.documentLocation(), other.documentLocation()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.jobTag(), other.jobTag()) && Objects.equals(this.notificationChannel(), other.notificationChannel()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"StartDocumentTextDetectionRequest").add("DocumentLocation", (Object)this.documentLocation()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("JobTag", (Object)this.jobTag()).add("NotificationChannel", (Object)this.notificationChannel()).add("OutputConfig", (Object)this.outputConfig()).add("KMSKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentLocation": {
                return Optional.ofNullable(clazz.cast(this.documentLocation()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "JobTag": {
                return Optional.ofNullable(clazz.cast(this.jobTag()));
            }
            case "NotificationChannel": {
                return Optional.ofNullable(clazz.cast(this.notificationChannel()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "KMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDocumentTextDetectionRequest, T> g) {
        return obj -> g.apply((StartDocumentTextDetectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractRequest.BuilderImpl
    implements Builder {
        private DocumentLocation documentLocation;
        private String clientRequestToken;
        private String jobTag;
        private NotificationChannel notificationChannel;
        private OutputConfig outputConfig;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDocumentTextDetectionRequest model) {
            super(model);
            this.documentLocation(model.documentLocation);
            this.clientRequestToken(model.clientRequestToken);
            this.jobTag(model.jobTag);
            this.notificationChannel(model.notificationChannel);
            this.outputConfig(model.outputConfig);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final DocumentLocation.Builder getDocumentLocation() {
            return this.documentLocation != null ? this.documentLocation.toBuilder() : null;
        }

        @Override
        public final Builder documentLocation(DocumentLocation documentLocation) {
            this.documentLocation = documentLocation;
            return this;
        }

        public final void setDocumentLocation(DocumentLocation.BuilderImpl documentLocation) {
            this.documentLocation = documentLocation != null ? documentLocation.build() : null;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getJobTag() {
            return this.jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        public final NotificationChannel.Builder getNotificationChannel() {
            return this.notificationChannel != null ? this.notificationChannel.toBuilder() : null;
        }

        @Override
        public final Builder notificationChannel(NotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final void setNotificationChannel(NotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDocumentTextDetectionRequest build() {
            return new StartDocumentTextDetectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TextractRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDocumentTextDetectionRequest> {
        public Builder documentLocation(DocumentLocation var1);

        default public Builder documentLocation(Consumer<DocumentLocation.Builder> documentLocation) {
            return this.documentLocation((DocumentLocation)((DocumentLocation.Builder)DocumentLocation.builder().applyMutation(documentLocation)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder jobTag(String var1);

        public Builder notificationChannel(NotificationChannel var1);

        default public Builder notificationChannel(Consumer<NotificationChannel.Builder> notificationChannel) {
            return this.notificationChannel((NotificationChannel)((NotificationChannel.Builder)NotificationChannel.builder().applyMutation(notificationChannel)).build());
        }

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

