/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSupplementalTaxRegistrationResponse extends TaxSettingsResponse implements
        ToCopyableBuilder<PutSupplementalTaxRegistrationResponse.Builder, PutSupplementalTaxRegistrationResponse> {
    private static final SdkField<String> AUTHORITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorityId").getter(getter(PutSupplementalTaxRegistrationResponse::authorityId))
            .setter(setter(Builder::authorityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorityId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(PutSupplementalTaxRegistrationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORITY_ID_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authorityId;

    private final String status;

    private PutSupplementalTaxRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.authorityId = builder.authorityId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Unique authority ID for the supplemental TRN information that was stored.
     * </p>
     * 
     * @return Unique authority ID for the supplemental TRN information that was stored.
     */
    public final String authorityId() {
        return authorityId;
    }

    /**
     * <p>
     * The status of the supplemental TRN stored in the system after processing. Based on the validation occurring on
     * the TRN, the status can be <code>Verified</code>, <code>Pending</code>, <code>Rejected</code>, or
     * <code>Deleted</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaxRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the supplemental TRN stored in the system after processing. Based on the validation
     *         occurring on the TRN, the status can be <code>Verified</code>, <code>Pending</code>,
     *         <code>Rejected</code>, or <code>Deleted</code>.
     * @see TaxRegistrationStatus
     */
    public final TaxRegistrationStatus status() {
        return TaxRegistrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the supplemental TRN stored in the system after processing. Based on the validation occurring on
     * the TRN, the status can be <code>Verified</code>, <code>Pending</code>, <code>Rejected</code>, or
     * <code>Deleted</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaxRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the supplemental TRN stored in the system after processing. Based on the validation
     *         occurring on the TRN, the status can be <code>Verified</code>, <code>Pending</code>,
     *         <code>Rejected</code>, or <code>Deleted</code>.
     * @see TaxRegistrationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorityId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSupplementalTaxRegistrationResponse)) {
            return false;
        }
        PutSupplementalTaxRegistrationResponse other = (PutSupplementalTaxRegistrationResponse) obj;
        return Objects.equals(authorityId(), other.authorityId()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSupplementalTaxRegistrationResponse").add("AuthorityId", authorityId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorityId":
            return Optional.ofNullable(clazz.cast(authorityId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authorityId", AUTHORITY_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSupplementalTaxRegistrationResponse, T> g) {
        return obj -> g.apply((PutSupplementalTaxRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TaxSettingsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutSupplementalTaxRegistrationResponse> {
        /**
         * <p>
         * Unique authority ID for the supplemental TRN information that was stored.
         * </p>
         * 
         * @param authorityId
         *        Unique authority ID for the supplemental TRN information that was stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorityId(String authorityId);

        /**
         * <p>
         * The status of the supplemental TRN stored in the system after processing. Based on the validation occurring
         * on the TRN, the status can be <code>Verified</code>, <code>Pending</code>, <code>Rejected</code>, or
         * <code>Deleted</code>.
         * </p>
         * 
         * @param status
         *        The status of the supplemental TRN stored in the system after processing. Based on the validation
         *        occurring on the TRN, the status can be <code>Verified</code>, <code>Pending</code>,
         *        <code>Rejected</code>, or <code>Deleted</code>.
         * @see TaxRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaxRegistrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the supplemental TRN stored in the system after processing. Based on the validation occurring
         * on the TRN, the status can be <code>Verified</code>, <code>Pending</code>, <code>Rejected</code>, or
         * <code>Deleted</code>.
         * </p>
         * 
         * @param status
         *        The status of the supplemental TRN stored in the system after processing. Based on the validation
         *        occurring on the TRN, the status can be <code>Verified</code>, <code>Pending</code>,
         *        <code>Rejected</code>, or <code>Deleted</code>.
         * @see TaxRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaxRegistrationStatus
         */
        Builder status(TaxRegistrationStatus status);
    }

    static final class BuilderImpl extends TaxSettingsResponse.BuilderImpl implements Builder {
        private String authorityId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSupplementalTaxRegistrationResponse model) {
            super(model);
            authorityId(model.authorityId);
            status(model.status);
        }

        public final String getAuthorityId() {
            return authorityId;
        }

        public final void setAuthorityId(String authorityId) {
            this.authorityId = authorityId;
        }

        @Override
        public final Builder authorityId(String authorityId) {
            this.authorityId = authorityId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaxRegistrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public PutSupplementalTaxRegistrationResponse build() {
            return new PutSupplementalTaxRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
