/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTaxExemptionsResponse extends TaxSettingsResponse implements
        ToCopyableBuilder<ListTaxExemptionsResponse.Builder, ListTaxExemptionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTaxExemptionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Map<String, TaxExemptionDetails>> TAX_EXEMPTION_DETAILS_MAP_FIELD = SdkField
            .<Map<String, TaxExemptionDetails>> builder(MarshallingType.MAP)
            .memberName("taxExemptionDetailsMap")
            .getter(getter(ListTaxExemptionsResponse::taxExemptionDetailsMap))
            .setter(setter(Builder::taxExemptionDetailsMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxExemptionDetailsMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TaxExemptionDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaxExemptionDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TAX_EXEMPTION_DETAILS_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Map<String, TaxExemptionDetails> taxExemptionDetailsMap;

    private ListTaxExemptionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.taxExemptionDetailsMap = builder.taxExemptionDetailsMap;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaxExemptionDetailsMap property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTaxExemptionDetailsMap() {
        return taxExemptionDetailsMap != null && !(taxExemptionDetailsMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tax exemption details map of <code>accountId</code> and tax exemption details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaxExemptionDetailsMap} method.
     * </p>
     * 
     * @return The tax exemption details map of <code>accountId</code> and tax exemption details.
     */
    public final Map<String, TaxExemptionDetails> taxExemptionDetailsMap() {
        return taxExemptionDetailsMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaxExemptionDetailsMap() ? taxExemptionDetailsMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaxExemptionsResponse)) {
            return false;
        }
        ListTaxExemptionsResponse other = (ListTaxExemptionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasTaxExemptionDetailsMap() == other.hasTaxExemptionDetailsMap()
                && Objects.equals(taxExemptionDetailsMap(), other.taxExemptionDetailsMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTaxExemptionsResponse").add("NextToken", nextToken())
                .add("TaxExemptionDetailsMap", hasTaxExemptionDetailsMap() ? taxExemptionDetailsMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "taxExemptionDetailsMap":
            return Optional.ofNullable(clazz.cast(taxExemptionDetailsMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("taxExemptionDetailsMap", TAX_EXEMPTION_DETAILS_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTaxExemptionsResponse, T> g) {
        return obj -> g.apply((ListTaxExemptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TaxSettingsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTaxExemptionsResponse> {
        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The tax exemption details map of <code>accountId</code> and tax exemption details.
         * </p>
         * 
         * @param taxExemptionDetailsMap
         *        The tax exemption details map of <code>accountId</code> and tax exemption details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxExemptionDetailsMap(Map<String, TaxExemptionDetails> taxExemptionDetailsMap);
    }

    static final class BuilderImpl extends TaxSettingsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private Map<String, TaxExemptionDetails> taxExemptionDetailsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaxExemptionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            taxExemptionDetailsMap(model.taxExemptionDetailsMap);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Map<String, TaxExemptionDetails.Builder> getTaxExemptionDetailsMap() {
            Map<String, TaxExemptionDetails.Builder> result = TaxExemptionDetailsMapCopier
                    .copyToBuilder(this.taxExemptionDetailsMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTaxExemptionDetailsMap(Map<String, TaxExemptionDetails.BuilderImpl> taxExemptionDetailsMap) {
            this.taxExemptionDetailsMap = TaxExemptionDetailsMapCopier.copyFromBuilder(taxExemptionDetailsMap);
        }

        @Override
        public final Builder taxExemptionDetailsMap(Map<String, TaxExemptionDetails> taxExemptionDetailsMap) {
            this.taxExemptionDetailsMap = TaxExemptionDetailsMapCopier.copy(taxExemptionDetailsMap);
            return this;
        }

        @Override
        public ListTaxExemptionsResponse build() {
            return new ListTaxExemptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
