/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information to specify for a TRN in Egypt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EgyptAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<EgyptAdditionalInfo.Builder, EgyptAdditionalInfo> {
    private static final SdkField<String> UNIQUE_IDENTIFICATION_NUMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("uniqueIdentificationNumber")
            .getter(getter(EgyptAdditionalInfo::uniqueIdentificationNumber))
            .setter(setter(Builder::uniqueIdentificationNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueIdentificationNumber").build())
            .build();

    private static final SdkField<String> UNIQUE_IDENTIFICATION_NUMBER_EXPIRATION_DATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("uniqueIdentificationNumberExpirationDate")
            .getter(getter(EgyptAdditionalInfo::uniqueIdentificationNumberExpirationDate))
            .setter(setter(Builder::uniqueIdentificationNumberExpirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("uniqueIdentificationNumberExpirationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            UNIQUE_IDENTIFICATION_NUMBER_FIELD, UNIQUE_IDENTIFICATION_NUMBER_EXPIRATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String uniqueIdentificationNumber;

    private final String uniqueIdentificationNumberExpirationDate;

    private EgyptAdditionalInfo(BuilderImpl builder) {
        this.uniqueIdentificationNumber = builder.uniqueIdentificationNumber;
        this.uniqueIdentificationNumberExpirationDate = builder.uniqueIdentificationNumberExpirationDate;
    }

    /**
     * <p>
     * The unique identification number provided by the Egypt Tax Authority.
     * </p>
     * 
     * @return The unique identification number provided by the Egypt Tax Authority.
     */
    public final String uniqueIdentificationNumber() {
        return uniqueIdentificationNumber;
    }

    /**
     * <p>
     * The expiration date of the unique identification number provided by the Egypt Tax Authority.
     * </p>
     * 
     * @return The expiration date of the unique identification number provided by the Egypt Tax Authority.
     */
    public final String uniqueIdentificationNumberExpirationDate() {
        return uniqueIdentificationNumberExpirationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uniqueIdentificationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueIdentificationNumberExpirationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EgyptAdditionalInfo)) {
            return false;
        }
        EgyptAdditionalInfo other = (EgyptAdditionalInfo) obj;
        return Objects.equals(uniqueIdentificationNumber(), other.uniqueIdentificationNumber())
                && Objects.equals(uniqueIdentificationNumberExpirationDate(), other.uniqueIdentificationNumberExpirationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EgyptAdditionalInfo").add("UniqueIdentificationNumber", uniqueIdentificationNumber())
                .add("UniqueIdentificationNumberExpirationDate", uniqueIdentificationNumberExpirationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "uniqueIdentificationNumber":
            return Optional.ofNullable(clazz.cast(uniqueIdentificationNumber()));
        case "uniqueIdentificationNumberExpirationDate":
            return Optional.ofNullable(clazz.cast(uniqueIdentificationNumberExpirationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("uniqueIdentificationNumber", UNIQUE_IDENTIFICATION_NUMBER_FIELD);
        map.put("uniqueIdentificationNumberExpirationDate", UNIQUE_IDENTIFICATION_NUMBER_EXPIRATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EgyptAdditionalInfo, T> g) {
        return obj -> g.apply((EgyptAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EgyptAdditionalInfo> {
        /**
         * <p>
         * The unique identification number provided by the Egypt Tax Authority.
         * </p>
         * 
         * @param uniqueIdentificationNumber
         *        The unique identification number provided by the Egypt Tax Authority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueIdentificationNumber(String uniqueIdentificationNumber);

        /**
         * <p>
         * The expiration date of the unique identification number provided by the Egypt Tax Authority.
         * </p>
         * 
         * @param uniqueIdentificationNumberExpirationDate
         *        The expiration date of the unique identification number provided by the Egypt Tax Authority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueIdentificationNumberExpirationDate(String uniqueIdentificationNumberExpirationDate);
    }

    static final class BuilderImpl implements Builder {
        private String uniqueIdentificationNumber;

        private String uniqueIdentificationNumberExpirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(EgyptAdditionalInfo model) {
            uniqueIdentificationNumber(model.uniqueIdentificationNumber);
            uniqueIdentificationNumberExpirationDate(model.uniqueIdentificationNumberExpirationDate);
        }

        public final String getUniqueIdentificationNumber() {
            return uniqueIdentificationNumber;
        }

        public final void setUniqueIdentificationNumber(String uniqueIdentificationNumber) {
            this.uniqueIdentificationNumber = uniqueIdentificationNumber;
        }

        @Override
        public final Builder uniqueIdentificationNumber(String uniqueIdentificationNumber) {
            this.uniqueIdentificationNumber = uniqueIdentificationNumber;
            return this;
        }

        public final String getUniqueIdentificationNumberExpirationDate() {
            return uniqueIdentificationNumberExpirationDate;
        }

        public final void setUniqueIdentificationNumberExpirationDate(String uniqueIdentificationNumberExpirationDate) {
            this.uniqueIdentificationNumberExpirationDate = uniqueIdentificationNumberExpirationDate;
        }

        @Override
        public final Builder uniqueIdentificationNumberExpirationDate(String uniqueIdentificationNumberExpirationDate) {
            this.uniqueIdentificationNumberExpirationDate = uniqueIdentificationNumberExpirationDate;
            return this;
        }

        @Override
        public EgyptAdditionalInfo build() {
            return new EgyptAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
