/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSupplementalTaxRegistrationRequest extends TaxSettingsRequest implements
        ToCopyableBuilder<DeleteSupplementalTaxRegistrationRequest.Builder, DeleteSupplementalTaxRegistrationRequest> {
    private static final SdkField<String> AUTHORITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorityId").getter(getter(DeleteSupplementalTaxRegistrationRequest::authorityId))
            .setter(setter(Builder::authorityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorityId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORITY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authorityId;

    private DeleteSupplementalTaxRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.authorityId = builder.authorityId;
    }

    /**
     * <p>
     * The unique authority Id for the supplemental TRN information that needs to be deleted.
     * </p>
     * 
     * @return The unique authority Id for the supplemental TRN information that needs to be deleted.
     */
    public final String authorityId() {
        return authorityId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorityId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSupplementalTaxRegistrationRequest)) {
            return false;
        }
        DeleteSupplementalTaxRegistrationRequest other = (DeleteSupplementalTaxRegistrationRequest) obj;
        return Objects.equals(authorityId(), other.authorityId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSupplementalTaxRegistrationRequest").add("AuthorityId", authorityId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorityId":
            return Optional.ofNullable(clazz.cast(authorityId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authorityId", AUTHORITY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSupplementalTaxRegistrationRequest, T> g) {
        return obj -> g.apply((DeleteSupplementalTaxRegistrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TaxSettingsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteSupplementalTaxRegistrationRequest> {
        /**
         * <p>
         * The unique authority Id for the supplemental TRN information that needs to be deleted.
         * </p>
         * 
         * @param authorityId
         *        The unique authority Id for the supplemental TRN information that needs to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorityId(String authorityId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TaxSettingsRequest.BuilderImpl implements Builder {
        private String authorityId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSupplementalTaxRegistrationRequest model) {
            super(model);
            authorityId(model.authorityId);
        }

        public final String getAuthorityId() {
            return authorityId;
        }

        public final void setAuthorityId(String authorityId) {
            this.authorityId = authorityId;
        }

        @Override
        public final Builder authorityId(String authorityId) {
            this.authorityId = authorityId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSupplementalTaxRegistrationRequest build() {
            return new DeleteSupplementalTaxRegistrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
