/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.taxsettings.model.BatchDeleteTaxRegistrationError;
import software.amazon.awssdk.services.taxsettings.model.BatchDeleteTaxRegistrationErrorsCopier;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteTaxRegistrationResponse
extends TaxSettingsResponse
implements ToCopyableBuilder<Builder, BatchDeleteTaxRegistrationResponse> {
    private static final SdkField<List<BatchDeleteTaxRegistrationError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchDeleteTaxRegistrationResponse.getter(BatchDeleteTaxRegistrationResponse::errors)).setter(BatchDeleteTaxRegistrationResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDeleteTaxRegistrationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteTaxRegistrationResponse.memberNameToFieldInitializer();
    private final List<BatchDeleteTaxRegistrationError> errors;

    private BatchDeleteTaxRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchDeleteTaxRegistrationError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteTaxRegistrationResponse)) {
            return false;
        }
        BatchDeleteTaxRegistrationResponse other = (BatchDeleteTaxRegistrationResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteTaxRegistrationResponse").add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<BatchDeleteTaxRegistrationError>>> map = new HashMap<String, SdkField<List<BatchDeleteTaxRegistrationError>>>();
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteTaxRegistrationResponse, T> g) {
        return obj -> g.apply((BatchDeleteTaxRegistrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TaxSettingsResponse.BuilderImpl
    implements Builder {
        private List<BatchDeleteTaxRegistrationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteTaxRegistrationResponse model) {
            super(model);
            this.errors(model.errors);
        }

        public final List<BatchDeleteTaxRegistrationError.Builder> getErrors() {
            List<BatchDeleteTaxRegistrationError.Builder> result = BatchDeleteTaxRegistrationErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchDeleteTaxRegistrationError.BuilderImpl> errors) {
            this.errors = BatchDeleteTaxRegistrationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchDeleteTaxRegistrationError> errors) {
            this.errors = BatchDeleteTaxRegistrationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDeleteTaxRegistrationError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDeleteTaxRegistrationError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchDeleteTaxRegistrationError)((BatchDeleteTaxRegistrationError.Builder)BatchDeleteTaxRegistrationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDeleteTaxRegistrationResponse build() {
            return new BatchDeleteTaxRegistrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TaxSettingsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteTaxRegistrationResponse> {
        public Builder errors(Collection<BatchDeleteTaxRegistrationError> var1);

        public Builder errors(BatchDeleteTaxRegistrationError ... var1);

        public Builder errors(Consumer<BatchDeleteTaxRegistrationError.Builder> ... var1);
    }
}

