/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.taxsettings.model.AuthoritiesCopier;
import software.amazon.awssdk.services.taxsettings.model.Authority;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaxExemptionType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaxExemptionType> {
    private static final SdkField<List<Authority>> APPLICABLE_JURISDICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicableJurisdictions").getter(TaxExemptionType.getter(TaxExemptionType::applicableJurisdictions)).setter(TaxExemptionType.setter(Builder::applicableJurisdictions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicableJurisdictions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Authority::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(TaxExemptionType.getter(TaxExemptionType::description)).setter(TaxExemptionType.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(TaxExemptionType.getter(TaxExemptionType::displayName)).setter(TaxExemptionType.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICABLE_JURISDICTIONS_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaxExemptionType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Authority> applicableJurisdictions;
    private final String description;
    private final String displayName;

    private TaxExemptionType(BuilderImpl builder) {
        this.applicableJurisdictions = builder.applicableJurisdictions;
        this.description = builder.description;
        this.displayName = builder.displayName;
    }

    public final boolean hasApplicableJurisdictions() {
        return this.applicableJurisdictions != null && !(this.applicableJurisdictions instanceof SdkAutoConstructList);
    }

    public final List<Authority> applicableJurisdictions() {
        return this.applicableJurisdictions;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicableJurisdictions() ? this.applicableJurisdictions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxExemptionType)) {
            return false;
        }
        TaxExemptionType other = (TaxExemptionType)obj;
        return this.hasApplicableJurisdictions() == other.hasApplicableJurisdictions() && Objects.equals(this.applicableJurisdictions(), other.applicableJurisdictions()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName());
    }

    public final String toString() {
        return ToString.builder((String)"TaxExemptionType").add("ApplicableJurisdictions", this.hasApplicableJurisdictions() ? this.applicableJurisdictions() : null).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicableJurisdictions": {
                return Optional.ofNullable(clazz.cast(this.applicableJurisdictions()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicableJurisdictions", APPLICABLE_JURISDICTIONS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaxExemptionType, T> g) {
        return obj -> g.apply((TaxExemptionType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Authority> applicableJurisdictions = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxExemptionType model) {
            this.applicableJurisdictions(model.applicableJurisdictions);
            this.description(model.description);
            this.displayName(model.displayName);
        }

        public final List<Authority.Builder> getApplicableJurisdictions() {
            List<Authority.Builder> result = AuthoritiesCopier.copyToBuilder(this.applicableJurisdictions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicableJurisdictions(Collection<Authority.BuilderImpl> applicableJurisdictions) {
            this.applicableJurisdictions = AuthoritiesCopier.copyFromBuilder(applicableJurisdictions);
        }

        @Override
        public final Builder applicableJurisdictions(Collection<Authority> applicableJurisdictions) {
            this.applicableJurisdictions = AuthoritiesCopier.copy(applicableJurisdictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableJurisdictions(Authority ... applicableJurisdictions) {
            this.applicableJurisdictions(Arrays.asList(applicableJurisdictions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableJurisdictions(Consumer<Authority.Builder> ... applicableJurisdictions) {
            this.applicableJurisdictions(Stream.of(applicableJurisdictions).map(c -> (Authority)((Authority.Builder)Authority.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public TaxExemptionType build() {
            return new TaxExemptionType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaxExemptionType> {
        public Builder applicableJurisdictions(Collection<Authority> var1);

        public Builder applicableJurisdictions(Authority ... var1);

        public Builder applicableJurisdictions(Consumer<Authority.Builder> ... var1);

        public Builder description(String var1);

        public Builder displayName(String var1);
    }
}

