/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AddressRoleType {
    TAX_ADDRESS("TaxAddress"),
    BILLING_ADDRESS("BillingAddress"),
    CONTACT_ADDRESS("ContactAddress"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AddressRoleType> VALUE_MAP;
    private final String value;

    private AddressRoleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AddressRoleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AddressRoleType> knownValues() {
        EnumSet<AddressRoleType> knownValues = EnumSet.allOf(AddressRoleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AddressRoleType.class, AddressRoleType::toString);
    }
}

