/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.taxsettings.TaxSettingsClient;
import software.amazon.awssdk.services.taxsettings.internal.UserAgentUtils;
import software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsResponse;
import software.amazon.awssdk.services.taxsettings.model.SupplementalTaxRegistration;

public class ListSupplementalTaxRegistrationsIterable
implements SdkIterable<ListSupplementalTaxRegistrationsResponse> {
    private final TaxSettingsClient client;
    private final ListSupplementalTaxRegistrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSupplementalTaxRegistrationsIterable(TaxSettingsClient client, ListSupplementalTaxRegistrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSupplementalTaxRegistrationsResponseFetcher();
    }

    public Iterator<ListSupplementalTaxRegistrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SupplementalTaxRegistration> taxRegistrations() {
        Function<ListSupplementalTaxRegistrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.taxRegistrations() != null) {
                return response.taxRegistrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSupplementalTaxRegistrationsResponseFetcher
    implements SyncPageFetcher<ListSupplementalTaxRegistrationsResponse> {
        private ListSupplementalTaxRegistrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSupplementalTaxRegistrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSupplementalTaxRegistrationsResponse nextPage(ListSupplementalTaxRegistrationsResponse previousPage) {
            if (previousPage == null) {
                return ListSupplementalTaxRegistrationsIterable.this.client.listSupplementalTaxRegistrations(ListSupplementalTaxRegistrationsIterable.this.firstRequest);
            }
            return ListSupplementalTaxRegistrationsIterable.this.client.listSupplementalTaxRegistrations((ListSupplementalTaxRegistrationsRequest)((Object)ListSupplementalTaxRegistrationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

