/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.taxsettings.model.TaxRegistrationDocument;
import software.amazon.awssdk.services.taxsettings.model.TaxRegistrationDocumentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerificationDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerificationDetails> {
    private static final SdkField<String> DATE_OF_BIRTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateOfBirth").getter(VerificationDetails.getter(VerificationDetails::dateOfBirth)).setter(VerificationDetails.setter(Builder::dateOfBirth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateOfBirth").build()}).build();
    private static final SdkField<List<TaxRegistrationDocument>> TAX_REGISTRATION_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taxRegistrationDocuments").getter(VerificationDetails.getter(VerificationDetails::taxRegistrationDocuments)).setter(VerificationDetails.setter(Builder::taxRegistrationDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistrationDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaxRegistrationDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_OF_BIRTH_FIELD, TAX_REGISTRATION_DOCUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VerificationDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dateOfBirth;
    private final List<TaxRegistrationDocument> taxRegistrationDocuments;

    private VerificationDetails(BuilderImpl builder) {
        this.dateOfBirth = builder.dateOfBirth;
        this.taxRegistrationDocuments = builder.taxRegistrationDocuments;
    }

    public final String dateOfBirth() {
        return this.dateOfBirth;
    }

    public final boolean hasTaxRegistrationDocuments() {
        return this.taxRegistrationDocuments != null && !(this.taxRegistrationDocuments instanceof SdkAutoConstructList);
    }

    public final List<TaxRegistrationDocument> taxRegistrationDocuments() {
        return this.taxRegistrationDocuments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dateOfBirth());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaxRegistrationDocuments() ? this.taxRegistrationDocuments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerificationDetails)) {
            return false;
        }
        VerificationDetails other = (VerificationDetails)obj;
        return Objects.equals(this.dateOfBirth(), other.dateOfBirth()) && this.hasTaxRegistrationDocuments() == other.hasTaxRegistrationDocuments() && Objects.equals(this.taxRegistrationDocuments(), other.taxRegistrationDocuments());
    }

    public final String toString() {
        return ToString.builder((String)"VerificationDetails").add("DateOfBirth", (Object)this.dateOfBirth()).add("TaxRegistrationDocuments", this.hasTaxRegistrationDocuments() ? this.taxRegistrationDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dateOfBirth": {
                return Optional.ofNullable(clazz.cast(this.dateOfBirth()));
            }
            case "taxRegistrationDocuments": {
                return Optional.ofNullable(clazz.cast(this.taxRegistrationDocuments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dateOfBirth", DATE_OF_BIRTH_FIELD);
        map.put("taxRegistrationDocuments", TAX_REGISTRATION_DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerificationDetails, T> g) {
        return obj -> g.apply((VerificationDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dateOfBirth;
        private List<TaxRegistrationDocument> taxRegistrationDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerificationDetails model) {
            this.dateOfBirth(model.dateOfBirth);
            this.taxRegistrationDocuments(model.taxRegistrationDocuments);
        }

        public final String getDateOfBirth() {
            return this.dateOfBirth;
        }

        public final void setDateOfBirth(String dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
        }

        @Override
        public final Builder dateOfBirth(String dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }

        public final List<TaxRegistrationDocument.Builder> getTaxRegistrationDocuments() {
            List<TaxRegistrationDocument.Builder> result = TaxRegistrationDocumentsCopier.copyToBuilder(this.taxRegistrationDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaxRegistrationDocuments(Collection<TaxRegistrationDocument.BuilderImpl> taxRegistrationDocuments) {
            this.taxRegistrationDocuments = TaxRegistrationDocumentsCopier.copyFromBuilder(taxRegistrationDocuments);
        }

        @Override
        public final Builder taxRegistrationDocuments(Collection<TaxRegistrationDocument> taxRegistrationDocuments) {
            this.taxRegistrationDocuments = TaxRegistrationDocumentsCopier.copy(taxRegistrationDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxRegistrationDocuments(TaxRegistrationDocument ... taxRegistrationDocuments) {
            this.taxRegistrationDocuments(Arrays.asList(taxRegistrationDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxRegistrationDocuments(Consumer<TaxRegistrationDocument.Builder> ... taxRegistrationDocuments) {
            this.taxRegistrationDocuments(Stream.of(taxRegistrationDocuments).map(c -> (TaxRegistrationDocument)((TaxRegistrationDocument.Builder)TaxRegistrationDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VerificationDetails build() {
            return new VerificationDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerificationDetails> {
        public Builder dateOfBirth(String var1);

        public Builder taxRegistrationDocuments(Collection<TaxRegistrationDocument> var1);

        public Builder taxRegistrationDocuments(TaxRegistrationDocument ... var1);

        public Builder taxRegistrationDocuments(Consumer<TaxRegistrationDocument.Builder> ... var1);
    }
}

