/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Jurisdiction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Jurisdiction> {
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("countryCode").getter(Jurisdiction.getter(Jurisdiction::countryCode)).setter(Jurisdiction.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countryCode").build()}).build();
    private static final SdkField<String> STATE_OR_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateOrRegion").getter(Jurisdiction.getter(Jurisdiction::stateOrRegion)).setter(Jurisdiction.setter(Builder::stateOrRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateOrRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_CODE_FIELD, STATE_OR_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Jurisdiction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String countryCode;
    private final String stateOrRegion;

    private Jurisdiction(BuilderImpl builder) {
        this.countryCode = builder.countryCode;
        this.stateOrRegion = builder.stateOrRegion;
    }

    public final String countryCode() {
        return this.countryCode;
    }

    public final String stateOrRegion() {
        return this.stateOrRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateOrRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Jurisdiction)) {
            return false;
        }
        Jurisdiction other = (Jurisdiction)obj;
        return Objects.equals(this.countryCode(), other.countryCode()) && Objects.equals(this.stateOrRegion(), other.stateOrRegion());
    }

    public final String toString() {
        return ToString.builder((String)"Jurisdiction").add("CountryCode", (Object)this.countryCode()).add("StateOrRegion", (Object)this.stateOrRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "countryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCode()));
            }
            case "stateOrRegion": {
                return Optional.ofNullable(clazz.cast(this.stateOrRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("countryCode", COUNTRY_CODE_FIELD);
        map.put("stateOrRegion", STATE_OR_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Jurisdiction, T> g) {
        return obj -> g.apply((Jurisdiction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String countryCode;
        private String stateOrRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Jurisdiction model) {
            this.countryCode(model.countryCode);
            this.stateOrRegion(model.stateOrRegion);
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final String getStateOrRegion() {
            return this.stateOrRegion;
        }

        public final void setStateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
        }

        @Override
        public final Builder stateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
            return this;
        }

        public Jurisdiction build() {
            return new Jurisdiction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Jurisdiction> {
        public Builder countryCode(String var1);

        public Builder stateOrRegion(String var1);
    }
}

