/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.taxsettings.model.MalaysiaServiceTaxCode;
import software.amazon.awssdk.services.taxsettings.model.MalaysiaServiceTaxCodesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MalaysiaAdditionalInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MalaysiaAdditionalInfo> {
    private static final SdkField<String> BUSINESS_REGISTRATION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("businessRegistrationNumber").getter(MalaysiaAdditionalInfo.getter(MalaysiaAdditionalInfo::businessRegistrationNumber)).setter(MalaysiaAdditionalInfo.setter(Builder::businessRegistrationNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessRegistrationNumber").build()}).build();
    private static final SdkField<List<String>> SERVICE_TAX_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceTaxCodes").getter(MalaysiaAdditionalInfo.getter(MalaysiaAdditionalInfo::serviceTaxCodesAsStrings)).setter(MalaysiaAdditionalInfo.setter(Builder::serviceTaxCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceTaxCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TAX_INFORMATION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taxInformationNumber").getter(MalaysiaAdditionalInfo.getter(MalaysiaAdditionalInfo::taxInformationNumber)).setter(MalaysiaAdditionalInfo.setter(Builder::taxInformationNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxInformationNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_REGISTRATION_NUMBER_FIELD, SERVICE_TAX_CODES_FIELD, TAX_INFORMATION_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MalaysiaAdditionalInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String businessRegistrationNumber;
    private final List<String> serviceTaxCodes;
    private final String taxInformationNumber;

    private MalaysiaAdditionalInfo(BuilderImpl builder) {
        this.businessRegistrationNumber = builder.businessRegistrationNumber;
        this.serviceTaxCodes = builder.serviceTaxCodes;
        this.taxInformationNumber = builder.taxInformationNumber;
    }

    public final String businessRegistrationNumber() {
        return this.businessRegistrationNumber;
    }

    public final List<MalaysiaServiceTaxCode> serviceTaxCodes() {
        return MalaysiaServiceTaxCodesListCopier.copyStringToEnum(this.serviceTaxCodes);
    }

    public final boolean hasServiceTaxCodes() {
        return this.serviceTaxCodes != null && !(this.serviceTaxCodes instanceof SdkAutoConstructList);
    }

    public final List<String> serviceTaxCodesAsStrings() {
        return this.serviceTaxCodes;
    }

    public final String taxInformationNumber() {
        return this.taxInformationNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.businessRegistrationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceTaxCodes() ? this.serviceTaxCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taxInformationNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MalaysiaAdditionalInfo)) {
            return false;
        }
        MalaysiaAdditionalInfo other = (MalaysiaAdditionalInfo)obj;
        return Objects.equals(this.businessRegistrationNumber(), other.businessRegistrationNumber()) && this.hasServiceTaxCodes() == other.hasServiceTaxCodes() && Objects.equals(this.serviceTaxCodesAsStrings(), other.serviceTaxCodesAsStrings()) && Objects.equals(this.taxInformationNumber(), other.taxInformationNumber());
    }

    public final String toString() {
        return ToString.builder((String)"MalaysiaAdditionalInfo").add("BusinessRegistrationNumber", (Object)this.businessRegistrationNumber()).add("ServiceTaxCodes", this.hasServiceTaxCodes() ? this.serviceTaxCodesAsStrings() : null).add("TaxInformationNumber", (Object)this.taxInformationNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "businessRegistrationNumber": {
                return Optional.ofNullable(clazz.cast(this.businessRegistrationNumber()));
            }
            case "serviceTaxCodes": {
                return Optional.ofNullable(clazz.cast(this.serviceTaxCodesAsStrings()));
            }
            case "taxInformationNumber": {
                return Optional.ofNullable(clazz.cast(this.taxInformationNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessRegistrationNumber", BUSINESS_REGISTRATION_NUMBER_FIELD);
        map.put("serviceTaxCodes", SERVICE_TAX_CODES_FIELD);
        map.put("taxInformationNumber", TAX_INFORMATION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MalaysiaAdditionalInfo, T> g) {
        return obj -> g.apply((MalaysiaAdditionalInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String businessRegistrationNumber;
        private List<String> serviceTaxCodes = DefaultSdkAutoConstructList.getInstance();
        private String taxInformationNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(MalaysiaAdditionalInfo model) {
            this.businessRegistrationNumber(model.businessRegistrationNumber);
            this.serviceTaxCodesWithStrings(model.serviceTaxCodes);
            this.taxInformationNumber(model.taxInformationNumber);
        }

        public final String getBusinessRegistrationNumber() {
            return this.businessRegistrationNumber;
        }

        public final void setBusinessRegistrationNumber(String businessRegistrationNumber) {
            this.businessRegistrationNumber = businessRegistrationNumber;
        }

        @Override
        public final Builder businessRegistrationNumber(String businessRegistrationNumber) {
            this.businessRegistrationNumber = businessRegistrationNumber;
            return this;
        }

        public final Collection<String> getServiceTaxCodes() {
            if (this.serviceTaxCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceTaxCodes;
        }

        public final void setServiceTaxCodes(Collection<String> serviceTaxCodes) {
            this.serviceTaxCodes = MalaysiaServiceTaxCodesListCopier.copy(serviceTaxCodes);
        }

        @Override
        public final Builder serviceTaxCodesWithStrings(Collection<String> serviceTaxCodes) {
            this.serviceTaxCodes = MalaysiaServiceTaxCodesListCopier.copy(serviceTaxCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceTaxCodesWithStrings(String ... serviceTaxCodes) {
            this.serviceTaxCodesWithStrings(Arrays.asList(serviceTaxCodes));
            return this;
        }

        @Override
        public final Builder serviceTaxCodes(Collection<MalaysiaServiceTaxCode> serviceTaxCodes) {
            this.serviceTaxCodes = MalaysiaServiceTaxCodesListCopier.copyEnumToString(serviceTaxCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceTaxCodes(MalaysiaServiceTaxCode ... serviceTaxCodes) {
            this.serviceTaxCodes(Arrays.asList(serviceTaxCodes));
            return this;
        }

        public final String getTaxInformationNumber() {
            return this.taxInformationNumber;
        }

        public final void setTaxInformationNumber(String taxInformationNumber) {
            this.taxInformationNumber = taxInformationNumber;
        }

        @Override
        public final Builder taxInformationNumber(String taxInformationNumber) {
            this.taxInformationNumber = taxInformationNumber;
            return this;
        }

        public MalaysiaAdditionalInfo build() {
            return new MalaysiaAdditionalInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MalaysiaAdditionalInfo> {
        public Builder businessRegistrationNumber(String var1);

        public Builder serviceTaxCodesWithStrings(Collection<String> var1);

        public Builder serviceTaxCodesWithStrings(String ... var1);

        public Builder serviceTaxCodes(Collection<MalaysiaServiceTaxCode> var1);

        public Builder serviceTaxCodes(MalaysiaServiceTaxCode ... var1);

        public Builder taxInformationNumber(String var1);
    }
}

