/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.taxsettings.model.SourceS3Location;
import software.amazon.awssdk.services.taxsettings.model.TaxRegistrationDocFile;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaxRegistrationDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaxRegistrationDocument> {
    private static final SdkField<TaxRegistrationDocFile> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("file").getter(TaxRegistrationDocument.getter(TaxRegistrationDocument::file)).setter(TaxRegistrationDocument.setter(Builder::file)).constructor(TaxRegistrationDocFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()}).build();
    private static final SdkField<SourceS3Location> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Location").getter(TaxRegistrationDocument.getter(TaxRegistrationDocument::s3Location)).setter(TaxRegistrationDocument.setter(Builder::s3Location)).constructor(SourceS3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD, S3_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaxRegistrationDocument.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TaxRegistrationDocFile file;
    private final SourceS3Location s3Location;

    private TaxRegistrationDocument(BuilderImpl builder) {
        this.file = builder.file;
        this.s3Location = builder.s3Location;
    }

    public final TaxRegistrationDocFile file() {
        return this.file;
    }

    public final SourceS3Location s3Location() {
        return this.s3Location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxRegistrationDocument)) {
            return false;
        }
        TaxRegistrationDocument other = (TaxRegistrationDocument)obj;
        return Objects.equals(this.file(), other.file()) && Objects.equals(this.s3Location(), other.s3Location());
    }

    public final String toString() {
        return ToString.builder((String)"TaxRegistrationDocument").add("File", (Object)this.file()).add("S3Location", (Object)this.s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "file": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("file", FILE_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaxRegistrationDocument, T> g) {
        return obj -> g.apply((TaxRegistrationDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TaxRegistrationDocFile file;
        private SourceS3Location s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxRegistrationDocument model) {
            this.file(model.file);
            this.s3Location(model.s3Location);
        }

        public final TaxRegistrationDocFile.Builder getFile() {
            return this.file != null ? this.file.toBuilder() : null;
        }

        public final void setFile(TaxRegistrationDocFile.BuilderImpl file) {
            this.file = file != null ? file.build() : null;
        }

        @Override
        public final Builder file(TaxRegistrationDocFile file) {
            this.file = file;
            return this;
        }

        public final SourceS3Location.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        public final void setS3Location(SourceS3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(SourceS3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public TaxRegistrationDocument build() {
            return new TaxRegistrationDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaxRegistrationDocument> {
        public Builder file(TaxRegistrationDocFile var1);

        default public Builder file(Consumer<TaxRegistrationDocFile.Builder> file) {
            return this.file((TaxRegistrationDocFile)((TaxRegistrationDocFile.Builder)TaxRegistrationDocFile.builder().applyMutation(file)).build());
        }

        public Builder s3Location(SourceS3Location var1);

        default public Builder s3Location(Consumer<SourceS3Location.Builder> s3Location) {
            return this.s3Location((SourceS3Location)((SourceS3Location.Builder)SourceS3Location.builder().applyMutation(s3Location)).build());
        }
    }
}

