/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MalaysiaServiceTaxCode {
    CONSULTANCY("Consultancy"),
    DIGITAL_SERVICE_AND_ELECTRONIC_MEDIUM("Digital Service And Electronic Medium"),
    IT_SERVICES("IT Services"),
    TRAINING_OR_COACHING("Training Or Coaching"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MalaysiaServiceTaxCode> VALUE_MAP;
    private final String value;

    private MalaysiaServiceTaxCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MalaysiaServiceTaxCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MalaysiaServiceTaxCode> knownValues() {
        EnumSet<MalaysiaServiceTaxCode> knownValues = EnumSet.allOf(MalaysiaServiceTaxCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MalaysiaServiceTaxCode.class, MalaysiaServiceTaxCode::toString);
    }
}

