/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.taxsettings.model.SupplementalTaxRegistration;
import software.amazon.awssdk.services.taxsettings.model.SupplementalTaxRegistrationListCopier;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSupplementalTaxRegistrationsResponse
extends TaxSettingsResponse
implements ToCopyableBuilder<Builder, ListSupplementalTaxRegistrationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSupplementalTaxRegistrationsResponse.getter(ListSupplementalTaxRegistrationsResponse::nextToken)).setter(ListSupplementalTaxRegistrationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SupplementalTaxRegistration>> TAX_REGISTRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taxRegistrations").getter(ListSupplementalTaxRegistrationsResponse.getter(ListSupplementalTaxRegistrationsResponse::taxRegistrations)).setter(ListSupplementalTaxRegistrationsResponse.setter(Builder::taxRegistrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistrations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SupplementalTaxRegistration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TAX_REGISTRATIONS_FIELD));
    private final String nextToken;
    private final List<SupplementalTaxRegistration> taxRegistrations;

    private ListSupplementalTaxRegistrationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.taxRegistrations = builder.taxRegistrations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTaxRegistrations() {
        return this.taxRegistrations != null && !(this.taxRegistrations instanceof SdkAutoConstructList);
    }

    public final List<SupplementalTaxRegistration> taxRegistrations() {
        return this.taxRegistrations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaxRegistrations() ? this.taxRegistrations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSupplementalTaxRegistrationsResponse)) {
            return false;
        }
        ListSupplementalTaxRegistrationsResponse other = (ListSupplementalTaxRegistrationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTaxRegistrations() == other.hasTaxRegistrations() && Objects.equals(this.taxRegistrations(), other.taxRegistrations());
    }

    public final String toString() {
        return ToString.builder((String)"ListSupplementalTaxRegistrationsResponse").add("NextToken", (Object)this.nextToken()).add("TaxRegistrations", (Object)(this.taxRegistrations() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "taxRegistrations": {
                return Optional.ofNullable(clazz.cast(this.taxRegistrations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSupplementalTaxRegistrationsResponse, T> g) {
        return obj -> g.apply((ListSupplementalTaxRegistrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TaxSettingsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SupplementalTaxRegistration> taxRegistrations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSupplementalTaxRegistrationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.taxRegistrations(model.taxRegistrations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SupplementalTaxRegistration.Builder> getTaxRegistrations() {
            List<SupplementalTaxRegistration.Builder> result = SupplementalTaxRegistrationListCopier.copyToBuilder(this.taxRegistrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaxRegistrations(Collection<SupplementalTaxRegistration.BuilderImpl> taxRegistrations) {
            this.taxRegistrations = SupplementalTaxRegistrationListCopier.copyFromBuilder(taxRegistrations);
        }

        @Override
        public final Builder taxRegistrations(Collection<SupplementalTaxRegistration> taxRegistrations) {
            this.taxRegistrations = SupplementalTaxRegistrationListCopier.copy(taxRegistrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxRegistrations(SupplementalTaxRegistration ... taxRegistrations) {
            this.taxRegistrations(Arrays.asList(taxRegistrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxRegistrations(Consumer<SupplementalTaxRegistration.Builder> ... taxRegistrations) {
            this.taxRegistrations(Stream.of(taxRegistrations).map(c -> (SupplementalTaxRegistration)((SupplementalTaxRegistration.Builder)SupplementalTaxRegistration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSupplementalTaxRegistrationsResponse build() {
            return new ListSupplementalTaxRegistrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TaxSettingsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSupplementalTaxRegistrationsResponse> {
        public Builder nextToken(String var1);

        public Builder taxRegistrations(Collection<SupplementalTaxRegistration> var1);

        public Builder taxRegistrations(SupplementalTaxRegistration ... var1);

        public Builder taxRegistrations(Consumer<SupplementalTaxRegistration.Builder> ... var1);
    }
}

