/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.taxsettings.TaxSettingsAsyncClient;
import software.amazon.awssdk.services.taxsettings.internal.UserAgentUtils;
import software.amazon.awssdk.services.taxsettings.model.AccountDetails;
import software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsResponse;

public class ListTaxRegistrationsPublisher
implements SdkPublisher<ListTaxRegistrationsResponse> {
    private final TaxSettingsAsyncClient client;
    private final ListTaxRegistrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTaxRegistrationsPublisher(TaxSettingsAsyncClient client, ListTaxRegistrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTaxRegistrationsPublisher(TaxSettingsAsyncClient client, ListTaxRegistrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTaxRegistrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTaxRegistrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountDetails> accountDetails() {
        Function<ListTaxRegistrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountDetails() != null) {
                return response.accountDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTaxRegistrationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTaxRegistrationsResponseFetcher
    implements AsyncPageFetcher<ListTaxRegistrationsResponse> {
        private ListTaxRegistrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTaxRegistrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTaxRegistrationsResponse> nextPage(ListTaxRegistrationsResponse previousPage) {
            if (previousPage == null) {
                return ListTaxRegistrationsPublisher.this.client.listTaxRegistrations(ListTaxRegistrationsPublisher.this.firstRequest);
            }
            return ListTaxRegistrationsPublisher.this.client.listTaxRegistrations((ListTaxRegistrationsRequest)((Object)ListTaxRegistrationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

