/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.taxsettings.model.TaxExemption;
import software.amazon.awssdk.services.taxsettings.model.TaxExemptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaxExemptionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaxExemptionDetails> {
    private static final SdkField<Boolean> HERITAGE_OBTAINED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("heritageObtainedDetails").getter(TaxExemptionDetails.getter(TaxExemptionDetails::heritageObtainedDetails)).setter(TaxExemptionDetails.setter(Builder::heritageObtainedDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heritageObtainedDetails").build()}).build();
    private static final SdkField<String> HERITAGE_OBTAINED_PARENT_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("heritageObtainedParentEntity").getter(TaxExemptionDetails.getter(TaxExemptionDetails::heritageObtainedParentEntity)).setter(TaxExemptionDetails.setter(Builder::heritageObtainedParentEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heritageObtainedParentEntity").build()}).build();
    private static final SdkField<String> HERITAGE_OBTAINED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("heritageObtainedReason").getter(TaxExemptionDetails.getter(TaxExemptionDetails::heritageObtainedReason)).setter(TaxExemptionDetails.setter(Builder::heritageObtainedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heritageObtainedReason").build()}).build();
    private static final SdkField<List<TaxExemption>> TAX_EXEMPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taxExemptions").getter(TaxExemptionDetails.getter(TaxExemptionDetails::taxExemptions)).setter(TaxExemptionDetails.setter(Builder::taxExemptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxExemptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaxExemption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HERITAGE_OBTAINED_DETAILS_FIELD, HERITAGE_OBTAINED_PARENT_ENTITY_FIELD, HERITAGE_OBTAINED_REASON_FIELD, TAX_EXEMPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("heritageObtainedDetails", HERITAGE_OBTAINED_DETAILS_FIELD);
            this.put("heritageObtainedParentEntity", HERITAGE_OBTAINED_PARENT_ENTITY_FIELD);
            this.put("heritageObtainedReason", HERITAGE_OBTAINED_REASON_FIELD);
            this.put("taxExemptions", TAX_EXEMPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean heritageObtainedDetails;
    private final String heritageObtainedParentEntity;
    private final String heritageObtainedReason;
    private final List<TaxExemption> taxExemptions;

    private TaxExemptionDetails(BuilderImpl builder) {
        this.heritageObtainedDetails = builder.heritageObtainedDetails;
        this.heritageObtainedParentEntity = builder.heritageObtainedParentEntity;
        this.heritageObtainedReason = builder.heritageObtainedReason;
        this.taxExemptions = builder.taxExemptions;
    }

    public final Boolean heritageObtainedDetails() {
        return this.heritageObtainedDetails;
    }

    public final String heritageObtainedParentEntity() {
        return this.heritageObtainedParentEntity;
    }

    public final String heritageObtainedReason() {
        return this.heritageObtainedReason;
    }

    public final boolean hasTaxExemptions() {
        return this.taxExemptions != null && !(this.taxExemptions instanceof SdkAutoConstructList);
    }

    public final List<TaxExemption> taxExemptions() {
        return this.taxExemptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.heritageObtainedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.heritageObtainedParentEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.heritageObtainedReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaxExemptions() ? this.taxExemptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxExemptionDetails)) {
            return false;
        }
        TaxExemptionDetails other = (TaxExemptionDetails)obj;
        return Objects.equals(this.heritageObtainedDetails(), other.heritageObtainedDetails()) && Objects.equals(this.heritageObtainedParentEntity(), other.heritageObtainedParentEntity()) && Objects.equals(this.heritageObtainedReason(), other.heritageObtainedReason()) && this.hasTaxExemptions() == other.hasTaxExemptions() && Objects.equals(this.taxExemptions(), other.taxExemptions());
    }

    public final String toString() {
        return ToString.builder((String)"TaxExemptionDetails").add("HeritageObtainedDetails", (Object)this.heritageObtainedDetails()).add("HeritageObtainedParentEntity", (Object)this.heritageObtainedParentEntity()).add("HeritageObtainedReason", (Object)this.heritageObtainedReason()).add("TaxExemptions", this.hasTaxExemptions() ? this.taxExemptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "heritageObtainedDetails": {
                return Optional.ofNullable(clazz.cast(this.heritageObtainedDetails()));
            }
            case "heritageObtainedParentEntity": {
                return Optional.ofNullable(clazz.cast(this.heritageObtainedParentEntity()));
            }
            case "heritageObtainedReason": {
                return Optional.ofNullable(clazz.cast(this.heritageObtainedReason()));
            }
            case "taxExemptions": {
                return Optional.ofNullable(clazz.cast(this.taxExemptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TaxExemptionDetails, T> g) {
        return obj -> g.apply((TaxExemptionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean heritageObtainedDetails;
        private String heritageObtainedParentEntity;
        private String heritageObtainedReason;
        private List<TaxExemption> taxExemptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaxExemptionDetails model) {
            this.heritageObtainedDetails(model.heritageObtainedDetails);
            this.heritageObtainedParentEntity(model.heritageObtainedParentEntity);
            this.heritageObtainedReason(model.heritageObtainedReason);
            this.taxExemptions(model.taxExemptions);
        }

        public final Boolean getHeritageObtainedDetails() {
            return this.heritageObtainedDetails;
        }

        public final void setHeritageObtainedDetails(Boolean heritageObtainedDetails) {
            this.heritageObtainedDetails = heritageObtainedDetails;
        }

        @Override
        public final Builder heritageObtainedDetails(Boolean heritageObtainedDetails) {
            this.heritageObtainedDetails = heritageObtainedDetails;
            return this;
        }

        public final String getHeritageObtainedParentEntity() {
            return this.heritageObtainedParentEntity;
        }

        public final void setHeritageObtainedParentEntity(String heritageObtainedParentEntity) {
            this.heritageObtainedParentEntity = heritageObtainedParentEntity;
        }

        @Override
        public final Builder heritageObtainedParentEntity(String heritageObtainedParentEntity) {
            this.heritageObtainedParentEntity = heritageObtainedParentEntity;
            return this;
        }

        public final String getHeritageObtainedReason() {
            return this.heritageObtainedReason;
        }

        public final void setHeritageObtainedReason(String heritageObtainedReason) {
            this.heritageObtainedReason = heritageObtainedReason;
        }

        @Override
        public final Builder heritageObtainedReason(String heritageObtainedReason) {
            this.heritageObtainedReason = heritageObtainedReason;
            return this;
        }

        public final List<TaxExemption.Builder> getTaxExemptions() {
            List<TaxExemption.Builder> result = TaxExemptionsCopier.copyToBuilder(this.taxExemptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaxExemptions(Collection<TaxExemption.BuilderImpl> taxExemptions) {
            this.taxExemptions = TaxExemptionsCopier.copyFromBuilder(taxExemptions);
        }

        @Override
        public final Builder taxExemptions(Collection<TaxExemption> taxExemptions) {
            this.taxExemptions = TaxExemptionsCopier.copy(taxExemptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxExemptions(TaxExemption ... taxExemptions) {
            this.taxExemptions(Arrays.asList(taxExemptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxExemptions(Consumer<TaxExemption.Builder> ... taxExemptions) {
            this.taxExemptions(Stream.of(taxExemptions).map(c -> (TaxExemption)((TaxExemption.Builder)TaxExemption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TaxExemptionDetails build() {
            return new TaxExemptionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaxExemptionDetails> {
        public Builder heritageObtainedDetails(Boolean var1);

        public Builder heritageObtainedParentEntity(String var1);

        public Builder heritageObtainedReason(String var1);

        public Builder taxExemptions(Collection<TaxExemption> var1);

        public Builder taxExemptions(TaxExemption ... var1);

        public Builder taxExemptions(Consumer<TaxExemption.Builder> ... var1);
    }
}

