/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.taxsettings.model.IsraelCustomerType;
import software.amazon.awssdk.services.taxsettings.model.IsraelDealerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IsraelAdditionalInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IsraelAdditionalInfo> {
    private static final SdkField<String> CUSTOMER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerType").getter(IsraelAdditionalInfo.getter(IsraelAdditionalInfo::customerTypeAsString)).setter(IsraelAdditionalInfo.setter(Builder::customerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerType").build()}).build();
    private static final SdkField<String> DEALER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dealerType").getter(IsraelAdditionalInfo.getter(IsraelAdditionalInfo::dealerTypeAsString)).setter(IsraelAdditionalInfo.setter(Builder::dealerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dealerType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_TYPE_FIELD, DEALER_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String customerType;
    private final String dealerType;

    private IsraelAdditionalInfo(BuilderImpl builder) {
        this.customerType = builder.customerType;
        this.dealerType = builder.dealerType;
    }

    public final IsraelCustomerType customerType() {
        return IsraelCustomerType.fromValue(this.customerType);
    }

    public final String customerTypeAsString() {
        return this.customerType;
    }

    public final IsraelDealerType dealerType() {
        return IsraelDealerType.fromValue(this.dealerType);
    }

    public final String dealerTypeAsString() {
        return this.dealerType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dealerTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsraelAdditionalInfo)) {
            return false;
        }
        IsraelAdditionalInfo other = (IsraelAdditionalInfo)obj;
        return Objects.equals(this.customerTypeAsString(), other.customerTypeAsString()) && Objects.equals(this.dealerTypeAsString(), other.dealerTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IsraelAdditionalInfo").add("CustomerType", (Object)this.customerTypeAsString()).add("DealerType", (Object)this.dealerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customerType": {
                return Optional.ofNullable(clazz.cast(this.customerTypeAsString()));
            }
            case "dealerType": {
                return Optional.ofNullable(clazz.cast(this.dealerTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IsraelAdditionalInfo, T> g) {
        return obj -> g.apply((IsraelAdditionalInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customerType;
        private String dealerType;

        private BuilderImpl() {
        }

        private BuilderImpl(IsraelAdditionalInfo model) {
            this.customerType(model.customerType);
            this.dealerType(model.dealerType);
        }

        public final String getCustomerType() {
            return this.customerType;
        }

        public final void setCustomerType(String customerType) {
            this.customerType = customerType;
        }

        @Override
        public final Builder customerType(String customerType) {
            this.customerType = customerType;
            return this;
        }

        @Override
        public final Builder customerType(IsraelCustomerType customerType) {
            this.customerType(customerType == null ? null : customerType.toString());
            return this;
        }

        public final String getDealerType() {
            return this.dealerType;
        }

        public final void setDealerType(String dealerType) {
            this.dealerType = dealerType;
        }

        @Override
        public final Builder dealerType(String dealerType) {
            this.dealerType = dealerType;
            return this;
        }

        @Override
        public final Builder dealerType(IsraelDealerType dealerType) {
            this.dealerType(dealerType == null ? null : dealerType.toString());
            return this;
        }

        public IsraelAdditionalInfo build() {
            return new IsraelAdditionalInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IsraelAdditionalInfo> {
        public Builder customerType(String var1);

        public Builder customerType(IsraelCustomerType var1);

        public Builder dealerType(String var1);

        public Builder dealerType(IsraelDealerType var1);
    }
}

