/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.taxsettings.TaxSettingsClient;
import software.amazon.awssdk.services.taxsettings.internal.UserAgentUtils;
import software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsResponse;
import software.amazon.awssdk.services.taxsettings.model.TaxExemptionDetails;

public class ListTaxExemptionsIterable
implements SdkIterable<ListTaxExemptionsResponse> {
    private final TaxSettingsClient client;
    private final ListTaxExemptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTaxExemptionsIterable(TaxSettingsClient client, ListTaxExemptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTaxExemptionsResponseFetcher();
    }

    public Iterator<ListTaxExemptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Map.Entry<String, TaxExemptionDetails>> taxExemptionDetailsMap() {
        Function<ListTaxExemptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.taxExemptionDetailsMap() != null) {
                return response.taxExemptionDetailsMap().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTaxExemptionsResponseFetcher
    implements SyncPageFetcher<ListTaxExemptionsResponse> {
        private ListTaxExemptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTaxExemptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTaxExemptionsResponse nextPage(ListTaxExemptionsResponse previousPage) {
            if (previousPage == null) {
                return ListTaxExemptionsIterable.this.client.listTaxExemptions(ListTaxExemptionsIterable.this.firstRequest);
            }
            return ListTaxExemptionsIterable.this.client.listTaxExemptions((ListTaxExemptionsRequest)((Object)ListTaxExemptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

