/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.taxsettings.model.AdditionalInfoResponse;
import software.amazon.awssdk.services.taxsettings.model.Jurisdiction;
import software.amazon.awssdk.services.taxsettings.model.Sector;
import software.amazon.awssdk.services.taxsettings.model.TaxDocumentMetadata;
import software.amazon.awssdk.services.taxsettings.model.TaxDocumentMetadatasCopier;
import software.amazon.awssdk.services.taxsettings.model.TaxRegistrationStatus;
import software.amazon.awssdk.services.taxsettings.model.TaxRegistrationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaxRegistrationWithJurisdiction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaxRegistrationWithJurisdiction> {
    private static final SdkField<AdditionalInfoResponse> ADDITIONAL_TAX_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("additionalTaxInformation").getter(TaxRegistrationWithJurisdiction.getter(TaxRegistrationWithJurisdiction::additionalTaxInformation)).setter(TaxRegistrationWithJurisdiction.setter(Builder::additionalTaxInformation)).constructor(AdditionalInfoResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalTaxInformation").build()}).build();
    private static final SdkField<String> CERTIFIED_EMAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certifiedEmailId").getter(TaxRegistrationWithJurisdiction.getter(TaxRegistrationWithJurisdiction::certifiedEmailId)).setter(TaxRegistrationWithJurisdiction.setter(Builder::certifiedEmailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certifiedEmailId").build()}).build();
    private static final SdkField<Jurisdiction> JURISDICTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jurisdiction").getter(TaxRegistrationWithJurisdiction.getter(TaxRegistrationWithJurisdiction::jurisdiction)).setter(TaxRegistrationWithJurisdiction.setter(Builder::jurisdiction)).constructor(Jurisdiction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jurisdiction").build()}).build();
    private static final SdkField<String> LEGAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("legalName").getter(TaxRegistrationWithJurisdiction.getter(TaxRegistrationWithJurisdiction::legalName)).setter(TaxRegistrationWithJurisdiction.setter(Builder::legalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalName").build()}).build();
    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationId").getter(TaxRegistrationWithJurisdiction.getter(TaxRegistrationWithJurisdiction::registrationId)).setter(TaxRegistrationWithJurisdiction.setter(Builder::registrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationId").build()}).build();
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationType").getter(TaxRegistrationWithJurisdiction.getter(TaxRegistrationWithJurisdiction::registrationTypeAsString)).setter(TaxRegistrationWithJurisdiction.setter(Builder::registrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationType").build()}).build();
    private static final SdkField<String> SECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sector").getter(TaxRegistrationWithJurisdiction.getter(TaxRegistrationWithJurisdiction::sectorAsString)).setter(TaxRegistrationWithJurisdiction.setter(Builder::sector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sector").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TaxRegistrationWithJurisdiction.getter(TaxRegistrationWithJurisdiction::statusAsString)).setter(TaxRegistrationWithJurisdiction.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<TaxDocumentMetadata>> TAX_DOCUMENT_METADATAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taxDocumentMetadatas").getter(TaxRegistrationWithJurisdiction.getter(TaxRegistrationWithJurisdiction::taxDocumentMetadatas)).setter(TaxRegistrationWithJurisdiction.setter(Builder::taxDocumentMetadatas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxDocumentMetadatas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaxDocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_TAX_INFORMATION_FIELD, CERTIFIED_EMAIL_ID_FIELD, JURISDICTION_FIELD, LEGAL_NAME_FIELD, REGISTRATION_ID_FIELD, REGISTRATION_TYPE_FIELD, SECTOR_FIELD, STATUS_FIELD, TAX_DOCUMENT_METADATAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("additionalTaxInformation", ADDITIONAL_TAX_INFORMATION_FIELD);
            this.put("certifiedEmailId", CERTIFIED_EMAIL_ID_FIELD);
            this.put("jurisdiction", JURISDICTION_FIELD);
            this.put("legalName", LEGAL_NAME_FIELD);
            this.put("registrationId", REGISTRATION_ID_FIELD);
            this.put("registrationType", REGISTRATION_TYPE_FIELD);
            this.put("sector", SECTOR_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("taxDocumentMetadatas", TAX_DOCUMENT_METADATAS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AdditionalInfoResponse additionalTaxInformation;
    private final String certifiedEmailId;
    private final Jurisdiction jurisdiction;
    private final String legalName;
    private final String registrationId;
    private final String registrationType;
    private final String sector;
    private final String status;
    private final List<TaxDocumentMetadata> taxDocumentMetadatas;

    private TaxRegistrationWithJurisdiction(BuilderImpl builder) {
        this.additionalTaxInformation = builder.additionalTaxInformation;
        this.certifiedEmailId = builder.certifiedEmailId;
        this.jurisdiction = builder.jurisdiction;
        this.legalName = builder.legalName;
        this.registrationId = builder.registrationId;
        this.registrationType = builder.registrationType;
        this.sector = builder.sector;
        this.status = builder.status;
        this.taxDocumentMetadatas = builder.taxDocumentMetadatas;
    }

    public final AdditionalInfoResponse additionalTaxInformation() {
        return this.additionalTaxInformation;
    }

    public final String certifiedEmailId() {
        return this.certifiedEmailId;
    }

    public final Jurisdiction jurisdiction() {
        return this.jurisdiction;
    }

    public final String legalName() {
        return this.legalName;
    }

    public final String registrationId() {
        return this.registrationId;
    }

    public final TaxRegistrationType registrationType() {
        return TaxRegistrationType.fromValue(this.registrationType);
    }

    public final String registrationTypeAsString() {
        return this.registrationType;
    }

    public final Sector sector() {
        return Sector.fromValue(this.sector);
    }

    public final String sectorAsString() {
        return this.sector;
    }

    public final TaxRegistrationStatus status() {
        return TaxRegistrationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTaxDocumentMetadatas() {
        return this.taxDocumentMetadatas != null && !(this.taxDocumentMetadatas instanceof SdkAutoConstructList);
    }

    public final List<TaxDocumentMetadata> taxDocumentMetadatas() {
        return this.taxDocumentMetadatas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalTaxInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.certifiedEmailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jurisdiction());
        hashCode = 31 * hashCode + Objects.hashCode(this.legalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaxDocumentMetadatas() ? this.taxDocumentMetadatas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxRegistrationWithJurisdiction)) {
            return false;
        }
        TaxRegistrationWithJurisdiction other = (TaxRegistrationWithJurisdiction)obj;
        return Objects.equals(this.additionalTaxInformation(), other.additionalTaxInformation()) && Objects.equals(this.certifiedEmailId(), other.certifiedEmailId()) && Objects.equals(this.jurisdiction(), other.jurisdiction()) && Objects.equals(this.legalName(), other.legalName()) && Objects.equals(this.registrationId(), other.registrationId()) && Objects.equals(this.registrationTypeAsString(), other.registrationTypeAsString()) && Objects.equals(this.sectorAsString(), other.sectorAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTaxDocumentMetadatas() == other.hasTaxDocumentMetadatas() && Objects.equals(this.taxDocumentMetadatas(), other.taxDocumentMetadatas());
    }

    public final String toString() {
        return ToString.builder((String)"TaxRegistrationWithJurisdiction").add("AdditionalTaxInformation", (Object)this.additionalTaxInformation()).add("CertifiedEmailId", (Object)this.certifiedEmailId()).add("Jurisdiction", (Object)this.jurisdiction()).add("LegalName", (Object)this.legalName()).add("RegistrationId", (Object)this.registrationId()).add("RegistrationType", (Object)this.registrationTypeAsString()).add("Sector", (Object)this.sectorAsString()).add("Status", (Object)this.statusAsString()).add("TaxDocumentMetadatas", this.hasTaxDocumentMetadatas() ? this.taxDocumentMetadatas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalTaxInformation": {
                return Optional.ofNullable(clazz.cast(this.additionalTaxInformation()));
            }
            case "certifiedEmailId": {
                return Optional.ofNullable(clazz.cast(this.certifiedEmailId()));
            }
            case "jurisdiction": {
                return Optional.ofNullable(clazz.cast(this.jurisdiction()));
            }
            case "legalName": {
                return Optional.ofNullable(clazz.cast(this.legalName()));
            }
            case "registrationId": {
                return Optional.ofNullable(clazz.cast(this.registrationId()));
            }
            case "registrationType": {
                return Optional.ofNullable(clazz.cast(this.registrationTypeAsString()));
            }
            case "sector": {
                return Optional.ofNullable(clazz.cast(this.sectorAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "taxDocumentMetadatas": {
                return Optional.ofNullable(clazz.cast(this.taxDocumentMetadatas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TaxRegistrationWithJurisdiction, T> g) {
        return obj -> g.apply((TaxRegistrationWithJurisdiction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AdditionalInfoResponse additionalTaxInformation;
        private String certifiedEmailId;
        private Jurisdiction jurisdiction;
        private String legalName;
        private String registrationId;
        private String registrationType;
        private String sector;
        private String status;
        private List<TaxDocumentMetadata> taxDocumentMetadatas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaxRegistrationWithJurisdiction model) {
            this.additionalTaxInformation(model.additionalTaxInformation);
            this.certifiedEmailId(model.certifiedEmailId);
            this.jurisdiction(model.jurisdiction);
            this.legalName(model.legalName);
            this.registrationId(model.registrationId);
            this.registrationType(model.registrationType);
            this.sector(model.sector);
            this.status(model.status);
            this.taxDocumentMetadatas(model.taxDocumentMetadatas);
        }

        public final AdditionalInfoResponse.Builder getAdditionalTaxInformation() {
            return this.additionalTaxInformation != null ? this.additionalTaxInformation.toBuilder() : null;
        }

        public final void setAdditionalTaxInformation(AdditionalInfoResponse.BuilderImpl additionalTaxInformation) {
            this.additionalTaxInformation = additionalTaxInformation != null ? additionalTaxInformation.build() : null;
        }

        @Override
        public final Builder additionalTaxInformation(AdditionalInfoResponse additionalTaxInformation) {
            this.additionalTaxInformation = additionalTaxInformation;
            return this;
        }

        public final String getCertifiedEmailId() {
            return this.certifiedEmailId;
        }

        public final void setCertifiedEmailId(String certifiedEmailId) {
            this.certifiedEmailId = certifiedEmailId;
        }

        @Override
        public final Builder certifiedEmailId(String certifiedEmailId) {
            this.certifiedEmailId = certifiedEmailId;
            return this;
        }

        public final Jurisdiction.Builder getJurisdiction() {
            return this.jurisdiction != null ? this.jurisdiction.toBuilder() : null;
        }

        public final void setJurisdiction(Jurisdiction.BuilderImpl jurisdiction) {
            this.jurisdiction = jurisdiction != null ? jurisdiction.build() : null;
        }

        @Override
        public final Builder jurisdiction(Jurisdiction jurisdiction) {
            this.jurisdiction = jurisdiction;
            return this;
        }

        public final String getLegalName() {
            return this.legalName;
        }

        public final void setLegalName(String legalName) {
            this.legalName = legalName;
        }

        @Override
        public final Builder legalName(String legalName) {
            this.legalName = legalName;
            return this;
        }

        public final String getRegistrationId() {
            return this.registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getRegistrationType() {
            return this.registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        @Override
        public final Builder registrationType(TaxRegistrationType registrationType) {
            this.registrationType(registrationType == null ? null : registrationType.toString());
            return this;
        }

        public final String getSector() {
            return this.sector;
        }

        public final void setSector(String sector) {
            this.sector = sector;
        }

        @Override
        public final Builder sector(String sector) {
            this.sector = sector;
            return this;
        }

        @Override
        public final Builder sector(Sector sector) {
            this.sector(sector == null ? null : sector.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaxRegistrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<TaxDocumentMetadata.Builder> getTaxDocumentMetadatas() {
            List<TaxDocumentMetadata.Builder> result = TaxDocumentMetadatasCopier.copyToBuilder(this.taxDocumentMetadatas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaxDocumentMetadatas(Collection<TaxDocumentMetadata.BuilderImpl> taxDocumentMetadatas) {
            this.taxDocumentMetadatas = TaxDocumentMetadatasCopier.copyFromBuilder(taxDocumentMetadatas);
        }

        @Override
        public final Builder taxDocumentMetadatas(Collection<TaxDocumentMetadata> taxDocumentMetadatas) {
            this.taxDocumentMetadatas = TaxDocumentMetadatasCopier.copy(taxDocumentMetadatas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxDocumentMetadatas(TaxDocumentMetadata ... taxDocumentMetadatas) {
            this.taxDocumentMetadatas(Arrays.asList(taxDocumentMetadatas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxDocumentMetadatas(Consumer<TaxDocumentMetadata.Builder> ... taxDocumentMetadatas) {
            this.taxDocumentMetadatas(Stream.of(taxDocumentMetadatas).map(c -> (TaxDocumentMetadata)((TaxDocumentMetadata.Builder)TaxDocumentMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TaxRegistrationWithJurisdiction build() {
            return new TaxRegistrationWithJurisdiction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaxRegistrationWithJurisdiction> {
        public Builder additionalTaxInformation(AdditionalInfoResponse var1);

        default public Builder additionalTaxInformation(Consumer<AdditionalInfoResponse.Builder> additionalTaxInformation) {
            return this.additionalTaxInformation((AdditionalInfoResponse)((AdditionalInfoResponse.Builder)AdditionalInfoResponse.builder().applyMutation(additionalTaxInformation)).build());
        }

        public Builder certifiedEmailId(String var1);

        public Builder jurisdiction(Jurisdiction var1);

        default public Builder jurisdiction(Consumer<Jurisdiction.Builder> jurisdiction) {
            return this.jurisdiction((Jurisdiction)((Jurisdiction.Builder)Jurisdiction.builder().applyMutation(jurisdiction)).build());
        }

        public Builder legalName(String var1);

        public Builder registrationId(String var1);

        public Builder registrationType(String var1);

        public Builder registrationType(TaxRegistrationType var1);

        public Builder sector(String var1);

        public Builder sector(Sector var1);

        public Builder status(String var1);

        public Builder status(TaxRegistrationStatus var1);

        public Builder taxDocumentMetadatas(Collection<TaxDocumentMetadata> var1);

        public Builder taxDocumentMetadatas(TaxDocumentMetadata ... var1);

        public Builder taxDocumentMetadatas(Consumer<TaxDocumentMetadata.Builder> ... var1);
    }
}

