/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.taxsettings.model.Authority;
import software.amazon.awssdk.services.taxsettings.model.EntityExemptionAccountStatus;
import software.amazon.awssdk.services.taxsettings.model.TaxExemptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaxExemption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaxExemption> {
    private static final SdkField<Authority> AUTHORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authority").getter(TaxExemption.getter(TaxExemption::authority)).setter(TaxExemption.setter(Builder::authority)).constructor(Authority::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authority").build()}).build();
    private static final SdkField<Instant> EFFECTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("effectiveDate").getter(TaxExemption.getter(TaxExemption::effectiveDate)).setter(TaxExemption.setter(Builder::effectiveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveDate").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expirationDate").getter(TaxExemption.getter(TaxExemption::expirationDate)).setter(TaxExemption.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TaxExemption.getter(TaxExemption::statusAsString)).setter(TaxExemption.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> SYSTEM_EFFECTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("systemEffectiveDate").getter(TaxExemption.getter(TaxExemption::systemEffectiveDate)).setter(TaxExemption.setter(Builder::systemEffectiveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemEffectiveDate").build()}).build();
    private static final SdkField<TaxExemptionType> TAX_EXEMPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taxExemptionType").getter(TaxExemption.getter(TaxExemption::taxExemptionType)).setter(TaxExemption.setter(Builder::taxExemptionType)).constructor(TaxExemptionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxExemptionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORITY_FIELD, EFFECTIVE_DATE_FIELD, EXPIRATION_DATE_FIELD, STATUS_FIELD, SYSTEM_EFFECTIVE_DATE_FIELD, TAX_EXEMPTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("authority", AUTHORITY_FIELD);
            this.put("effectiveDate", EFFECTIVE_DATE_FIELD);
            this.put("expirationDate", EXPIRATION_DATE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("systemEffectiveDate", SYSTEM_EFFECTIVE_DATE_FIELD);
            this.put("taxExemptionType", TAX_EXEMPTION_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Authority authority;
    private final Instant effectiveDate;
    private final Instant expirationDate;
    private final String status;
    private final Instant systemEffectiveDate;
    private final TaxExemptionType taxExemptionType;

    private TaxExemption(BuilderImpl builder) {
        this.authority = builder.authority;
        this.effectiveDate = builder.effectiveDate;
        this.expirationDate = builder.expirationDate;
        this.status = builder.status;
        this.systemEffectiveDate = builder.systemEffectiveDate;
        this.taxExemptionType = builder.taxExemptionType;
    }

    public final Authority authority() {
        return this.authority;
    }

    public final Instant effectiveDate() {
        return this.effectiveDate;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public final EntityExemptionAccountStatus status() {
        return EntityExemptionAccountStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant systemEffectiveDate() {
        return this.systemEffectiveDate;
    }

    public final TaxExemptionType taxExemptionType() {
        return this.taxExemptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authority());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemEffectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxExemptionType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxExemption)) {
            return false;
        }
        TaxExemption other = (TaxExemption)obj;
        return Objects.equals(this.authority(), other.authority()) && Objects.equals(this.effectiveDate(), other.effectiveDate()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.systemEffectiveDate(), other.systemEffectiveDate()) && Objects.equals(this.taxExemptionType(), other.taxExemptionType());
    }

    public final String toString() {
        return ToString.builder((String)"TaxExemption").add("Authority", (Object)this.authority()).add("EffectiveDate", (Object)this.effectiveDate()).add("ExpirationDate", (Object)this.expirationDate()).add("Status", (Object)this.statusAsString()).add("SystemEffectiveDate", (Object)this.systemEffectiveDate()).add("TaxExemptionType", (Object)this.taxExemptionType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authority": {
                return Optional.ofNullable(clazz.cast(this.authority()));
            }
            case "effectiveDate": {
                return Optional.ofNullable(clazz.cast(this.effectiveDate()));
            }
            case "expirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "systemEffectiveDate": {
                return Optional.ofNullable(clazz.cast(this.systemEffectiveDate()));
            }
            case "taxExemptionType": {
                return Optional.ofNullable(clazz.cast(this.taxExemptionType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TaxExemption, T> g) {
        return obj -> g.apply((TaxExemption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Authority authority;
        private Instant effectiveDate;
        private Instant expirationDate;
        private String status;
        private Instant systemEffectiveDate;
        private TaxExemptionType taxExemptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxExemption model) {
            this.authority(model.authority);
            this.effectiveDate(model.effectiveDate);
            this.expirationDate(model.expirationDate);
            this.status(model.status);
            this.systemEffectiveDate(model.systemEffectiveDate);
            this.taxExemptionType(model.taxExemptionType);
        }

        public final Authority.Builder getAuthority() {
            return this.authority != null ? this.authority.toBuilder() : null;
        }

        public final void setAuthority(Authority.BuilderImpl authority) {
            this.authority = authority != null ? authority.build() : null;
        }

        @Override
        public final Builder authority(Authority authority) {
            this.authority = authority;
            return this;
        }

        public final Instant getEffectiveDate() {
            return this.effectiveDate;
        }

        public final void setEffectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        @Override
        public final Builder effectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityExemptionAccountStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getSystemEffectiveDate() {
            return this.systemEffectiveDate;
        }

        public final void setSystemEffectiveDate(Instant systemEffectiveDate) {
            this.systemEffectiveDate = systemEffectiveDate;
        }

        @Override
        public final Builder systemEffectiveDate(Instant systemEffectiveDate) {
            this.systemEffectiveDate = systemEffectiveDate;
            return this;
        }

        public final TaxExemptionType.Builder getTaxExemptionType() {
            return this.taxExemptionType != null ? this.taxExemptionType.toBuilder() : null;
        }

        public final void setTaxExemptionType(TaxExemptionType.BuilderImpl taxExemptionType) {
            this.taxExemptionType = taxExemptionType != null ? taxExemptionType.build() : null;
        }

        @Override
        public final Builder taxExemptionType(TaxExemptionType taxExemptionType) {
            this.taxExemptionType = taxExemptionType;
            return this;
        }

        public TaxExemption build() {
            return new TaxExemption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaxExemption> {
        public Builder authority(Authority var1);

        default public Builder authority(Consumer<Authority.Builder> authority) {
            return this.authority((Authority)((Authority.Builder)Authority.builder().applyMutation(authority)).build());
        }

        public Builder effectiveDate(Instant var1);

        public Builder expirationDate(Instant var1);

        public Builder status(String var1);

        public Builder status(EntityExemptionAccountStatus var1);

        public Builder systemEffectiveDate(Instant var1);

        public Builder taxExemptionType(TaxExemptionType var1);

        default public Builder taxExemptionType(Consumer<TaxExemptionType.Builder> taxExemptionType) {
            return this.taxExemptionType((TaxExemptionType)((TaxExemptionType.Builder)TaxExemptionType.builder().applyMutation(taxExemptionType)).build());
        }
    }
}

