/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.taxsettings.model.TaxRegistrationStatus;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSupplementalTaxRegistrationResponse
extends TaxSettingsResponse
implements ToCopyableBuilder<Builder, PutSupplementalTaxRegistrationResponse> {
    private static final SdkField<String> AUTHORITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorityId").getter(PutSupplementalTaxRegistrationResponse.getter(PutSupplementalTaxRegistrationResponse::authorityId)).setter(PutSupplementalTaxRegistrationResponse.setter(Builder::authorityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorityId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PutSupplementalTaxRegistrationResponse.getter(PutSupplementalTaxRegistrationResponse::statusAsString)).setter(PutSupplementalTaxRegistrationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORITY_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("authorityId", AUTHORITY_ID_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private final String authorityId;
    private final String status;

    private PutSupplementalTaxRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.authorityId = builder.authorityId;
        this.status = builder.status;
    }

    public final String authorityId() {
        return this.authorityId;
    }

    public final TaxRegistrationStatus status() {
        return TaxRegistrationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authorityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSupplementalTaxRegistrationResponse)) {
            return false;
        }
        PutSupplementalTaxRegistrationResponse other = (PutSupplementalTaxRegistrationResponse)((Object)obj);
        return Objects.equals(this.authorityId(), other.authorityId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutSupplementalTaxRegistrationResponse").add("AuthorityId", (Object)this.authorityId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorityId": {
                return Optional.ofNullable(clazz.cast(this.authorityId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutSupplementalTaxRegistrationResponse, T> g) {
        return obj -> g.apply((PutSupplementalTaxRegistrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TaxSettingsResponse.BuilderImpl
    implements Builder {
        private String authorityId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSupplementalTaxRegistrationResponse model) {
            super(model);
            this.authorityId(model.authorityId);
            this.status(model.status);
        }

        public final String getAuthorityId() {
            return this.authorityId;
        }

        public final void setAuthorityId(String authorityId) {
            this.authorityId = authorityId;
        }

        @Override
        public final Builder authorityId(String authorityId) {
            this.authorityId = authorityId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaxRegistrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public PutSupplementalTaxRegistrationResponse build() {
            return new PutSupplementalTaxRegistrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TaxSettingsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSupplementalTaxRegistrationResponse> {
        public Builder authorityId(String var1);

        public Builder status(String var1);

        public Builder status(TaxRegistrationStatus var1);
    }
}

